/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.spi;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.resources.semantic.spi.SfsSpiTraceLocation;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.RegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticFileSystemSpiCore
implements IRegistryChangeListener {
    private static final String PI_FOLDER_MAPPING = "pathContentProviderMapping";
    private static final SemanticFileSystemSpiCore INSTANCE = new SemanticFileSystemSpiCore();
    private HashMap<IPath, String> pathMappings;

    public static SemanticFileSystemSpiCore getInstance() {
        return INSTANCE;
    }

    private SemanticFileSystemSpiCore() {
        RegistryFactory.getRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] mappingChanges;
        if (SfsSpiTraceLocation.CORE.isActive()) {
            SfsSpiTraceLocation.getTrace().traceEntry(SfsSpiTraceLocation.CORE.getLocation());
        }
        if ((mappingChanges = event.getExtensionDeltas("org.eclipse.core.resources.semantic", PI_FOLDER_MAPPING)).length == 0) {
            return;
        }
        SemanticFileSystemSpiCore semanticFileSystemSpiCore = this;
        synchronized (semanticFileSystemSpiCore) {
            if (mappingChanges.length > 0) {
                this.pathMappings = null;
            }
        }
    }

    public String getFolderTemplateMapping(IPath path) {
        if (SfsSpiTraceLocation.CORE.isActive()) {
            SfsSpiTraceLocation.getTrace().traceEntry(SfsSpiTraceLocation.CORE.getLocation(), (Object)path.toString());
        }
        String result = this.getFolderMappingRegistry().get(path);
        if (SfsSpiTraceLocation.CORE.isActive()) {
            SfsSpiTraceLocation.getTrace().traceExit(SfsSpiTraceLocation.CORE.getLocation(), (Object)result);
        }
        return result;
    }

    private synchronized Map<IPath, String> getFolderMappingRegistry() {
        if (this.pathMappings == null) {
            this.pathMappings = new HashMap();
            IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint("org.eclipse.core.resources.semantic", PI_FOLDER_MAPPING);
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if ("mapping".equals(elements[j].getName())) {
                        String contentProviderID = elements[j].getAttribute("contentProviderId");
                        String path = elements[j].getAttribute("path");
                        if (contentProviderID != null && path != null) {
                            IPath relPath = new Path(path).makeRelative();
                            this.pathMappings.put(relPath, contentProviderID);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return this.pathMappings;
    }
}

