/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.cacheservice;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.resources.semantic.cacheservice.CacheService;
import org.eclipse.core.internal.resources.semantic.cacheservice.CachedFileHandle;
import org.eclipse.core.internal.resources.semantic.cacheservice.ICachedContentHandle;
import org.eclipse.core.internal.resources.semantic.cacheservice.IContentHandleFactory;
import org.eclipse.core.internal.resources.semantic.cacheservice.ITemporaryContentHandle;
import org.eclipse.core.internal.resources.semantic.cacheservice.Messages;
import org.eclipse.core.internal.resources.semantic.cacheservice.TemporaryFileHandle;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.spi.ICacheService;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHandleFactory
implements IContentHandleFactory {
    private static final String FAILED_DELETIONS_DOLLAR = ".failedDeletions.$$$";
    private static final String ALTERNATIVE_FILES_DOLLAR = ".alternativeFiles.$$$";
    private static final String FAILED_DELETIONS_OF_ALTERNATIVES_DOLLAR = ".failedDeletionsOfAlternatives.$$$";
    private static final String DOT_SEPARATOR = ".";
    private static final String TEMP_FILE_EXTENSION = ".$$$";
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock writeLock = this.rwl.writeLock();
    private HashSet<String> failedDeletions = new HashSet();
    private HashMap<String, String> activeAlternativeFileMapping = new HashMap();
    private HashSet<String> deletionsOfAlternatives = new HashSet();
    private final File deletionsFile;
    private final File alternativesMappingFile;
    private final File deletionsOfAlternativesFile;
    private final File cacheRoot;
    private long uniqueID = 0L;

    public FileHandleFactory(File cacheRoot) {
        this.cacheRoot = cacheRoot;
        this.deletionsFile = new File(this.cacheRoot, FAILED_DELETIONS_DOLLAR);
        this.alternativesMappingFile = new File(this.cacheRoot, ALTERNATIVE_FILES_DOLLAR);
        this.deletionsOfAlternativesFile = new File(this.cacheRoot, FAILED_DELETIONS_OF_ALTERNATIVES_DOLLAR);
        try {
            this.lockForWrite();
            this.load();
        }
        finally {
            this.unlockForWrite();
        }
    }

    private void lockForWrite() {
        this.writeLock.lock();
    }

    private void unlockForWrite() {
        this.writeLock.unlock();
    }

    private File getCacheFile(IPath path) {
        File cacheFile = new File(this.cacheRoot, path.toString());
        return cacheFile;
    }

    @Override
    public ICachedContentHandle createCacheContentHandle(ICacheService service, IPath path) {
        File cacheFile = new File(this.cacheRoot, path.toString());
        return new CachedFileHandle(this, cacheFile);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ITemporaryContentHandle createTemporaryHandle(ICacheService service, IPath path, boolean append) throws CoreException {
        this.lockForWrite();
        cacheFile = this.getCacheFile(path);
        if (append) {
            try {
                var8_5 = new TemporaryFileHandle(this, path, cacheFile, this.openOputputStream(cacheFile, append));
                return var8_5;
            }
            catch (IOException e) {
                throw new SemanticResourceException(SemanticResourceStatusCode.FILECACHE_CACHEFILE_CREATION_FAILED, path, null, e);
            }
        }
        ++this.uniqueID;
        tempFile = new File(this.cacheRoot, path + "." + this.uniqueID + ".$$$");
        ** while (tempFile.exists())
lbl-1000:
        // 1 sources

        {
            ++this.uniqueID;
            tempFile = new File(this.cacheRoot, path + "." + this.uniqueID + ".$$$");
            continue;
        }
lbl16:
        // 1 sources

        try {
            var8_6 = new TemporaryFileHandle(this, path, tempFile, cacheFile, this.openOputputStream(tempFile, append));
            return var8_6;
        }
        catch (IOException e) {
            throw new SemanticResourceException(SemanticResourceStatusCode.FILECACHE_CACHEFILE_CREATION_FAILED, path, null, e);
        }
        finally {
            this.unlockForWrite();
        }
    }

    @Override
    public void removeContentRecursive(CacheService cacheService, IPath path) {
        try {
            this.lockForWrite();
            File root = this.getCacheFile(path);
            if (root.exists() && !root.equals(this.cacheRoot)) {
                ArrayList<File> filesToBeDeleted = new ArrayList<File>();
                this.collectFiles(root, filesToBeDeleted);
                for (File file : filesToBeDeleted) {
                    if (file.delete()) continue;
                    this.reportDeletionFailed(file);
                }
                this.compactFileSystemRecursively(root);
                this.compactFileSystem(root);
            }
        }
        finally {
            this.unlockForWrite();
        }
    }

    private void collectFiles(File root, ArrayList<File> filesToBeDeleted) {
        if (root.isDirectory()) {
            File[] children = root.listFiles();
            if (children != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    if (child.isDirectory()) {
                        this.collectFiles(child, filesToBeDeleted);
                    } else {
                        filesToBeDeleted.add(child);
                    }
                    ++n2;
                }
            }
        } else if (root.exists()) {
            filesToBeDeleted.add(root);
        }
    }

    public void doRename(File source, File target) throws CoreException {
        try {
            this.lockForWrite();
            if (!this.cleanupBeforeRename(target)) {
                this.addAlternativeFile(source, target);
                return;
            }
            if (!source.renameTo(target)) {
                Path path = new Path(target.getAbsolutePath());
                throw new SemanticResourceException(SemanticResourceStatusCode.FILECACHE_CACHEFILE_RENAME_FAILED, (IPath)path, MessageFormat.format(Messages.FileHandleFactory_TempFileNotRenamed_XMSG, target.getAbsolutePath()));
            }
        }
        finally {
            this.unlockForWrite();
        }
    }

    private boolean cleanupBeforeRename(File target) {
        String targetPath = target.getAbsolutePath();
        this.tryToDeleteAlternativeFile(targetPath);
        this.retryToDeleteAlternatives();
        this.reportDeletionSucceeded(target);
        return !target.exists() || target.delete();
    }

    public boolean checkFileExists(File file) {
        try {
            this.lockForWrite();
            if (this.hasFailedDeletion(file)) {
                this.tryDelete(file);
                return false;
            }
            boolean bl = file.exists();
            return bl;
        }
        finally {
            this.unlockForWrite();
        }
    }

    public void tryDelete(File file) {
        try {
            this.lockForWrite();
            this.tryToDeleteAlternativeFile(file.getAbsolutePath());
            if (!file.delete()) {
                this.reportDeletionFailed(file);
                return;
            }
            this.reportDeletionSucceeded(file);
            this.retryToDeleteAlternatives();
            this.compactFileSystem(file);
        }
        finally {
            this.unlockForWrite();
        }
    }

    public File getActiveFileHandle(File file) {
        try {
            this.lockForWrite();
            String alternatePath = this.activeAlternativeFileMapping.get(file.getAbsolutePath());
            if (alternatePath != null) {
                File file2 = new File(alternatePath);
                return file2;
            }
            File file3 = file;
            return file3;
        }
        finally {
            this.unlockForWrite();
        }
    }

    public InputStream openInputStream(File cacheFile) throws FileNotFoundException {
        try {
            this.lockForWrite();
            FileInputStream fileInputStream = new FileInputStream(this.getActiveFileHandle(cacheFile));
            return fileInputStream;
        }
        finally {
            this.unlockForWrite();
        }
    }

    private void safeLog(CoreException e) {
        try {
            ISemanticFileSystem sfs = (ISemanticFileSystem)EFS.getFileSystem((String)"semanticfs");
            sfs.getLog().log(e);
        }
        catch (CoreException coreException) {}
    }

    private void compactFileSystem(File deletedFile) {
        File[] children;
        File parent = deletedFile.getParentFile();
        if (parent.exists() && !parent.equals(this.cacheRoot) && (children = parent.listFiles()) != null && children.length == 0) {
            parent.delete();
        }
        if (!parent.equals(this.cacheRoot)) {
            this.compactFileSystem(parent);
        }
    }

    private void compactFileSystemRecursively(File root) {
        File[] children = root.listFiles();
        if (children != null && children.length > 0) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.compactFileSystemRecursively(file);
                }
                ++n2;
            }
        }
        if ((children = root.listFiles()) != null && children.length == 0) {
            root.delete();
        }
    }

    private void retryToDeleteAlternatives() {
        boolean saveNeeded = false;
        HashSet<String> deletions = this.deletionsOfAlternatives;
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        for (String filePath : deletions) {
            File file = new File(filePath);
            if (file.exists()) {
                if (!file.delete()) continue;
                toBeRemoved.add(filePath);
                saveNeeded = true;
                continue;
            }
            saveNeeded = true;
            toBeRemoved.add(filePath);
        }
        for (String string : toBeRemoved) {
            deletions.remove(string);
        }
        if (saveNeeded) {
            this.saveDeletionsOfAlternatives();
        }
    }

    private void reportDeletionFailed(File file) {
        this.failedDeletions.add(file.getAbsolutePath());
        this.saveFailedDeletions();
    }

    private void reportDeletionSucceeded(File file) {
        String path = file.getAbsolutePath();
        if (this.failedDeletions.contains(path)) {
            this.failedDeletions.remove(path);
            this.saveFailedDeletions();
        }
    }

    private boolean hasFailedDeletion(File file) {
        return this.failedDeletions.contains(file.getAbsolutePath());
    }

    private OutputStream openOputputStream(File file, boolean appendMode) throws FileNotFoundException {
        file.getParentFile().mkdirs();
        return new FileOutputStream(file, appendMode);
    }

    private void addAlternativeFile(File source, File target) {
        this.activeAlternativeFileMapping.put(target.getAbsolutePath(), source.getAbsolutePath());
        this.saveAlternativeMapping();
    }

    private void tryToDeleteAlternativeFile(String targetPath) {
        String alternatePath = this.activeAlternativeFileMapping.get(targetPath);
        if (alternatePath != null) {
            File alternateFile = new File(alternatePath);
            if (!alternateFile.delete()) {
                this.deletionsOfAlternatives.add(alternatePath);
                this.saveDeletionsOfAlternatives();
            }
            this.activeAlternativeFileMapping.remove(targetPath);
            this.saveAlternativeMapping();
        }
    }

    private void saveFailedDeletions() {
        if (!this.failedDeletions.isEmpty()) {
            this.writeObjectToMetadataFile(this.deletionsFile, this.failedDeletions);
        } else {
            this.removeMetadataFile(this.deletionsFile);
        }
    }

    private void saveDeletionsOfAlternatives() {
        if (!this.deletionsOfAlternatives.isEmpty()) {
            this.writeObjectToMetadataFile(this.deletionsOfAlternativesFile, this.deletionsOfAlternatives);
        } else {
            this.removeMetadataFile(this.deletionsOfAlternativesFile);
        }
    }

    private void saveAlternativeMapping() {
        if (!this.activeAlternativeFileMapping.isEmpty()) {
            this.writeObjectToMetadataFile(this.alternativesMappingFile, this.activeAlternativeFileMapping);
        } else {
            this.removeMetadataFile(this.alternativesMappingFile);
        }
    }

    private void load() {
        Cloneable object;
        if (this.deletionsFile.exists() && (object = (HashSet)this.readObjectFromMetadataFile(this.deletionsFile)) != null) {
            this.failedDeletions = object;
        }
        if (this.deletionsOfAlternativesFile.exists() && (object = (HashSet)this.readObjectFromMetadataFile(this.deletionsOfAlternativesFile)) != null) {
            this.deletionsOfAlternatives = object;
        }
        if (this.alternativesMappingFile.exists() && (object = (HashMap)this.readObjectFromMetadataFile(this.alternativesMappingFile)) != null) {
            this.activeAlternativeFileMapping = object;
        }
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    private Object readObjectFromMetadataFile(File file) {
        Object object;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            object = ois.readObject();
        }
        catch (IOException e) {
            Path path = new Path(file.getAbsolutePath());
            this.safeLog(new SemanticResourceException(SemanticResourceStatusCode.FILECACHE_INITIALIZATION_ERROR, (IPath)path, Messages.FileHandleFactory_FileHandleFactory_LoadError_XMSG, e));
            Util.safeClose(fis);
            Util.safeClose(ois);
        }
        catch (ClassNotFoundException e2) {
            Path path = new Path(file.getAbsolutePath());
            this.safeLog(new SemanticResourceException(SemanticResourceStatusCode.FILECACHE_INITIALIZATION_ERROR, (IPath)path, Messages.FileHandleFactory_FileHandleFactory_LoadError_XMSG, e2));
            {
                catch (Throwable throwable) {
                    Util.safeClose(fis);
                    Util.safeClose(ois);
                    throw throwable;
                }
            }
            Util.safeClose(fis);
            Util.safeClose(ois);
        }
        Util.safeClose(fis);
        Util.safeClose(ois);
        return object;
        return null;
    }

    private void removeMetadataFile(File file) {
        if (file.exists() && !file.delete()) {
            Path path = new Path(file.getAbsolutePath());
            this.safeLog(new SemanticResourceException(SemanticResourceStatusCode.FILECACHE_ERROR_WRITING_METADATA, (IPath)path, Messages.FileHandleFactory_FileHandleFactory_FileHandleFactory_SaveError_XMSG));
        }
    }

    private void writeObjectToMetadataFile(File file, Object object) {
        block5: {
            FileOutputStream fos = null;
            ObjectOutputStream oos = null;
            try {
                try {
                    fos = new FileOutputStream(file);
                    oos = new ObjectOutputStream(fos);
                    oos.writeObject(object);
                }
                catch (IOException e) {
                    Path path = new Path(file.getAbsolutePath());
                    this.safeLog(new SemanticResourceException(SemanticResourceStatusCode.FILECACHE_ERROR_WRITING_METADATA, (IPath)path, Messages.FileHandleFactory_FileHandleFactory_FileHandleFactory_SaveError_XMSG, e));
                    Util.safeClose(fos);
                    Util.safeClose(oos);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Util.safeClose(fos);
                Util.safeClose(oos);
                throw throwable;
            }
            Util.safeClose(fos);
            Util.safeClose(oos);
        }
    }
}

