/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.demo.cheatsheets.search.internal.view.favorites;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.demo.cheatsheets.search.internal.runtime.ICheatSheet;
import org.eclipse.demo.cheatsheets.search.internal.runtime.ICheatSheetCategory;
import org.eclipse.demo.cheatsheets.search.internal.runtime.ICheatSheetItem;
import org.eclipse.demo.cheatsheets.search.internal.runtime.RootCSItem;
import org.eclipse.demo.cheatsheets.search.internal.slave.DeleteFromFavoritesAction;
import org.eclipse.demo.cheatsheets.search.internal.text.Messages;
import org.eclipse.demo.cheatsheets.search.internal.view.CheatSheetCustomization;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.platform.discovery.core.api.IContributedAction;
import org.eclipse.platform.discovery.ui.api.IResultsViewAccessor;
import org.eclipse.platform.discovery.ui.api.ISearchFavoritesViewCustomization;

public class FavoritesCustomization
extends CheatSheetCustomization
implements ISearchFavoritesViewCustomization {
    private static final ICheatSheetCategory CHEAT_SHEETS_GROUP_NODE = new RootCSItem(){

        @Override
        public String getName() {
            return Messages.FavoritesCustomization_CheatSheetGroupName;
        }
    };

    public Set<Object> itemsFor(Object itemsSource) {
        if (itemsSource instanceof ICheatSheet) {
            return new HashSet<Object>(Arrays.asList(itemsSource));
        }
        return Collections.emptySet();
    }

    public Object itemGroup(Object item) {
        if (item instanceof ICheatSheet) {
            return CHEAT_SHEETS_GROUP_NODE;
        }
        return null;
    }

    @Override
    public void installAction(IContributedAction contributedAction, IResultsViewAccessor viewAccessor) {
        super.installAction(contributedAction, viewAccessor);
        if (contributedAction.getActionId().equals(DeleteFromFavoritesAction.ACTION_ID)) {
            this.installDeleteCheatSheetMenuAction(contributedAction, viewAccessor);
        }
    }

    private void installDeleteCheatSheetMenuAction(final IContributedAction contributedAction, IResultsViewAccessor viewAccessor) {
        IStructuredSelection selection = (IStructuredSelection)viewAccessor.getTreeViewer().getSelection();
        if (selection.isEmpty() || selection.size() > 1) {
            return;
        }
        Object selectedObject = selection.getFirstElement();
        if (!(selectedObject instanceof ICheatSheetItem)) {
            return;
        }
        final HashSet<Object> oSet = new HashSet<Object>();
        oSet.add(selectedObject);
        Action action = new Action(){

            public void run() {
                contributedAction.perform(FavoritesCustomization.this.masterView.getEnvironment().operationRunner(), oSet);
            }
        };
        action.setText(Messages.DeleteFromFavorites);
        viewAccessor.getMenuManager().add((IAction)action);
    }
}

