/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathHelper;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.converter.PDEPluginConverter;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CreateManifestOperation
implements IRunnableWithProgress {
    private IPluginModelBase fModel;

    public CreateManifestOperation(IPluginModelBase model) {
        this.fModel = model;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.handleConvert();
            this.trimOldManifest();
        }
        catch (BadLocationException e) {
            throw new InvocationTargetException(e);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void handleConvert() throws CoreException {
        IProject project = this.fModel.getUnderlyingResource().getProject();
        String target = TargetPlatformHelper.getTargetVersionString();
        PDEPluginConverter.convertToOSGIFormat((IProject)project, (String)target, (Dictionary)ClasspathHelper.getDevDictionary((IPluginModelBase)this.fModel), (IProgressMonitor)new NullProgressMonitor());
    }

    private void trimOldManifest() throws BadLocationException, CoreException {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IProject project = this.fModel.getUnderlyingResource().getProject();
        IFile file = this.fModel.isFragmentModel() ? PDEProject.getFragmentXml((IProject)project) : PDEProject.getPluginXml((IProject)project);
        try {
            manager.connect(file.getFullPath(), LocationKind.NORMALIZE, null);
            ITextFileBuffer buffer = manager.getTextFileBuffer(file.getFullPath(), LocationKind.NORMALIZE);
            IDocument doc = buffer.getDocument();
            FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(doc);
            MultiTextEdit multiEdit = new MultiTextEdit();
            TextEdit edit = this.editRootElement(this.fModel.isFragmentModel() ? "fragment" : "plugin", adapter, doc, 0);
            if (edit != null) {
                multiEdit.addChild(edit);
            }
            if ((edit = this.removeElement("requires", adapter, doc, 0)) != null) {
                multiEdit.addChild(edit);
            }
            if ((edit = this.removeElement("runtime", adapter, doc, 0)) != null) {
                multiEdit.addChild(edit);
            }
            if (multiEdit.hasChildren()) {
                multiEdit.apply(doc);
                buffer.commit(null, true);
            }
        }
        finally {
            manager.disconnect(file.getFullPath(), LocationKind.NORMALIZE, null);
        }
    }

    private TextEdit editRootElement(String elementName, FindReplaceDocumentAdapter adapter, IDocument doc, int offset) throws BadLocationException {
        IRegion region = adapter.find(0, "<" + elementName + "[^>]*", true, true, false, true);
        if (region != null) {
            String replacementString = "<" + elementName;
            if (doc.getChar(region.getOffset() + region.getLength()) == '/') {
                replacementString = String.valueOf(replacementString) + "/";
            }
            return new ReplaceEdit(region.getOffset(), region.getLength(), replacementString);
        }
        return null;
    }

    private TextEdit removeElement(String elementName, FindReplaceDocumentAdapter adapter, IDocument doc, int offset) throws BadLocationException {
        IRegion region = adapter.find(0, "<" + elementName + "[^>]*", true, true, false, true);
        if (region != null) {
            if (doc.getChar(region.getOffset() + region.getLength()) == '/') {
                return new DeleteEdit(region.getOffset(), region.getLength() + 1);
            }
            IRegion endRegion = adapter.find(0, "</" + elementName + ">", true, true, false, true);
            if (endRegion != null) {
                int lastPos = endRegion.getOffset() + endRegion.getLength() + 1;
                while (Character.isWhitespace(doc.getChar(lastPos))) {
                    ++lastPos;
                }
                return new DeleteEdit(region.getOffset(), --lastPos - region.getOffset());
            }
        }
        return null;
    }
}

