/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.AbstractToStringGenerator;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CustomBuilderGenerator
extends AbstractToStringGenerator {
    private final List<String> primitiveTypes = Arrays.asList("byte", "short", "char", "int", "long", "float", "double", "boolean");
    private final String[] wrapperTypes = new String[]{"java.lang.Byte", "java.lang.Short", "java.lang.Character", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Boolean"};
    private boolean canChainLastAppendCall;
    private HashMap<String, AppendMethodInformation> appendMethodSpecificTypes = new HashMap();

    public RefactoringStatus checkConditions() {
        RefactoringStatus status = super.checkConditions();
        if (this.fContext.isCustomArray() || this.fContext.isLimitItems()) {
            status.addWarning(CodeGenerationMessages.GenerateToStringOperation_warning_no_arrays_collections_with_this_style);
        }
        return status;
    }

    protected void addElement(Object element) {
    }

    protected void initialize() {
        super.initialize();
        this.fillAppendMethodsMap();
        this.tidyAppendsMethodsMap();
    }

    public MethodDeclaration generateToStringMethod() throws CoreException {
        this.initialize();
        String builderVariableName = this.createNameSuggestion(this.getContext().getCustomBuilderVariableName(), 5);
        VariableDeclarationFragment fragment = this.fAst.newVariableDeclarationFragment();
        fragment.setName(this.fAst.newSimpleName(builderVariableName));
        ClassInstanceCreation classInstance = this.fAst.newClassInstanceCreation();
        Name typeName = this.addImport(this.getContext().getCustomBuilderClass());
        classInstance.setType((Type)this.fAst.newSimpleType(typeName));
        classInstance.arguments().add(this.fAst.newThisExpression());
        fragment.setInitializer((Expression)classInstance);
        VariableDeclarationStatement vStatement = this.fAst.newVariableDeclarationStatement(fragment);
        vStatement.setType((Type)this.fAst.newSimpleType((Name)ASTNode.copySubtree((AST)this.fAst, (ASTNode)typeName)));
        this.toStringMethod.getBody().statements().add(vStatement);
        MethodInvocation expression = null;
        int i = 0;
        while (i < this.getContext().getSelectedMembers().length) {
            MethodInvocation appendInvocation = this.createAppendMethodForMember(this.getContext().getSelectedMembers()[i]);
            if (this.getContext().isSkipNulls() && !this.getMemberType(this.getContext().getSelectedMembers()[i]).isPrimitive()) {
                if (expression != null) {
                    this.toStringMethod.getBody().statements().add(this.fAst.newExpressionStatement((Expression)expression));
                    expression = null;
                }
                appendInvocation.setExpression((Expression)this.fAst.newSimpleName(builderVariableName));
                IfStatement ifStatement = this.fAst.newIfStatement();
                ifStatement.setExpression((Expression)this.createInfixExpression(this.createMemberAccessExpression(this.getContext().getSelectedMembers()[i], true, true), InfixExpression.Operator.NOT_EQUALS, (Expression)this.fAst.newNullLiteral()));
                ifStatement.setThenStatement(this.createOneStatementBlock((Expression)appendInvocation));
                this.toStringMethod.getBody().statements().add(ifStatement);
            } else {
                if (expression != null) {
                    appendInvocation.setExpression(expression);
                } else {
                    appendInvocation.setExpression((Expression)this.fAst.newSimpleName(builderVariableName));
                }
                if (this.getContext().isCustomBuilderChainedCalls() && this.canChainLastAppendCall) {
                    expression = appendInvocation;
                } else {
                    expression = null;
                    this.toStringMethod.getBody().statements().add(this.fAst.newExpressionStatement((Expression)appendInvocation));
                }
            }
            ++i;
        }
        if (expression != null) {
            this.toStringMethod.getBody().statements().add(this.fAst.newExpressionStatement(expression));
        }
        ReturnStatement rStatement = this.fAst.newReturnStatement();
        rStatement.setExpression((Expression)this.createMethodInvocation(builderVariableName, this.getContext().getCustomBuilderResultMethod(), null));
        this.toStringMethod.getBody().statements().add(rStatement);
        this.complete();
        return this.toStringMethod;
    }

    private void fillAppendMethodsMap() {
        try {
            IJavaProject javaProject = this.getContext().getTypeBinding().getJavaElement().getJavaProject();
            IType type = javaProject.findType(this.getContext().getCustomBuilderClass());
            IType[] types = type.newSupertypeHierarchy(null).getAllClasses();
            int i = 0;
            while (i < types.length) {
                IMethod[] methods = types[i].getMethods();
                int j = 0;
                while (j < methods.length) {
                    block8: {
                        String specyficType;
                        AppendMethodInformation appendMethodInformation;
                        block10: {
                            String resolvedParameterTypeName2;
                            String resolvedParameterTypeName1;
                            block11: {
                                String[] parameterTypes;
                                block9: {
                                    if (!Flags.isPublic((int)methods[j].getFlags()) || !methods[j].getElementName().equals(this.getContext().getCustomBuilderAppendMethod())) break block8;
                                    parameterTypes = methods[j].getParameterTypes();
                                    appendMethodInformation = new AppendMethodInformation();
                                    if (parameterTypes.length != 1) break block9;
                                    specyficType = JavaModelUtil.getResolvedTypeName(parameterTypes[0], types[i]);
                                    appendMethodInformation.methodType = 1;
                                    break block10;
                                }
                                if (parameterTypes.length != 2) break block8;
                                resolvedParameterTypeName1 = JavaModelUtil.getResolvedTypeName(parameterTypes[0], types[i]);
                                resolvedParameterTypeName2 = JavaModelUtil.getResolvedTypeName(parameterTypes[1], types[i]);
                                if (!resolvedParameterTypeName1.equals("java.lang.String")) break block11;
                                specyficType = resolvedParameterTypeName2;
                                appendMethodInformation.methodType = 3;
                                break block10;
                            }
                            if (!resolvedParameterTypeName2.equals("java.lang.String")) break block8;
                            specyficType = resolvedParameterTypeName1;
                            appendMethodInformation.methodType = 2;
                        }
                        String returnTypeName = JavaModelUtil.getResolvedTypeName(methods[j].getReturnType(), types[i]);
                        IType returnType = javaProject.findType(returnTypeName);
                        appendMethodInformation.returnsBuilder = returnType != null && returnType.newSupertypeHierarchy(null).contains(type);
                        AppendMethodInformation oldAMI = this.appendMethodSpecificTypes.get(specyficType);
                        if (oldAMI == null || oldAMI.methodType < appendMethodInformation.methodType) {
                            this.appendMethodSpecificTypes.put(specyficType, appendMethodInformation);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            throw new RuntimeException("couldn't initialize custom toString() builder generator", e);
        }
    }

    private void tidyAppendsMethodsMap() {
        int objectParametersType = this.appendMethodSpecificTypes.get((Object)"java.lang.Object").methodType;
        Set<Map.Entry<String, AppendMethodInformation>> entrySet = this.appendMethodSpecificTypes.entrySet();
        Iterator<Map.Entry<String, AppendMethodInformation>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, AppendMethodInformation> entry = iterator.next();
            if (entry.getValue().methodType >= objectParametersType) continue;
            iterator.remove();
        }
    }

    private MethodInvocation createAppendMethodForMember(Object member) {
        ITypeBinding memberType = this.getMemberType(member);
        String memberTypeName = memberType.getQualifiedName();
        Expression memberAccessExpression = null;
        AppendMethodInformation ami = this.appendMethodSpecificTypes.get(memberTypeName);
        if (ami == null && memberType.isPrimitive()) {
            memberTypeName = this.wrapperTypes[this.primitiveTypes.indexOf(memberTypeName)];
            memberType = this.fAst.resolveWellKnownType(memberTypeName);
            ami = this.appendMethodSpecificTypes.get(memberTypeName);
            if (!this.getContext().is50orHigher()) {
                ClassInstanceCreation classInstance = this.fAst.newClassInstanceCreation();
                classInstance.setType((Type)this.fAst.newSimpleType(this.addImport(memberTypeName)));
                classInstance.arguments().add(this.createMemberAccessExpression(member, true, true));
                memberAccessExpression = classInstance;
            }
        }
        while (ami == null) {
            memberTypeName = (memberType = memberType.getSuperclass()) != null ? memberType.getQualifiedName() : "java.lang.Object";
            ami = this.appendMethodSpecificTypes.get(memberTypeName);
        }
        if (memberAccessExpression == null) {
            memberAccessExpression = this.createMemberAccessExpression(member, false, this.getContext().isSkipNulls());
        }
        MethodInvocation appendInvocation = this.fAst.newMethodInvocation();
        appendInvocation.setName(this.fAst.newSimpleName(this.getContext().getCustomBuilderAppendMethod()));
        if (ami.methodType == 1 || ami.methodType == 2) {
            appendInvocation.arguments().add(memberAccessExpression);
        }
        if (ami.methodType == 2 || ami.methodType == 3) {
            StringLiteral literal = this.fAst.newStringLiteral();
            literal.setLiteralValue(this.getMemberName(member, "${member.name()}"));
            appendInvocation.arguments().add(literal);
        }
        if (ami.methodType == 3) {
            appendInvocation.arguments().add(memberAccessExpression);
        }
        this.canChainLastAppendCall = ami.returnsBuilder;
        return appendInvocation;
    }

    private class AppendMethodInformation {
        public int methodType;
        public boolean returnsBuilder;

        private AppendMethodInformation() {
        }
    }
}

