/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.IAnnotationModelFactory;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitAnnotationModelEvent;
import org.eclipse.jdt.internal.ui.javaeditor.DocumentAdapter;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.javaeditor.ISavePolicy;
import org.eclipse.jdt.internal.ui.javaeditor.JavaDocumentSetupParticipant;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaMarkerAnnotation;
import org.eclipse.jdt.internal.ui.javaeditor.saveparticipant.IPostSaveListener;
import org.eclipse.jdt.internal.ui.javaeditor.saveparticipant.SaveParticipantRegistry;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.java.IProblemRequestorExtension;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class CompilationUnitDocumentProvider
extends TextFileDocumentProvider
implements ICompilationUnitDocumentProvider,
IAnnotationModelFactory {
    private static final String HANDLE_TEMPORARY_PROBLEMS = "handleTemporaryProblems";
    private boolean fIsAboutToSave = false;
    private ISavePolicy fSavePolicy;
    private IPropertyChangeListener fPropertyListener;
    private GlobalAnnotationModelListener fGlobalAnnotationModelListener;
    private final Map fFakeCUMapForMissingInfo = new HashMap();

    public CompilationUnitDocumentProvider() {
        TextFileDocumentProvider provider = new TextFileDocumentProvider();
        provider = new ForwardingDocumentProvider("___java_partitioning", (IDocumentSetupParticipant)new JavaDocumentSetupParticipant(), (IDocumentProvider)provider);
        this.setParentDocumentProvider((IDocumentProvider)provider);
        this.fGlobalAnnotationModelListener = new GlobalAnnotationModelListener();
        this.fPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (CompilationUnitDocumentProvider.HANDLE_TEMPORARY_PROBLEMS.equals(event.getProperty())) {
                    CompilationUnitDocumentProvider.this.enableHandlingTemporaryProblems();
                }
            }
        };
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
    }

    protected ICompilationUnit createCompilationUnit(IFile file) {
        IJavaElement element = JavaCore.create((IFile)file);
        if (element instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new CompilationUnitInfo();
    }

    public IAnnotationModel createAnnotationModel(IPath path) {
        IResource file = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (file instanceof IFile) {
            return new CompilationUnitAnnotationModel(file);
        }
        return new AnnotationModel();
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        IProblemRequestor requestor;
        IFileEditorInput input;
        ICompilationUnit original = null;
        if (element instanceof IFileEditorInput && (original = this.createCompilationUnit((input = (IFileEditorInput)element).getFile())) == null) {
            return null;
        }
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (!(info instanceof CompilationUnitInfo)) {
            return null;
        }
        if (original == null) {
            original = this.createFakeCompiltationUnit(element, false);
        }
        if (original == null) {
            return null;
        }
        CompilationUnitInfo cuInfo = (CompilationUnitInfo)info;
        this.setUpSynchronization(cuInfo);
        IProblemRequestor iProblemRequestor = requestor = cuInfo.fModel instanceof IProblemRequestor ? (IProblemRequestor)cuInfo.fModel : null;
        if (requestor instanceof IProblemRequestorExtension) {
            IProblemRequestorExtension extension = (IProblemRequestorExtension)requestor;
            extension.setIsActive(false);
            extension.setIsHandlingTemporaryProblems(this.isHandlingTemporaryProblems());
        }
        IResource resource = original.getResource();
        if (JavaModelUtil.isPrimary(original) && (resource == null || resource.exists())) {
            original.becomeWorkingCopy(requestor, this.getProgressMonitor());
        }
        cuInfo.fCopy = original;
        if (cuInfo.fModel instanceof CompilationUnitAnnotationModel) {
            CompilationUnitAnnotationModel model = (CompilationUnitAnnotationModel)cuInfo.fModel;
            model.setCompilationUnit(cuInfo.fCopy);
        }
        if (cuInfo.fModel != null) {
            cuInfo.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
        }
        return cuInfo;
    }

    private ICompilationUnit createFakeCompiltationUnit(Object element, boolean setContents) {
        if (element instanceof IStorageEditorInput) {
            return this.createFakeCompiltationUnit((IStorageEditorInput)element, setContents);
        }
        if (element instanceof IURIEditorInput) {
            return this.createFakeCompiltationUnit((IURIEditorInput)element);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ICompilationUnit createFakeCompiltationUnit(IStorageEditorInput editorInput, boolean setContents) {
        try {
            IStorage storage = editorInput.getStorage();
            IPath storagePath = storage.getFullPath();
            if (storage.getName() == null) return null;
            if (storagePath == null) {
                return null;
            }
            final IPath documentPath = storage instanceof IFileState ? storagePath.append(Long.toString(((IFileState)storage).getModificationTime())) : (CompilationUnitDocumentProvider.isFileRevisionEditorInput((IEditorInput)editorInput) ? storagePath.append(Long.toString(System.currentTimeMillis())) : storagePath);
            WorkingCopyOwner woc = new WorkingCopyOwner(){

                public IBuffer createBuffer(ICompilationUnit workingCopy) {
                    return new DocumentAdapter((IOpenable)workingCopy, documentPath);
                }
            };
            IClasspathEntry[] cpEntries = null;
            IJavaProject jp = this.findJavaProject(storagePath);
            if (jp != null) {
                cpEntries = jp.getResolvedClasspath(true);
            }
            if (cpEntries == null || cpEntries.length == 0) {
                cpEntries = new IClasspathEntry[]{JavaRuntime.getDefaultJREContainerEntry()};
            }
            ICompilationUnit cu = woc.newWorkingCopy(storage.getName(), cpEntries, this.getProgressMonitor());
            if (setContents) {
                int READER_CHUNK_SIZE = 2048;
                int BUFFER_SIZE = 8 * READER_CHUNK_SIZE;
                String charsetName = null;
                if (storage instanceof IEncodedStorage) {
                    charsetName = ((IEncodedStorage)storage).getCharset();
                }
                if (charsetName == null) {
                    charsetName = this.getDefaultEncoding();
                }
                Reader in = null;
                InputStream contents = storage.getContents();
                try {
                    try {
                        in = new BufferedReader(new InputStreamReader(contents, charsetName));
                        StringBuffer buffer = new StringBuffer(BUFFER_SIZE);
                        char[] readBuffer = new char[READER_CHUNK_SIZE];
                        int n = in.read(readBuffer);
                        while (true) {
                            if (n <= 0) {
                                cu.getBuffer().setContents(buffer.toString());
                                break;
                            }
                            buffer.append(readBuffer, 0, n);
                            n = in.read(readBuffer);
                        }
                    }
                    catch (IOException e) {
                        JavaPlugin.log(e);
                        try {
                            if (in != null) {
                                in.close();
                                return null;
                            }
                            contents.close();
                            return null;
                        }
                        catch (IOException iOException) {}
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            in.close();
                            throw throwable;
                        }
                        contents.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (in != null) {
                        in.close();
                    } else {
                        contents.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (this.isModifiable(editorInput)) return cu;
            JavaModelUtil.reconcile(cu);
            return cu;
        }
        catch (CoreException ex) {
            JavaPlugin.log(ex.getStatus());
            return null;
        }
    }

    private static boolean isFileRevisionEditorInput(IEditorInput editorInput) {
        try {
            return Class.forName("org.eclipse.team.internal.ui.history.FileRevisionEditorInput").isInstance(editorInput);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private ICompilationUnit createFakeCompiltationUnit(IURIEditorInput editorInput) {
        String fileStoreName;
        IPath path;
        IFileStore fileStore;
        block6: {
            try {
                URI uri = editorInput.getURI();
                fileStore = EFS.getStore((URI)uri);
                path = URIUtil.toPath((URI)uri);
                fileStoreName = fileStore.getName();
                if (fileStoreName != null && path != null) break block6;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        WorkingCopyOwner woc = new WorkingCopyOwner(){

            public IBuffer createBuffer(ICompilationUnit workingCopy) {
                return new DocumentAdapter((IOpenable)workingCopy, fileStore, path);
            }
        };
        IClasspathEntry[] cpEntries = null;
        IJavaProject jp = this.findJavaProject(path);
        if (jp != null) {
            cpEntries = jp.getResolvedClasspath(true);
        }
        if (cpEntries == null || cpEntries.length == 0) {
            cpEntries = new IClasspathEntry[]{JavaRuntime.getDefaultJREContainerEntry()};
        }
        ICompilationUnit cu = woc.newWorkingCopy(fileStoreName, cpEntries, this.getProgressMonitor());
        if (!this.isModifiable(editorInput)) {
            JavaModelUtil.reconcile(cu);
        }
        return cu;
    }

    private IJavaProject findJavaProject(IPath path) {
        IJavaProject[] projects;
        if (path == null) {
            return null;
        }
        String[] pathSegments = path.segments();
        IJavaModel model = JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot());
        try {
            projects = model.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        int i = 0;
        while (i < projects.length) {
            IPath projectPath = projects[i].getProject().getFullPath();
            String projectSegment = projectPath.segments()[0];
            int j = 0;
            while (j < pathSegments.length) {
                if (projectSegment.equals(pathSegments[j])) {
                    return projects[i];
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        if (info instanceof CompilationUnitInfo) {
            CompilationUnitInfo cuInfo = (CompilationUnitInfo)info;
            try {
                cuInfo.fCopy.discardWorkingCopy();
            }
            catch (JavaModelException x) {
                this.handleCoreException((CoreException)((Object)x), x.getMessage());
            }
            if (cuInfo.fModel != null) {
                cuInfo.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
            }
        }
        super.disposeFileInfo(element, info);
    }

    public void connect(Object element) throws CoreException {
        super.connect(element);
        if (this.getFileInfo(element) != null) {
            return;
        }
        CompilationUnitInfo info = (CompilationUnitInfo)((Object)this.fFakeCUMapForMissingInfo.get(element));
        if (info == null) {
            ICompilationUnit cu = this.createFakeCompiltationUnit(element, true);
            if (cu == null) {
                return;
            }
            info = new CompilationUnitInfo();
            info.fCopy = cu;
            info.fElement = element;
            info.fModel = new AnnotationModel();
            this.fFakeCUMapForMissingInfo.put(element, info);
        }
        info.fCount = info.fCount + 1;
    }

    public IAnnotationModel getAnnotationModel(Object element) {
        IAnnotationModel model = super.getAnnotationModel(element);
        if (model != null) {
            return model;
        }
        TextFileDocumentProvider.FileInfo info = (TextFileDocumentProvider.FileInfo)this.fFakeCUMapForMissingInfo.get(element);
        if (info != null) {
            if (info.fModel != null) {
                return info.fModel;
            }
            if (info.fTextFileBuffer != null) {
                return info.fTextFileBuffer.getAnnotationModel();
            }
        }
        return null;
    }

    public void disconnect(Object element) {
        CompilationUnitInfo info = (CompilationUnitInfo)((Object)this.fFakeCUMapForMissingInfo.get(element));
        if (info != null) {
            if (info.fCount == 1) {
                this.fFakeCUMapForMissingInfo.remove(element);
                info.fModel = null;
                try {
                    info.fCopy.discardWorkingCopy();
                }
                catch (JavaModelException ex) {
                    this.handleCoreException((CoreException)((Object)ex), ex.getMessage());
                }
            } else {
                info.fCount = info.fCount - 1;
            }
        }
        super.disconnect(element);
    }

    private IProgressMonitor getSubProgressMonitor(IProgressMonitor monitor, int ticks) {
        if (monitor != null) {
            return new SubProgressMonitor(monitor, ticks, 4);
        }
        return new NullProgressMonitor();
    }

    protected void commitWorkingCopy(IProgressMonitor monitor, Object element, CompilationUnitInfo info, boolean overwrite) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 100);
        try {
            IResource r;
            IMarker[] markers;
            ICompilationUnit unit;
            IDocument document = info.fTextFileBuffer.getDocument();
            IResource resource = info.fCopy.getResource();
            Assert.isTrue((boolean)(resource instanceof IFile));
            boolean isSynchronized = resource.isSynchronized(0);
            if (!isSynchronized && this.isDeleted(element)) {
                info.fTextFileBuffer.setDirty(true);
            }
            if (!resource.exists()) {
                this.createFileFromDocument(monitor, (IFile)resource, document);
                return;
            }
            if (this.fSavePolicy != null) {
                this.fSavePolicy.preSave(info.fCopy);
            }
            IProgressMonitor subMonitor = null;
            try {
                try {
                    IRegion[] changedRegions;
                    CoreException changedRegionException;
                    IPostSaveListener[] listeners;
                    block30: {
                        this.fIsAboutToSave = true;
                        listeners = JavaPlugin.getDefault().getSaveParticipantRegistry().getEnabledPostSaveListeners(info.fCopy.getJavaProject().getProject());
                        changedRegionException = null;
                        boolean needsChangedRegions = false;
                        try {
                            if (listeners.length > 0) {
                                needsChangedRegions = SaveParticipantRegistry.isChangedRegionsRequired(info.fCopy);
                            }
                        }
                        catch (CoreException ex) {
                            changedRegionException = ex;
                        }
                        changedRegions = null;
                        if (needsChangedRegions) {
                            try {
                                try {
                                    changedRegions = EditorUtility.calculateChangedLineRegions(info.fTextFileBuffer, this.getSubProgressMonitor(monitor, 20));
                                }
                                catch (CoreException ex) {
                                    changedRegionException = ex;
                                    subMonitor = this.getSubProgressMonitor(monitor, 50);
                                    break block30;
                                }
                            }
                            catch (Throwable throwable) {
                                subMonitor = this.getSubProgressMonitor(monitor, 50);
                                throw throwable;
                            }
                            subMonitor = this.getSubProgressMonitor(monitor, 50);
                        } else {
                            subMonitor = this.getSubProgressMonitor(monitor, listeners.length > 0 ? 70 : 100);
                        }
                    }
                    info.fCopy.commitWorkingCopy(isSynchronized || overwrite, subMonitor);
                    if (listeners.length > 0) {
                        this.notifyPostSaveListeners(info, changedRegions, listeners, this.getSubProgressMonitor(monitor, 30));
                    }
                    if (changedRegionException != null) {
                        throw changedRegionException;
                    }
                }
                catch (CoreException x) {
                    this.fireElementStateChangeFailed(element);
                    throw x;
                }
                catch (RuntimeException x) {
                    this.fireElementStateChangeFailed(element);
                    throw x;
                }
            }
            finally {
                this.fIsAboutToSave = false;
                if (subMonitor != null) {
                    subMonitor.done();
                }
            }
            if (info.fModel instanceof AbstractMarkerAnnotationModel) {
                AbstractMarkerAnnotationModel model = (AbstractMarkerAnnotationModel)info.fModel;
                model.updateMarkers(document);
            }
            if (this.fSavePolicy != null && (unit = this.fSavePolicy.postSave(info.fCopy)) != null && info.fModel instanceof AbstractMarkerAnnotationModel && (markers = (r = unit.getResource()).findMarkers("org.eclipse.core.resources.marker", true, 0)) != null && markers.length > 0) {
                AbstractMarkerAnnotationModel model = (AbstractMarkerAnnotationModel)info.fModel;
                int i = 0;
                while (i < markers.length) {
                    model.updateMarker(document, markers[i], null);
                    ++i;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected TextFileDocumentProvider.DocumentProviderOperation createSaveOperation(final Object element, IDocument document, final boolean overwrite) throws CoreException {
        final TextFileDocumentProvider.FileInfo info = this.getFileInfo(element);
        if (info instanceof CompilationUnitInfo) {
            ICompilationUnit cu = ((CompilationUnitInfo)info).fCopy;
            if (cu != null && !JavaModelUtil.isPrimary(cu)) {
                return super.createSaveOperation(element, document, overwrite);
            }
            if (info.fTextFileBuffer.getDocument() != document) {
                Status status = new Status(2, "org.eclipse.ui.editors", 4, JavaEditorMessages.CompilationUnitDocumentProvider_saveAsTargetOpenInEditor, null);
                throw new CoreException((IStatus)status);
            }
            return new TextFileDocumentProvider.DocumentProviderOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    CompilationUnitDocumentProvider.this.commitWorkingCopy(monitor, element, (CompilationUnitInfo)info, overwrite);
                }

                public ISchedulingRule getSchedulingRule() {
                    if (info.fElement instanceof IFileEditorInput) {
                        IFile file = ((IFileEditorInput)info.fElement).getFile();
                        return CompilationUnitDocumentProvider.this.computeSchedulingRule((IResource)file);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected boolean isHandlingTemporaryProblems() {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(HANDLE_TEMPORARY_PROBLEMS);
    }

    protected void enableHandlingTemporaryProblems() {
        boolean enable = this.isHandlingTemporaryProblems();
        Iterator iter = this.getFileInfosIterator();
        while (iter.hasNext()) {
            TextFileDocumentProvider.FileInfo info = (TextFileDocumentProvider.FileInfo)iter.next();
            if (!(info.fModel instanceof IProblemRequestorExtension)) continue;
            IProblemRequestorExtension extension = (IProblemRequestorExtension)info.fModel;
            extension.setIsHandlingTemporaryProblems(enable);
        }
    }

    public void setSavePolicy(ISavePolicy savePolicy) {
        this.fSavePolicy = savePolicy;
    }

    public void addGlobalAnnotationModelListener(IAnnotationModelListener listener) {
        this.fGlobalAnnotationModelListener.addListener(listener);
    }

    public void removeGlobalAnnotationModelListener(IAnnotationModelListener listener) {
        this.fGlobalAnnotationModelListener.removeListener(listener);
    }

    public ICompilationUnit getWorkingCopy(Object element) {
        TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(element);
        if (fileInfo instanceof CompilationUnitInfo) {
            CompilationUnitInfo info = (CompilationUnitInfo)fileInfo;
            return info.fCopy;
        }
        CompilationUnitInfo cuInfo = (CompilationUnitInfo)((Object)this.fFakeCUMapForMissingInfo.get(element));
        if (cuInfo != null) {
            return cuInfo.fCopy;
        }
        return null;
    }

    public void shutdown() {
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyListener);
        Iterator e = this.getConnectedElementsIterator();
        while (e.hasNext()) {
            this.disconnect(e.next());
        }
        this.fFakeCUMapForMissingInfo.clear();
    }

    public void saveDocumentContent(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (!this.fIsAboutToSave) {
            return;
        }
        super.saveDocument(monitor, element, document, overwrite);
    }

    public ILineTracker createLineTracker(Object element) {
        return new DefaultLineTracker();
    }

    protected void notifyPostSaveListeners(final CompilationUnitInfo info, final IRegion[] changedRegions, IPostSaveListener[] listeners, final IProgressMonitor monitor) throws CoreException {
        final ICompilationUnit unit = info.fCopy;
        final IBuffer buffer = unit.getBuffer();
        String message = JavaEditorMessages.CompilationUnitDocumentProvider_error_saveParticipantProblem;
        final MultiStatus errorStatus = new MultiStatus("org.eclipse.jdt.ui", 10006, message, null);
        monitor.beginTask(JavaEditorMessages.CompilationUnitDocumentProvider_progressNotifyingSaveParticipants, listeners.length * 5);
        try {
            int i = 0;
            while (i < listeners.length) {
                final IPostSaveListener listener = listeners[i];
                final String participantName = listener.getName();
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() {
                        try {
                            try {
                                long stamp = unit.getResource().getModificationStamp();
                                listener.saved(unit, changedRegions, CompilationUnitDocumentProvider.this.getSubProgressMonitor(monitor, 4));
                                if (stamp != unit.getResource().getModificationStamp()) {
                                    String msg = Messages.format(JavaEditorMessages.CompilationUnitDocumentProvider_error_saveParticipantSavedFile, participantName);
                                    errorStatus.add((IStatus)new Status(4, "org.eclipse.jdt.ui", 10006, msg, null));
                                }
                                if (buffer.hasUnsavedChanges()) {
                                    buffer.save(CompilationUnitDocumentProvider.this.getSubProgressMonitor(monitor, 1), true);
                                }
                            }
                            catch (CoreException ex) {
                                this.handleException(ex);
                                monitor.worked(1);
                            }
                        }
                        finally {
                            monitor.worked(1);
                        }
                    }

                    public void handleException(Throwable ex) {
                        String msg = Messages.format("The save participant ''{0}'' caused an exception: {1}", new String[]{listener.getId(), ex.toString()});
                        JavaPlugin.log((IStatus)new Status(4, "org.eclipse.jdt.ui", 10006, msg, ex));
                        msg = Messages.format(JavaEditorMessages.CompilationUnitDocumentProvider_error_saveParticipantFailed, new String[]{participantName, ex.toString()});
                        errorStatus.add((IStatus)new Status(4, "org.eclipse.jdt.ui", 10006, msg, null));
                        if (buffer.hasUnsavedChanges()) {
                            try {
                                info.fTextFileBuffer.revert(CompilationUnitDocumentProvider.this.getSubProgressMonitor(monitor, 1));
                            }
                            catch (CoreException coreException) {
                                msg = Messages.format("Error on revert after failure of save participant ''{0}''.", participantName);
                                Status status = new Status(4, "org.eclipse.jdt.ui", 10006, msg, ex);
                                JavaPlugin.getDefault().getLog().log((IStatus)status);
                            }
                            if (info.fModel instanceof AbstractMarkerAnnotationModel) {
                                AbstractMarkerAnnotationModel markerModel = (AbstractMarkerAnnotationModel)info.fModel;
                                markerModel.resetMarkers();
                            }
                        }
                    }
                });
                ++i;
            }
        }
        finally {
            monitor.done();
            if (!errorStatus.isOK()) {
                throw new CoreException((IStatus)errorStatus);
            }
        }
    }

    protected static class CompilationUnitAnnotationModel
    extends ResourceMarkerAnnotationModel
    implements IProblemRequestor,
    IProblemRequestorExtension {
        private ThreadLocal fProblemRequestorState = new ThreadLocal();
        private int fStateCount = 0;
        private ICompilationUnit fCompilationUnit;
        private List fGeneratedAnnotations = new ArrayList();
        private IProgressMonitor fProgressMonitor;
        private boolean fIsActive = false;
        private boolean fIsHandlingTemporaryProblems;
        private ReverseMap fReverseMap = new ReverseMap();
        private List fPreviouslyOverlaid = null;
        private List fCurrentlyOverlaid = new ArrayList();
        private Thread fActiveThread;

        public CompilationUnitAnnotationModel(IResource resource) {
            super(resource);
        }

        public void setCompilationUnit(ICompilationUnit unit) {
            this.fCompilationUnit = unit;
        }

        protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
            if (JavaMarkerAnnotation.isJavaAnnotation(marker)) {
                return new JavaMarkerAnnotation(marker);
            }
            return super.createMarkerAnnotation(marker);
        }

        protected AnnotationModelEvent createAnnotationModelEvent() {
            return new CompilationUnitAnnotationModelEvent((IAnnotationModel)this, this.getResource());
        }

        protected Position createPositionFromProblem(IProblem problem) {
            int start = problem.getSourceStart();
            int end = problem.getSourceEnd();
            if (start == -1 && end == -1) {
                return new Position(0);
            }
            if (start == -1) {
                return new Position(end);
            }
            if (end == -1) {
                return new Position(start);
            }
            int length = end - start + 1;
            if (length < 0) {
                return null;
            }
            return new Position(start, length);
        }

        public void beginReporting() {
            ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (state == null) {
                this.internalBeginReporting(false);
            }
        }

        public void beginReportingSequence() {
            ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (state == null) {
                this.internalBeginReporting(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalBeginReporting(boolean insideReportingSequence) {
            if (this.fCompilationUnit != null && this.fCompilationUnit.getJavaProject().isOnClasspath((IJavaElement)this.fCompilationUnit)) {
                ProblemRequestorState state = new ProblemRequestorState();
                state.fInsideReportingSequence = insideReportingSequence;
                state.fReportedProblems = new ArrayList();
                Object object = this.getLockObject();
                synchronized (object) {
                    this.fProblemRequestorState.set(state);
                    ++this.fStateCount;
                }
            }
        }

        public void acceptProblem(IProblem problem) {
            ProblemRequestorState state;
            if ((this.fIsHandlingTemporaryProblems || problem.getID() == Integer.MIN_VALUE) && (state = (ProblemRequestorState)this.fProblemRequestorState.get()) != null) {
                state.fReportedProblems.add(problem);
            }
        }

        public void endReporting() {
            ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (state != null && !state.fInsideReportingSequence) {
                this.internalEndReporting(state);
            }
        }

        public void endReportingSequence() {
            ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (state != null && state.fInsideReportingSequence) {
                this.internalEndReporting(state);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalEndReporting(ProblemRequestorState state) {
            int stateCount = 0;
            Object object = this.getLockObject();
            synchronized (object) {
                --this.fStateCount;
                stateCount = this.fStateCount;
                this.fProblemRequestorState.set(null);
            }
            if (stateCount == 0) {
                this.reportProblems(state.fReportedProblems);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reportProblems(List reportedProblems) {
            if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                return;
            }
            boolean temporaryProblemsChanged = false;
            Object object = this.getLockObject();
            synchronized (object) {
                boolean isCanceled = false;
                this.fPreviouslyOverlaid = this.fCurrentlyOverlaid;
                this.fCurrentlyOverlaid = new ArrayList();
                if (this.fGeneratedAnnotations.size() > 0) {
                    temporaryProblemsChanged = true;
                    this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                    this.fGeneratedAnnotations.clear();
                }
                if (reportedProblems != null && reportedProblems.size() > 0) {
                    Iterator e = reportedProblems.iterator();
                    while (e.hasNext()) {
                        if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                            isCanceled = true;
                            break;
                        }
                        IProblem problem = (IProblem)e.next();
                        Position position = this.createPositionFromProblem(problem);
                        if (position == null) continue;
                        try {
                            ProblemAnnotation annotation = new ProblemAnnotation(problem, this.fCompilationUnit);
                            this.overlayMarkers(position, annotation);
                            this.addAnnotation(annotation, position, false);
                            this.fGeneratedAnnotations.add(annotation);
                            temporaryProblemsChanged = true;
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
                this.removeMarkerOverlays(isCanceled);
                this.fPreviouslyOverlaid = null;
            }
            if (temporaryProblemsChanged) {
                this.fireModelChanged();
            }
        }

        private void removeMarkerOverlays(boolean isCanceled) {
            if (isCanceled) {
                this.fCurrentlyOverlaid.addAll(this.fPreviouslyOverlaid);
            } else if (this.fPreviouslyOverlaid != null) {
                Iterator e = this.fPreviouslyOverlaid.iterator();
                while (e.hasNext()) {
                    JavaMarkerAnnotation annotation = (JavaMarkerAnnotation)e.next();
                    annotation.setOverlay(null);
                }
            }
        }

        private void setOverlay(Object value, ProblemAnnotation problemAnnotation) {
            JavaMarkerAnnotation annotation;
            if (value instanceof JavaMarkerAnnotation && (annotation = (JavaMarkerAnnotation)value).isProblem()) {
                annotation.setOverlay(problemAnnotation);
                this.fPreviouslyOverlaid.remove(annotation);
                this.fCurrentlyOverlaid.add(annotation);
            }
        }

        private void overlayMarkers(Position position, ProblemAnnotation problemAnnotation) {
            Object value = this.getAnnotations(position);
            if (value instanceof List) {
                List list = (List)value;
                Iterator e = list.iterator();
                while (e.hasNext()) {
                    this.setOverlay(e.next(), problemAnnotation);
                }
            } else {
                this.setOverlay(value, problemAnnotation);
            }
        }

        private void startCollectingProblems() {
            this.fGeneratedAnnotations.clear();
        }

        private void stopCollectingProblems() {
            if (this.fGeneratedAnnotations != null) {
                this.removeAnnotations(this.fGeneratedAnnotations, true, true);
            }
            this.fGeneratedAnnotations.clear();
        }

        public synchronized boolean isActive() {
            return this.fIsActive && this.fActiveThread == Thread.currentThread();
        }

        public void setProgressMonitor(IProgressMonitor monitor) {
            this.fProgressMonitor = monitor;
        }

        public synchronized void setIsActive(boolean isActive) {
            Assert.isLegal((!isActive || Display.getCurrent() == null ? 1 : 0) != 0);
            this.fIsActive = isActive;
            this.fActiveThread = this.fIsActive ? Thread.currentThread() : null;
        }

        public void setIsHandlingTemporaryProblems(boolean enable) {
            if (this.fIsHandlingTemporaryProblems != enable) {
                this.fIsHandlingTemporaryProblems = enable;
                if (this.fIsHandlingTemporaryProblems) {
                    this.startCollectingProblems();
                } else {
                    this.stopCollectingProblems();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getAnnotations(Position position) {
            Object object = this.getLockObject();
            synchronized (object) {
                return this.fReverseMap.get(position);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) throws BadLocationException {
            super.addAnnotation(annotation, position, fireModelChanged);
            Object object = this.getLockObject();
            synchronized (object) {
                Object cached = this.fReverseMap.get(position);
                if (cached == null) {
                    this.fReverseMap.put(position, annotation);
                } else if (cached instanceof List) {
                    List list = (List)cached;
                    list.add(annotation);
                } else if (cached instanceof Annotation) {
                    ArrayList<Object> list = new ArrayList<Object>(2);
                    list.add(cached);
                    list.add(annotation);
                    this.fReverseMap.put(position, list);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeAllAnnotations(boolean fireModelChanged) {
            super.removeAllAnnotations(fireModelChanged);
            Object object = this.getLockObject();
            synchronized (object) {
                this.fReverseMap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeAnnotation(Annotation annotation, boolean fireModelChanged) {
            Position position = this.getPosition(annotation);
            Object object = this.getLockObject();
            synchronized (object) {
                Object cached = this.fReverseMap.get(position);
                if (cached instanceof List) {
                    List list = (List)cached;
                    list.remove(annotation);
                    if (list.size() == 1) {
                        this.fReverseMap.put(position, list.get(0));
                        list.clear();
                    }
                } else if (cached instanceof Annotation) {
                    this.fReverseMap.remove(position);
                }
            }
            super.removeAnnotation(annotation, fireModelChanged);
        }

        private static class ProblemRequestorState {
            boolean fInsideReportingSequence = false;
            List fReportedProblems;

            private ProblemRequestorState() {
            }
        }
    }

    protected static class CompilationUnitInfo
    extends TextFileDocumentProvider.FileInfo {
        public ICompilationUnit fCopy;

        protected CompilationUnitInfo() {
        }
    }

    protected static class GlobalAnnotationModelListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        private ListenerList fListenerList = new ListenerList(1);

        public void modelChanged(IAnnotationModel model) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IAnnotationModelListener)listeners[i]).modelChanged(model);
                ++i;
            }
        }

        public void modelChanged(AnnotationModelEvent event) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                Object curr = listeners[i];
                if (curr instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)curr).modelChanged(event);
                }
                ++i;
            }
        }

        public void addListener(IAnnotationModelListener listener) {
            this.fListenerList.add((Object)listener);
        }

        public void removeListener(IAnnotationModelListener listener) {
            this.fListenerList.remove((Object)listener);
        }
    }

    public static class ProblemAnnotation
    extends Annotation
    implements IJavaAnnotation,
    IAnnotationPresentation,
    IQuickFixableAnnotation {
        public static final String SPELLING_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.spelling";
        private static final int TASK_LAYER;
        private static final int INFO_LAYER;
        private static final int WARNING_LAYER;
        private static final int ERROR_LAYER;
        private static Image fgQuickFixImage;
        private static Image fgQuickFixErrorImage;
        private static Image fgTaskImage;
        private static Image fgInfoImage;
        private static Image fgWarningImage;
        private static Image fgErrorImage;
        private static boolean fgImagesInitialized;
        private ICompilationUnit fCompilationUnit;
        private List fOverlaids;
        private IProblem fProblem;
        private Image fImage;
        private boolean fImageInitialized = false;
        private int fLayer = 0;
        private boolean fIsQuickFixable;
        private boolean fIsQuickFixableStateSet = false;

        static {
            AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
            TASK_LAYER = ProblemAnnotation.computeLayer("org.eclipse.ui.workbench.texteditor.task", lookup);
            INFO_LAYER = ProblemAnnotation.computeLayer("org.eclipse.jdt.ui.info", lookup);
            WARNING_LAYER = ProblemAnnotation.computeLayer("org.eclipse.jdt.ui.warning", lookup);
            ERROR_LAYER = ProblemAnnotation.computeLayer("org.eclipse.jdt.ui.error", lookup);
            fgImagesInitialized = false;
        }

        private static int computeLayer(String annotationType, AnnotationPreferenceLookup lookup) {
            Annotation annotation = new Annotation(annotationType, false, null);
            AnnotationPreference preference = lookup.getAnnotationPreference(annotation);
            if (preference != null) {
                return preference.getPresentationLayer() + 1;
            }
            return 1;
        }

        public ProblemAnnotation(IProblem problem, ICompilationUnit cu) {
            this.fProblem = problem;
            this.fCompilationUnit = cu;
            if (Integer.MIN_VALUE == this.fProblem.getID()) {
                this.setType(SPELLING_ANNOTATION_TYPE);
                this.fLayer = WARNING_LAYER;
            } else if (536871362 == this.fProblem.getID()) {
                this.setType("org.eclipse.ui.workbench.texteditor.task");
                this.fLayer = TASK_LAYER;
            } else if (this.fProblem.isWarning()) {
                this.setType("org.eclipse.jdt.ui.warning");
                this.fLayer = WARNING_LAYER;
            } else if (this.fProblem.isError()) {
                this.setType("org.eclipse.jdt.ui.error");
                this.fLayer = ERROR_LAYER;
            } else {
                this.setType("org.eclipse.jdt.ui.info");
                this.fLayer = INFO_LAYER;
            }
        }

        public int getLayer() {
            return this.fLayer;
        }

        private void initializeImage() {
            if (!this.fImageInitialized) {
                this.initializeImages();
                if (!this.isQuickFixableStateSet()) {
                    this.setQuickFixable(this.isProblem() && this.indicateQuixFixableProblems() && JavaCorrectionProcessor.hasCorrections(this));
                }
                if (this.isQuickFixable()) {
                    this.fImage = "org.eclipse.jdt.ui.error".equals(this.getType()) ? fgQuickFixErrorImage : fgQuickFixImage;
                } else {
                    String type = this.getType();
                    if ("org.eclipse.ui.workbench.texteditor.task".equals(type)) {
                        this.fImage = fgTaskImage;
                    } else if ("org.eclipse.jdt.ui.info".equals(type)) {
                        this.fImage = fgInfoImage;
                    } else if ("org.eclipse.jdt.ui.warning".equals(type)) {
                        this.fImage = fgWarningImage;
                    } else if ("org.eclipse.jdt.ui.error".equals(type)) {
                        this.fImage = fgErrorImage;
                    }
                }
                this.fImageInitialized = true;
            }
        }

        private void initializeImages() {
            if (fgImagesInitialized) {
                return;
            }
            fgQuickFixImage = JavaPluginImages.get("org.eclipse.jdt.ui.quickfix_warning_obj.gif");
            fgQuickFixErrorImage = JavaPluginImages.get("org.eclipse.jdt.ui.quickfix_error_obj.gif");
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            fgTaskImage = sharedImages.getImage("IMG_OBJS_TASK_TSK");
            fgInfoImage = sharedImages.getImage("IMG_OBJS_INFO_TSK");
            fgWarningImage = sharedImages.getImage("IMG_OBJS_WARN_TSK");
            fgErrorImage = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
            fgImagesInitialized = true;
        }

        private boolean indicateQuixFixableProblems() {
            return PreferenceConstants.getPreferenceStore().getBoolean("JavaEditor.ShowTemporaryProblem");
        }

        public void paint(GC gc, Canvas canvas, Rectangle r) {
            this.initializeImage();
            if (this.fImage != null) {
                ImageUtilities.drawImage((Image)this.fImage, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
            }
        }

        public String getText() {
            return this.fProblem.getMessage();
        }

        public String[] getArguments() {
            return this.isProblem() ? this.fProblem.getArguments() : null;
        }

        public int getId() {
            return this.fProblem.getID();
        }

        public boolean isProblem() {
            String type = this.getType();
            return "org.eclipse.jdt.ui.warning".equals(type) || "org.eclipse.jdt.ui.error".equals(type) || SPELLING_ANNOTATION_TYPE.equals(type);
        }

        public boolean hasOverlay() {
            return false;
        }

        public IJavaAnnotation getOverlay() {
            return null;
        }

        public void addOverlaid(IJavaAnnotation annotation) {
            if (this.fOverlaids == null) {
                this.fOverlaids = new ArrayList(1);
            }
            this.fOverlaids.add(annotation);
        }

        public void removeOverlaid(IJavaAnnotation annotation) {
            if (this.fOverlaids != null) {
                this.fOverlaids.remove(annotation);
                if (this.fOverlaids.size() == 0) {
                    this.fOverlaids = null;
                }
            }
        }

        public Iterator getOverlaidIterator() {
            if (this.fOverlaids != null) {
                return this.fOverlaids.iterator();
            }
            return null;
        }

        public ICompilationUnit getCompilationUnit() {
            return this.fCompilationUnit;
        }

        public String getMarkerType() {
            if (this.fProblem instanceof CategorizedProblem) {
                return ((CategorizedProblem)this.fProblem).getMarkerType();
            }
            return null;
        }

        public void setQuickFixable(boolean state) {
            this.fIsQuickFixable = state;
            this.fIsQuickFixableStateSet = true;
        }

        public boolean isQuickFixableStateSet() {
            return this.fIsQuickFixableStateSet;
        }

        public boolean isQuickFixable() {
            Assert.isTrue((boolean)this.isQuickFixableStateSet());
            return this.fIsQuickFixable;
        }
    }

    protected static class ReverseMap {
        private List fList = new ArrayList(2);
        private int fAnchor = 0;

        public Object get(Position position) {
            Entry entry;
            int length = this.fList.size();
            int i = this.fAnchor;
            while (i < length) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            i = 0;
            while (i < this.fAnchor) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            return null;
        }

        private int getIndex(Position position) {
            int length = this.fList.size();
            int i = 0;
            while (i < length) {
                Entry entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void put(Position position, Object value) {
            int index = this.getIndex(position);
            if (index == -1) {
                Entry entry = new Entry();
                entry.fPosition = position;
                entry.fValue = value;
                this.fList.add(entry);
            } else {
                Entry entry = (Entry)this.fList.get(index);
                entry.fValue = value;
            }
        }

        public void remove(Position position) {
            int index = this.getIndex(position);
            if (index > -1) {
                this.fList.remove(index);
            }
        }

        public void clear() {
            this.fList.clear();
        }

        static class Entry {
            Position fPosition;
            Object fValue;

            Entry() {
            }
        }
    }
}

