/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.ApiDescription;
import org.eclipse.pde.api.tools.internal.ApiDescriptionManager;
import org.eclipse.pde.api.tools.internal.ApiFilterStore;
import org.eclipse.pde.api.tools.internal.JavadocTagManager;
import org.eclipse.pde.api.tools.internal.SessionManager;
import org.eclipse.pde.api.tools.internal.WorkspaceDeltaProcessor;
import org.eclipse.pde.api.tools.internal.builder.AbstractProblemDetector;
import org.eclipse.pde.api.tools.internal.builder.ApiAnalysisBuilder;
import org.eclipse.pde.api.tools.internal.builder.ReferenceAnalyzer;
import org.eclipse.pde.api.tools.internal.builder.ReferenceExtractor;
import org.eclipse.pde.api.tools.internal.builder.ReferenceResolver;
import org.eclipse.pde.api.tools.internal.comparator.ClassFileComparator;
import org.eclipse.pde.api.tools.internal.descriptors.ElementDescriptorImpl;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.ISessionManager;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemTypes;
import org.eclipse.pde.api.tools.internal.provisional.scanner.TagScanner;
import org.eclipse.pde.api.tools.internal.util.FileManager;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ApiPlugin
extends Plugin
implements ISaveParticipant {
    public static final String EXTENSION_JAVADOC_TAGS = "apiJavadocTags";
    public static final String PLUGIN_ID = "org.eclipse.pde.api.tools";
    public static final String NATURE_ID = "org.eclipse.pde.api.tools.apiAnalysisNature";
    public static final int INTERNAL_ERROR = 120;
    public static final int ERROR = 121;
    public static final int REPORT_RESOLUTION_ERRORS = 122;
    public static final int REPORT_BASELINE_IS_DISPOSED = 123;
    public static final int SEVERITY_IGNORE = 0;
    public static final int SEVERITY_WARNING = 1;
    public static final int SEVERITY_ERROR = 2;
    public static final String VALUE_IGNORE = "Ignore";
    public static final String VALUE_WARNING = "Warning";
    public static final String VALUE_ERROR = "Error";
    public static final String VALUE_DISABLED = "Disabled";
    public static final String VALUE_ENABLED = "Enabled";
    public static final String BUILDER_ID = "org.eclipse.pde.api.tools.apiAnalysisBuilder";
    public static final String BASELINE_IS_DISPOSED = "baseline is disposed";
    private static ApiPlugin fgDefault = null;
    private static JavadocTagManager fgTagManager = null;
    private static ISessionManager fgSessionManager = null;
    private static final String BUILDER_DEBUG = "org.eclipse.pde.api.tools/debug/builder";
    private static final String DELTA_DEBUG = "org.eclipse.pde.api.tools/debug/delta";
    private static final String CLASSFILE_VISITOR_DEBUG = "org.eclipse.pde.api.tools/debug/classfilevisitor";
    private static final String DESCRIPTOR_FRAMEWORK_DEBUG = "org.eclipse.pde.api.tools/debug/descriptor/framework";
    private static final String TAG_SCANNER_DEBUG = "org.eclipse.pde.api.tools/debug/tagscanner";
    private static final String PLUGIN_WORKSPACE_COMPONENT_DEBUG = "org.eclipse.pde.api.tools/debug/pluginworkspacecomponent";
    private static final String API_PROFILE_MANAGER_DEBUG = "org.eclipse.pde.api.tools/debug/profilemanager";
    private static final String API_FILTER_STORE_DEBUG = "org.eclipse.pde.api.tools/debug/apifilterstore";
    private static final String API_REFERENCE_ANALYZER_DEBUG = "org.eclipse.pde.api.tools/debug/refanalyzer";
    private static final String PROBLEM_DETECTOR_DEBUG = "org.eclipse.pde.api.tools/debug/problemdetector";
    private static final String REFERENCE_RESOLVER_DEBUG = "org.eclipse.pde.api.tools/debug/refresolver";
    private static final String API_DESCRIPTION = "org.eclipse.pde.api.tools/debug/apidescription";
    private static final String WORKSPACE_DELTA_PROCESSOR = "org.eclipse.pde.api.tools/debug/workspacedeltaprocessor";
    public static final String TRUE = "true";
    public static String[] AllCompatibilityKeys = new String[]{IApiProblemTypes.API_COMPONENT_REMOVED_TYPE, IApiProblemTypes.API_COMPONENT_REMOVED_API_TYPE, IApiProblemTypes.API_COMPONENT_REMOVED_REEXPORTED_TYPE, IApiProblemTypes.API_COMPONENT_REMOVED_REEXPORTED_API_TYPE, IApiProblemTypes.ANNOTATION_REMOVED_FIELD, IApiProblemTypes.ANNOTATION_REMOVED_METHOD, IApiProblemTypes.ANNOTATION_REMOVED_TYPE_MEMBER, IApiProblemTypes.ANNOTATION_CHANGED_TYPE_CONVERSION, IApiProblemTypes.ANNOTATION_ADDED_METHOD_NO_DEFAULT_VALUE, IApiProblemTypes.INTERFACE_ADDED_FIELD, IApiProblemTypes.INTERFACE_ADDED_METHOD, IApiProblemTypes.INTERFACE_ADDED_RESTRICTIONS, IApiProblemTypes.INTERFACE_ADDED_SUPER_INTERFACE_WITH_METHODS, IApiProblemTypes.INTERFACE_ADDED_TYPE_PARAMETER, IApiProblemTypes.INTERFACE_REMOVED_TYPE_PARAMETER, IApiProblemTypes.INTERFACE_REMOVED_FIELD, IApiProblemTypes.INTERFACE_REMOVED_METHOD, IApiProblemTypes.INTERFACE_REMOVED_TYPE_MEMBER, IApiProblemTypes.INTERFACE_CHANGED_TYPE_CONVERSION, IApiProblemTypes.INTERFACE_CHANGED_CONTRACTED_SUPERINTERFACES_SET, IApiProblemTypes.ENUM_CHANGED_CONTRACTED_SUPERINTERFACES_SET, IApiProblemTypes.ENUM_CHANGED_TYPE_CONVERSION, IApiProblemTypes.ENUM_REMOVED_FIELD, IApiProblemTypes.ENUM_REMOVED_ENUM_CONSTANT, IApiProblemTypes.ENUM_REMOVED_METHOD, IApiProblemTypes.ENUM_REMOVED_TYPE_MEMBER, IApiProblemTypes.CLASS_ADDED_METHOD, IApiProblemTypes.CLASS_ADDED_RESTRICTIONS, IApiProblemTypes.CLASS_ADDED_TYPE_PARAMETER, IApiProblemTypes.CLASS_CHANGED_CONTRACTED_SUPERINTERFACES_SET, IApiProblemTypes.CLASS_CHANGED_NON_ABSTRACT_TO_ABSTRACT, IApiProblemTypes.CLASS_CHANGED_NON_FINAL_TO_FINAL, IApiProblemTypes.CLASS_CHANGED_TYPE_CONVERSION, IApiProblemTypes.CLASS_CHANGED_DECREASE_ACCESS, IApiProblemTypes.CLASS_REMOVED_FIELD, IApiProblemTypes.CLASS_REMOVED_METHOD, IApiProblemTypes.CLASS_REMOVED_CONSTRUCTOR, IApiProblemTypes.CLASS_REMOVED_SUPERCLASS, IApiProblemTypes.CLASS_REMOVED_TYPE_MEMBER, IApiProblemTypes.CLASS_REMOVED_TYPE_PARAMETER, IApiProblemTypes.FIELD_ADDED_VALUE, IApiProblemTypes.FIELD_CHANGED_TYPE, IApiProblemTypes.FIELD_CHANGED_VALUE, IApiProblemTypes.FIELD_CHANGED_DECREASE_ACCESS, IApiProblemTypes.FIELD_CHANGED_FINAL_TO_NON_FINAL_STATIC_CONSTANT, IApiProblemTypes.FIELD_CHANGED_NON_FINAL_TO_FINAL, IApiProblemTypes.FIELD_CHANGED_STATIC_TO_NON_STATIC, IApiProblemTypes.FIELD_CHANGED_NON_STATIC_TO_STATIC, IApiProblemTypes.FIELD_REMOVED_VALUE, IApiProblemTypes.FIELD_REMOVED_TYPE_ARGUMENT, IApiProblemTypes.METHOD_ADDED_RESTRICTIONS, IApiProblemTypes.METHOD_ADDED_TYPE_PARAMETER, IApiProblemTypes.METHOD_CHANGED_VARARGS_TO_ARRAY, IApiProblemTypes.METHOD_CHANGED_DECREASE_ACCESS, IApiProblemTypes.METHOD_CHANGED_NON_ABSTRACT_TO_ABSTRACT, IApiProblemTypes.METHOD_CHANGED_NON_STATIC_TO_STATIC, IApiProblemTypes.METHOD_CHANGED_STATIC_TO_NON_STATIC, IApiProblemTypes.METHOD_CHANGED_NON_FINAL_TO_FINAL, IApiProblemTypes.METHOD_REMOVED_ANNOTATION_DEFAULT_VALUE, IApiProblemTypes.METHOD_REMOVED_TYPE_PARAMETER, IApiProblemTypes.CONSTRUCTOR_ADDED_TYPE_PARAMETER, IApiProblemTypes.CONSTRUCTOR_CHANGED_VARARGS_TO_ARRAY, IApiProblemTypes.CONSTRUCTOR_CHANGED_DECREASE_ACCESS, IApiProblemTypes.CONSTRUCTOR_REMOVED_TYPE_PARAMETER, IApiProblemTypes.TYPE_PARAMETER_ADDED_CLASS_BOUND, IApiProblemTypes.TYPE_PARAMETER_CHANGED_CLASS_BOUND, IApiProblemTypes.TYPE_PARAMETER_REMOVED_CLASS_BOUND, IApiProblemTypes.TYPE_PARAMETER_ADDED_INTERFACE_BOUND, IApiProblemTypes.TYPE_PARAMETER_CHANGED_INTERFACE_BOUND, IApiProblemTypes.TYPE_PARAMETER_REMOVED_INTERFACE_BOUND, IApiProblemTypes.TYPE_PARAMETER_REMOVED_INTERFACE_BOUND, "report_api_breakage_when_major_version_incremented"};
    private HashSet savelisteners = new HashSet();
    private int logBits = 0;
    private static int LogBits = 0;
    private WorkspaceDeltaProcessor deltaProcessor = null;
    private static final int RESOLUTION_LOG_BIT = 1;
    private static final int BASELINE_DISPOSED_LOG_BIT = 2;

    public ApiPlugin() {
        fgDefault = this;
    }

    public static ApiPlugin getDefault() {
        return fgDefault;
    }

    public static void log(IStatus status) {
        block14: {
            ApiPlugin getDefault;
            block13: {
                getDefault = ApiPlugin.getDefault();
                if (getDefault != null) break block13;
                switch (status.getCode()) {
                    case 122: {
                        if ((LogBits & 1) == 0) {
                            Throwable exception = status.getException();
                            if (exception != null) {
                                exception.printStackTrace();
                            }
                            LogBits |= 1;
                            break;
                        }
                        break block14;
                    }
                    case 123: {
                        if ((LogBits & 2) == 0) {
                            Throwable exception = status.getException();
                            if (exception != null) {
                                exception.printStackTrace();
                            }
                            LogBits |= 2;
                            break;
                        }
                        break block14;
                    }
                    default: {
                        Throwable exception = status.getException();
                        if (exception != null) {
                            exception.printStackTrace();
                            break;
                        }
                        break block14;
                    }
                }
                break block14;
            }
            switch (status.getCode()) {
                case 122: {
                    if ((getDefault.logBits & 1) != 0) break;
                    getDefault.getLog().log(status);
                    getDefault.logBits |= 1;
                    break;
                }
                case 123: {
                    if ((getDefault.logBits & 2) != 0) break;
                    getDefault.getLog().log(status);
                    getDefault.logBits |= 2;
                    break;
                }
                default: {
                    getDefault.getLog().log(status);
                }
            }
        }
    }

    public static void log(Throwable t) {
        ApiPlugin.log(ApiPlugin.newErrorStatus("Error logged from API Tools Core: ", t));
    }

    public static void logErrorMessage(String message) {
        ApiPlugin.log(ApiPlugin.newErrorStatus("Internal message logged from API Tools Core: " + message, null));
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, 120, message, exception);
    }

    public static boolean isRunningInFramework() {
        return fgDefault != null;
    }

    public IApiBaselineManager getApiBaselineManager() {
        return ApiBaselineManager.getManager();
    }

    public static JavadocTagManager getJavadocTagManager() {
        if (fgTagManager == null) {
            fgTagManager = new JavadocTagManager();
        }
        return fgTagManager;
    }

    public void addSaveParticipant(ISaveParticipant participant) {
        if (participant != null) {
            this.savelisteners.add(participant);
        }
    }

    public void removeSaveParticipant(ISaveParticipant participant) {
        if (participant != null) {
            this.savelisteners.remove(participant);
        }
    }

    public void doneSaving(ISaveContext context) {
        ISaveParticipant sp = null;
        Iterator iter = this.savelisteners.iterator();
        while (iter.hasNext()) {
            sp = (ISaveParticipant)iter.next();
            sp.doneSaving(context);
        }
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
        ISaveParticipant sp = null;
        Iterator iter = this.savelisteners.iterator();
        while (iter.hasNext()) {
            sp = (ISaveParticipant)iter.next();
            sp.prepareToSave(context);
        }
    }

    public void rollback(ISaveContext context) {
        ISaveParticipant sp = null;
        Iterator iter = this.savelisteners.iterator();
        while (iter.hasNext()) {
            sp = (ISaveParticipant)iter.next();
            sp.rollback(context);
        }
    }

    public void saving(ISaveContext context) throws CoreException {
        ISaveParticipant sp = null;
        Iterator iter = this.savelisteners.iterator();
        while (iter.hasNext()) {
            sp = (ISaveParticipant)iter.next();
            sp.saving(context);
        }
        IEclipsePreferences node = new InstanceScope().getNode(PLUGIN_ID);
        if (node != null) {
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                ApiPlugin.log(e);
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        try {
            super.start(context);
        }
        finally {
            ResourcesPlugin.getWorkspace().addSaveParticipant(PLUGIN_ID, (ISaveParticipant)this);
            this.deltaProcessor = new WorkspaceDeltaProcessor();
            JavaCore.addElementChangedListener((IElementChangedListener)this.deltaProcessor, (int)1);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.deltaProcessor, 14);
            this.configurePluginDebugOptions();
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            ApiDescriptionManager.shutdown();
            ApiBaselineManager.getManager().stop();
            ResourcesPlugin.getWorkspace().removeSaveParticipant(PLUGIN_ID);
            FileManager.getManager().deleteFiles();
            if (this.deltaProcessor != null) {
                JavaCore.removeElementChangedListener((IElementChangedListener)this.deltaProcessor);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.deltaProcessor);
            }
        }
        finally {
            super.stop(context);
        }
    }

    public int getSeverityLevel(String prefkey, IProject project) {
        IPreferencesService service = Platform.getPreferencesService();
        IScopeContext[] context = null;
        context = this.hasProjectSettings(project) ? new IScopeContext[]{new ProjectScope(project), new DefaultScope()} : new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        String value = service.get(prefkey, null, (Preferences[])this.getPreferences(context));
        if (VALUE_ERROR.equals(value)) {
            return 2;
        }
        if (VALUE_WARNING.equals(value)) {
            return 1;
        }
        return 0;
    }

    IEclipsePreferences[] getPreferences(IScopeContext[] context) {
        if (context != null) {
            ArrayList<IEclipsePreferences> nodes = new ArrayList<IEclipsePreferences>(context.length);
            IEclipsePreferences node = null;
            int i = 0;
            while (i < context.length) {
                node = context[i].getNode(PLUGIN_ID);
                if (node != null) {
                    nodes.add(node);
                }
                ++i;
            }
            if (nodes.size() > 0) {
                return nodes.toArray(new IEclipsePreferences[nodes.size()]);
            }
        }
        return null;
    }

    boolean hasProjectSettings(IProject project) {
        if (project != null) {
            ProjectScope scope = new ProjectScope(project);
            IEclipsePreferences node = scope.getNode(PLUGIN_ID);
            try {
                return node != null && node.keys().length > 0;
            }
            catch (BackingStoreException bse) {
                ApiPlugin.log(bse);
            }
        }
        return false;
    }

    public ISessionManager getSessionManager() {
        if (fgSessionManager == null) {
            fgSessionManager = new SessionManager();
        }
        return fgSessionManager;
    }

    public boolean getEnableState(String prefkey, IProject project) {
        IPreferencesService service = Platform.getPreferencesService();
        IScopeContext[] context = null;
        context = this.hasProjectSettings(project) ? new IScopeContext[]{new ProjectScope(project), new DefaultScope()} : new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        String value = service.get(prefkey, null, (Preferences[])this.getPreferences(context));
        return VALUE_ENABLED.equals(value);
    }

    public void configurePluginDebugOptions() {
        if (ApiPlugin.getDefault().isDebugging()) {
            String option = Platform.getDebugOption((String)BUILDER_DEBUG);
            if (option != null) {
                ApiAnalysisBuilder.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)DELTA_DEBUG)) != null) {
                boolean debugValue = option.equalsIgnoreCase(TRUE);
                ClassFileComparator.setDebug(debugValue);
                ApiComparator.setDebug(debugValue);
            }
            if ((option = Platform.getDebugOption((String)CLASSFILE_VISITOR_DEBUG)) != null) {
                ReferenceExtractor.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)DESCRIPTOR_FRAMEWORK_DEBUG)) != null) {
                ElementDescriptorImpl.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)TAG_SCANNER_DEBUG)) != null) {
                TagScanner.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)PLUGIN_WORKSPACE_COMPONENT_DEBUG)) != null) {
                ProjectComponent.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)API_PROFILE_MANAGER_DEBUG)) != null) {
                ApiBaselineManager.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)API_FILTER_STORE_DEBUG)) != null) {
                ApiFilterStore.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)API_REFERENCE_ANALYZER_DEBUG)) != null) {
                ReferenceAnalyzer.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)REFERENCE_RESOLVER_DEBUG)) != null) {
                ReferenceResolver.setDebug(option.equalsIgnoreCase(TRUE));
            }
            if ((option = Platform.getDebugOption((String)PROBLEM_DETECTOR_DEBUG)) != null) {
                AbstractProblemDetector.setDebug(option.equals(TRUE));
            }
            if ((option = Platform.getDebugOption((String)API_DESCRIPTION)) != null) {
                ApiDescription.setDebug(option.equals(TRUE));
            }
            if ((option = Platform.getDebugOption((String)WORKSPACE_DELTA_PROCESSOR)) != null) {
                WorkspaceDeltaProcessor.setDebug(option.equals(TRUE));
            }
        }
    }
}

