/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.swt.widgets.Shell;

public class AddJarAction
extends RuntimeClasspathAction {
    public AddJarAction(IClasspathViewer viewer) {
        super(ActionMessages.AddJarAction_Add__JARs_1, viewer);
    }

    public void run() {
        IPath[] paths = BuildPathDialogAccess.chooseJAREntries((Shell)this.getShell(), null, (IPath[])this.getSelectedJars());
        if (paths != null && paths.length > 0) {
            IRuntimeClasspathEntry[] res = new IRuntimeClasspathEntry[paths.length];
            int i = 0;
            while (i < res.length) {
                IFile elem = ResourcesPlugin.getWorkspace().getRoot().getFile(paths[i]);
                res[i] = JavaRuntime.newArchiveRuntimeClasspathEntry((IResource)elem);
                ++i;
            }
            this.getViewer().addEntries(res);
        }
    }

    protected IPath[] getSelectedJars() {
        List list = this.getEntriesAsList();
        ArrayList<IPath> jars = new ArrayList<IPath>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            IResource res;
            IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)iter.next();
            if (entry.getType() != 2 || (res = entry.getResource()) == null || !(res instanceof IFile)) continue;
            jars.add(res.getFullPath());
        }
        return jars.toArray(new IPath[jars.size()]);
    }

    protected int getActionType() {
        return 1;
    }
}

