/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class AddSelectedLibraryToBuildpathAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;

    public AddSelectedLibraryToBuildpathAction(IWorkbenchSite site) {
        this(site, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public AddSelectedLibraryToBuildpathAction(IRunnableContext context, ISetSelectionTarget selectionTarget) {
        this(null, selectionTarget, context);
    }

    private AddSelectedLibraryToBuildpathAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, IRunnableContext context) {
        super(site, selectionTarget, 15);
        this.fContext = context;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelLibToCP_label);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_EXTJAR);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelLibToCP_tooltip);
    }

    public String getDetailedDescription() {
        if (!this.isEnabled()) {
            return null;
        }
        IFile file = (IFile)this.getSelectedElements().get(0);
        IJavaProject project = JavaCore.create((IProject)file.getProject());
        try {
            if (ClasspathModifier.isArchive(file, project)) {
                String name = ClasspathModifier.escapeSpecialChars(BasicElementLabels.getResourceName((IResource)file));
                return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ArchiveToBuildpath, name);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_toBuildpath;
    }

    public void run() {
        try {
            final IFile[] files = this.getSelectedElements().toArray(new IFile[this.getSelectedElements().size()]);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IJavaProject project = JavaCore.create((IProject)files[0].getProject());
                        List result = AddSelectedLibraryToBuildpathAction.this.addLibraryEntries(files, project, monitor);
                        AddSelectedLibraryToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.fContext.run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause(), NewWizardMessages.AddSelectedLibraryToBuildpathAction_ErrorTitle);
            } else {
                JavaPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private List addLibraryEntries(IFile[] resources, IJavaProject project, IProgressMonitor monitor) throws CoreException {
        ArrayList<CPListElement> addedEntries = new ArrayList<CPListElement>();
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 4);
            int i = 0;
            while (i < resources.length) {
                IFile res = resources[i];
                addedEntries.add(new CPListElement(project, 1, res.getFullPath(), (IResource)res));
                ++i;
            }
            monitor.worked(1);
            List existingEntries = ClasspathModifier.getExistingEntries(project);
            ClasspathModifier.setNewEntry(existingEntries, addedEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ClasspathModifier.commitClassPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            BuildpathDelta delta = new BuildpathDelta(this.getToolTipText());
            delta.setNewEntries(existingEntries.toArray(new CPListElement[existingEntries.size()]));
            this.informListeners(delta);
            ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>(addedEntries.size());
            int i2 = 0;
            while (i2 < resources.length) {
                IFile res = resources[i2];
                IPackageFragmentRoot elem = project.getPackageFragmentRoot((IResource)res);
                if (elem != null) {
                    result.add(elem);
                }
                ++i2;
            }
            monitor.worked(1);
            ArrayList<IPackageFragmentRoot> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean canHandle(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return false;
        }
        try {
            IJavaProject project;
            IFile file;
            Iterator iter = elements.iterator();
            do {
                if (!iter.hasNext()) {
                    return true;
                }
                Object element = iter.next();
                if (!(element instanceof IFile)) return false;
                file = (IFile)element;
                project = JavaCore.create((IProject)file.getProject());
                if (project != null) continue;
                return false;
            } while (ClasspathModifier.isArchive(file, project));
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

