/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.dialog;

import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.runtime.IStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MaxSeverityValidationStatusProvider
extends ComputedValue<ValidationStatusProvider> {
    private Collection<ValidationStatusProvider> validationStatusProviders;

    public MaxSeverityValidationStatusProvider(DataBindingContext dbc) {
        super(ValidationStatusProvider.class);
        this.validationStatusProviders = dbc.getValidationStatusProviders();
    }

    protected ValidationStatusProvider calculate() {
        int maxSeverity = 0;
        ValidationStatusProvider maxSeverityProvider = null;
        for (ValidationStatusProvider provider : this.validationStatusProviders) {
            IStatus status = (IStatus)provider.getValidationStatus().getValue();
            if (status.getSeverity() <= maxSeverity) continue;
            maxSeverity = status.getSeverity();
            maxSeverityProvider = provider;
        }
        return maxSeverityProvider;
    }

    public synchronized void dispose() {
        this.validationStatusProviders = null;
        super.dispose();
    }
}

