/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.databinding.bindcontrol;

import java.net.URL;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.tests.XWTTestCase;
import org.eclipse.e4.xwt.tests.databinding.bindcontrol.BindMenuItem;
import org.eclipse.e4.xwt.tests.databinding.bindcontrol.TwoRadios;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.MenuItem;

public class ControlBindingTests
extends XWTTestCase {
    public void testMenuItemEnabled() throws Exception {
        URL url = ControlBindingTests.class.getResource(String.valueOf(BindMenuItem.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                this.checkButton();
            }

            public void checkButton() {
                Object element = XWT.findElementByName((Object)ControlBindingTests.this.root, (String)"EnabledButton");
                ControlBindingTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                ControlBindingTests.this.selectButton(button);
            }
        }, new Runnable(){

            public void run() {
                this.checkButton();
            }

            public void checkButton() {
                Object element = XWT.findElementByName((Object)ControlBindingTests.this.root, (String)"EnabledMenuItem");
                ControlBindingTests.assertTrue((boolean)(element instanceof MenuItem));
                MenuItem menuItem = (MenuItem)element;
                ControlBindingTests.assertTrue((boolean)menuItem.getEnabled());
            }
        });
    }

    public void testMenuItemSelection() throws Exception {
        URL url = ControlBindingTests.class.getResource(String.valueOf(BindMenuItem.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                this.checkButton();
            }

            public void checkButton() {
                Object element = XWT.findElementByName((Object)ControlBindingTests.this.root, (String)"SelectionButton");
                ControlBindingTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                ControlBindingTests.this.selectButton(button);
            }
        }, new Runnable(){

            public void run() {
                this.checkButton();
            }

            public void checkButton() {
                Object element = XWT.findElementByName((Object)ControlBindingTests.this.root, (String)"SelectionMenuItem");
                ControlBindingTests.assertTrue((boolean)(element instanceof MenuItem));
                MenuItem menuItem = (MenuItem)element;
                ControlBindingTests.assertTrue((boolean)menuItem.getSelection());
            }
        });
    }

    public void testMenuItemUnselection() throws Exception {
        URL url = ControlBindingTests.class.getResource(String.valueOf(BindMenuItem.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                this.checkButton();
            }

            public void checkButton() {
                Object element = XWT.findElementByName((Object)ControlBindingTests.this.root, (String)"SelectionButton");
                ControlBindingTests.assertTrue((boolean)(element instanceof Button));
                Button button = (Button)element;
                ControlBindingTests.this.selectButton(button);
                ControlBindingTests.this.selectButton(button, false);
            }
        }, new Runnable(){

            public void run() {
                this.checkButton();
            }

            public void checkButton() {
                Object element = XWT.findElementByName((Object)ControlBindingTests.this.root, (String)"SelectionMenuItem");
                ControlBindingTests.assertTrue((boolean)(element instanceof MenuItem));
                MenuItem menuItem = (MenuItem)element;
                ControlBindingTests.assertFalse((boolean)menuItem.getSelection());
            }
        });
    }

    public void testTwoRadios() throws Exception {
        URL url = ControlBindingTests.class.getResource(String.valueOf(TwoRadios.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                Button radio1 = (Button)XWT.findElementByName((Object)ControlBindingTests.this.root, (String)"button1");
                Button radio2 = (Button)XWT.findElementByName((Object)ControlBindingTests.this.root, (String)"button2");
                this.checkInitial(radio1, radio2);
            }

            private void checkInitial(Button radio1, Button radio2) {
                if (!radio2.getEnabled()) {
                    ControlBindingTests.fail((String)"radio2 should have been enabled");
                }
            }
        });
    }

    public void testTwoRadios_Select1() throws Exception {
        URL url = ControlBindingTests.class.getResource(String.valueOf(TwoRadios.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                Button radio1 = (Button)XWT.findElementByName((Object)ControlBindingTests.this.root, (String)"button1");
                ControlBindingTests.this.selectButton(radio1, true);
            }
        }, new Runnable(){

            public void run() {
                Button radio1 = (Button)XWT.findElementByName((Object)ControlBindingTests.this.root, (String)"button1");
                Button radio2 = (Button)XWT.findElementByName((Object)ControlBindingTests.this.root, (String)"button2");
                this.checkSelected(radio1, radio2);
            }

            private void checkSelected(Button radio1, Button radio2) {
                if (radio2.getEnabled()) {
                    ControlBindingTests.fail((String)"radio2 should have been disabled");
                }
            }
        });
    }

    public void testTwoRadios_UnSelect1() throws Exception {
        URL url = ControlBindingTests.class.getResource(String.valueOf(TwoRadios.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                Button radio1 = (Button)XWT.findElementByName((Object)ControlBindingTests.this.root, (String)"button1");
                ControlBindingTests.this.selectButton(radio1, true);
            }
        }, new Runnable(){

            public void run() {
                Button radio1 = (Button)XWT.findElementByName((Object)ControlBindingTests.this.root, (String)"button1");
                ControlBindingTests.this.selectButton(radio1, false);
            }
        }, new Runnable(){

            public void run() {
                Button radio2 = (Button)XWT.findElementByName((Object)ControlBindingTests.this.root, (String)"button2");
                if (!radio2.getEnabled()) {
                    ControlBindingTests.fail((String)"radio2 should have been disabled");
                }
            }
        });
    }
}

