/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.e4.xwt.IUIResource;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XWTTestCase
extends TestCase {
    protected Control root;
    static boolean simulateMThreading = false;

    static {
        if (simulateMThreading) {
            Thread thread = new Thread(){

                public void run() {
                    Display.getDefault();
                }
            };
            thread.start();
            try {
                thread.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        XWTTestCase.clearnUpDisplay();
    }

    public static void clearnUpDisplay() {
        try {
            Field field;
            Field displaysField = Display.class.getDeclaredField("Displays");
            if (displaysField != null) {
                displaysField.setAccessible(true);
                Display[] displays = (Display[])displaysField.get(null);
                if (displays != null) {
                    int i = 0;
                    while (i < displays.length) {
                        displays[i] = null;
                        ++i;
                    }
                }
            }
            if ((field = Display.class.getDeclaredField("Default")) != null) {
                field.setAccessible(true);
                Display defaultDisplay = (Display)field.get(null);
                if (defaultDisplay != null) {
                    field.set(null, null);
                }
            }
        }
        catch (Exception exception) {}
    }

    protected void runTest(URL url, Runnable ... checkActions) {
        this.runTest(url, new HashMap<String, Object>(), checkActions);
    }

    protected void runTest(IUIResource pattern, Runnable ... checkActions) {
        this.runTest(pattern, new HashMap<String, Object>(), checkActions);
    }

    protected void runTest(URL url, Object dataContext, Runnable ... checkActions) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.DataContext", dataContext);
        this.runTest(url, options, checkActions);
    }

    protected void runTest(IUIResource pattern, Object dataContext, Runnable ... checkActions) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.DataContext", dataContext);
        this.runTest(pattern, options, checkActions);
    }

    protected void runTest(final URL url, final Map<String, Object> options, final Runnable ... checkActions) {
        XWT.runOnUIThread((Runnable)new Runnable(){

            public void run() {
                XWTTestCase.this.doRunTest(url, (Map<String, Object>)options, checkActions);
            }
        });
    }

    private void doRunTest(URL url, Map<String, Object> options, Runnable ... checkActions) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                Object element = XWT.loadWithOptions((URL)url, options);
                XWTTestCase.assertTrue((boolean)(element instanceof Control));
                XWTTestCase.assertNotNull((Object)element);
                this.root = (Control)element;
                Shell shell = this.root.getShell();
                shell.open();
                Display display = shell.getDisplay();
                try {
                    Runnable[] runnableArray = checkActions;
                    int n = checkActions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Runnable runnable = runnableArray[n2];
                        while (display.readAndDispatch()) {
                        }
                        display.syncExec(runnable);
                        while (display.readAndDispatch()) {
                        }
                        while (display.readAndDispatch()) {
                        }
                        ++n2;
                    }
                    XWTTestCase.assertFalse((boolean)this.root.isDisposed());
                }
                finally {
                    try {
                        shell.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                while (display.readAndDispatch()) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                XWTTestCase.fail((String)e.getMessage());
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected void runTest(final IUIResource pattern, final Map<String, Object> options, final Runnable ... checkActions) {
        XWT.runOnUIThread((Runnable)new Runnable(){

            public void run() {
                XWTTestCase.this.doRunTest(pattern, (Map<String, Object>)options, checkActions);
            }
        });
    }

    private void doRunTest(IUIResource pattern, Map<String, Object> options, Runnable ... checkActions) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                Object widget = XWT.loadWithOptions((IUIResource)pattern, options);
                XWTTestCase.assertTrue((boolean)(widget instanceof Control));
                XWTTestCase.assertNotNull((Object)widget);
                this.root = (Control)widget;
                Shell shell = this.root.getShell();
                shell.open();
                Display display = shell.getDisplay();
                try {
                    Runnable[] runnableArray = checkActions;
                    int n = checkActions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Runnable runnable = runnableArray[n2];
                        while (display.readAndDispatch()) {
                        }
                        display.syncExec(runnable);
                        while (display.readAndDispatch()) {
                        }
                        while (display.readAndDispatch()) {
                        }
                        ++n2;
                    }
                    XWTTestCase.assertFalse((boolean)this.root.isDisposed());
                }
                finally {
                    try {
                        shell.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                while (display.readAndDispatch()) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                XWTTestCase.fail((String)e.getMessage());
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected void runDebugTest(URL url, Runnable prepareAction, Runnable checkAction1) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                Object widget = XWT.load((URL)url);
                XWTTestCase.assertTrue((boolean)(widget instanceof Control));
                XWTTestCase.assertNotNull((Object)widget);
                this.root = (Control)widget;
                XWTTestCase.assertNotNull((Object)this.root);
                Shell shell = this.root.getShell();
                shell.open();
                Display display = shell.getDisplay();
                if (prepareAction != null) {
                    display.asyncExec(prepareAction);
                }
                while (!display.isDisposed()) {
                    display.readAndDispatch();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                XWTTestCase.fail((String)e.getMessage());
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected void runDebugTest(IUIResource pattern, Runnable prepareAction, Runnable checkAction1) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                Object widget = XWT.load((IUIResource)pattern);
                XWTTestCase.assertTrue((boolean)(widget instanceof Control));
                XWTTestCase.assertNotNull((Object)widget);
                this.root = (Control)widget;
                XWTTestCase.assertNotNull((Object)this.root);
                Shell shell = this.root.getShell();
                shell.open();
                Display display = shell.getDisplay();
                if (prepareAction != null) {
                    display.asyncExec(prepareAction);
                }
                while (!display.isDisposed()) {
                    display.readAndDispatch();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                XWTTestCase.fail((String)e.getMessage());
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    protected void selectButton(Button button) {
        this.selectButton(button, true);
    }

    protected void checkVisibility(String name, Class<? extends Control> type) {
        Object element = XWT.findElementByName((Object)this.root, (String)name);
        if (element == null) {
            XWTTestCase.fail((String)(String.valueOf(name) + " is not found."));
        }
        XWTTestCase.assertTrue((boolean)type.isInstance(element));
        Control section = (Control)element;
        XWTTestCase.assertTrue((boolean)section.getVisible());
    }

    protected void checkChildren(String name, String path, int number) {
        Object element = XWT.findElementByName((Object)this.root, (String)name);
        if (path != null) {
            try {
                Method method = element.getClass().getMethod("get" + path, new Class[0]);
                if (method == null) {
                    XWTTestCase.fail((String)("Property " + path + " is not found in " + element.getClass().getName()));
                }
                element = method.invoke(element, new Object[0]);
                XWTTestCase.assertTrue((boolean)Composite.class.isInstance(element));
            }
            catch (Exception e) {
                e.printStackTrace();
                XWTTestCase.fail((String)e.getMessage());
            }
        }
        XWTTestCase.assertTrue((boolean)Composite.class.isInstance(element));
        Composite composite = (Composite)element;
        XWTTestCase.assertEquals((int)composite.getChildren().length, (int)number);
    }

    protected void checkChildren(String name, int number) {
        this.checkChildren(name, null, number);
    }

    protected void selectButton(Button button, boolean selection) {
        Point size = button.getSize();
        Display display = button.getDisplay();
        Event upEvent = new Event();
        upEvent.widget = button;
        upEvent.button = 1;
        upEvent.type = 4;
        upEvent.x = size.x / 2;
        upEvent.y = size.y / 2;
        this.displayPost(display, upEvent);
        button.setSelection(selection);
        button.notifyListeners(13, upEvent);
    }

    protected void setFocusOut(Widget widget) {
        this.setFocus(widget, false);
    }

    protected void setFocusIn(Widget widget) {
        this.setFocus(widget, true);
    }

    private void setFocus(Widget widget, boolean focus) {
        Display display = widget.getDisplay();
        Event upEvent = new Event();
        upEvent.widget = widget;
        upEvent.button = 1;
        upEvent.type = 4;
        this.displayPost(display, upEvent);
        if (focus) {
            widget.notifyListeners(15, upEvent);
        } else {
            widget.notifyListeners(16, upEvent);
        }
    }

    protected void assertText(String name, String value) {
        Object element = XWT.findElementByName((Object)this.root, (String)name);
        XWTTestCase.assertTrue((boolean)(element instanceof Text));
        Text text = (Text)element;
        XWTTestCase.assertEquals((String)value, (String)text.getText());
    }

    protected void setText(String name, String value) {
        Object element = XWT.findElementByName((Object)this.root, (String)name);
        XWTTestCase.assertTrue((boolean)(element instanceof Text));
        Text text = (Text)element;
        text.setText(value);
    }

    protected void assertEqualsArray(Object[] source, Object[] target) {
        XWTTestCase.assertEquals((int)source.length, (int)target.length);
        int i = 0;
        while (i < source.length) {
            XWTTestCase.assertEquals((Object)source[i], (Object)target[i]);
            ++i;
        }
    }

    private void displayPost(Display display, Event event) {
        block3: {
            if (SWT.getPlatform() != "rap") {
                try {
                    Method m = Display.class.getDeclaredMethod("post", Event.class);
                    m.invoke((Object)display, event);
                }
                catch (Exception exception) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
    }
}

