/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.script.js.text.scanners;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.tools.emf.ui.script.js.text.scanners.AbstractJavaScanner;
import org.eclipse.e4.tools.emf.ui.script.js.text.scanners.CombinedWordRule;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class JavaScriptCommentScanner
extends AbstractJavaScanner {
    private String fDefaultTokenProperty;
    private String[] fTokenProperties;

    public JavaScriptCommentScanner(IResourcePool manager, IPreferenceStore store, String defaultTokenProperty) {
        this(manager, store, defaultTokenProperty, new String[]{defaultTokenProperty});
    }

    public JavaScriptCommentScanner(IResourcePool manager, IPreferenceStore store, String defaultTokenProperty, String[] tokenProperties) {
        super(manager, store);
        this.fDefaultTokenProperty = defaultTokenProperty;
        this.fTokenProperties = tokenProperties;
        this.initialize();
    }

    @Override
    protected List<IRule> createRules() {
        ArrayList<IRule> list = new ArrayList<IRule>();
        Token defaultToken = this.getToken(this.fDefaultTokenProperty);
        List<CombinedWordRule.WordMatcher> matchers = this.createMatchers();
        if (matchers.size() > 0) {
            CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)new AtJavaIdentifierDetector(), (IToken)defaultToken);
            int i = 0;
            int n = matchers.size();
            while (i < n) {
                combinedWordRule.addWordMatcher(matchers.get(i));
                ++i;
            }
            list.add(combinedWordRule);
        }
        this.setDefaultReturnToken((IToken)defaultToken);
        return list;
    }

    protected List<CombinedWordRule.WordMatcher> createMatchers() {
        ArrayList<CombinedWordRule.WordMatcher> list = new ArrayList<CombinedWordRule.WordMatcher>();
        return list;
    }

    @Override
    protected String[] getTokenProperties() {
        return this.fTokenProperties;
    }

    private static class AtJavaIdentifierDetector
    implements IWordDetector {
        private AtJavaIdentifierDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '@' || Character.isJavaIdentifierStart(c);
        }

        public boolean isWordPart(char c) {
            return c == '.' || Character.isJavaIdentifierPart(c);
        }
    }
}

