/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.result.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;

public class GenericResultContentProvider
implements ITreeContentProvider {
    private Set<ITreeContentProvider> contentProviders = new HashSet<ITreeContentProvider>();
    private final Set<IGenericViewCustomization> customizations;

    public GenericResultContentProvider(Set<IGenericViewCustomization> viewCustomizations) {
        this.customizations = Collections.unmodifiableSet(viewCustomizations);
        for (IGenericViewCustomization cust : this.customizations) {
            ITreeContentProvider cp = cust.getContentProvider();
            if (cp == null) continue;
            this.contentProviders.add(cp);
        }
    }

    protected Set<IGenericViewCustomization> availableCustomizations() {
        return this.customizations;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (ITreeContentProvider cp : this.contentProviders) {
            Object[] objects = cp.getElements(inputElement);
            if (objects == null) continue;
            result.addAll(Arrays.asList(objects));
        }
        return result.toArray();
    }

    public void dispose() {
        for (ITreeContentProvider cp : this.contentProviders) {
            cp.dispose();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        for (ITreeContentProvider cp : this.contentProviders) {
            cp.inputChanged(viewer, oldInput, newInput);
        }
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (ITreeContentProvider cp : this.contentProviders) {
            Object[] objects = cp.getChildren(parentElement);
            if (objects == null) continue;
            result.addAll(Arrays.asList(objects));
        }
        return result.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        for (ITreeContentProvider cp : this.contentProviders) {
            if (!cp.hasChildren(element)) continue;
            return true;
        }
        return false;
    }
}

