/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.platform.discovery.ui.api.ISearchFavoritesViewCustomization;
import org.eclipse.platform.discovery.ui.internal.view.ISearchFavoritesItemsAdder;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;

public abstract class SearchFavoritesItemsAdder
implements ISearchFavoritesItemsAdder {
    private final Set<ISearchFavoritesViewCustomization> viewCustomizations;
    private final ILongOperationRunner opRunner;

    public SearchFavoritesItemsAdder(Set<ISearchFavoritesViewCustomization> viewCustomizations, ILongOperationRunner opRunner) {
        this.viewCustomizations = viewCustomizations;
        this.opRunner = opRunner;
    }

    @Override
    public void addItems(ISelection selectedItems) {
        if (!this.canAddSelection(selectedItems)) {
            throw new IllegalArgumentException("Selection is not acceptable");
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selectedItems;
        Iterator iterator = structuredSelection.iterator();
        HashSet<Object> objectsToAdd = new HashSet<Object>();
        while (iterator.hasNext()) {
            objectsToAdd.addAll(this.itemsForSource(iterator.next()));
        }
        this.doAddItems(objectsToAdd, this.opRunner);
    }

    protected abstract void doAddItems(Set<Object> var1, ILongOperationRunner var2);

    @Override
    public boolean canAddSelection(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        Iterator iterator = ((IStructuredSelection)selection).iterator();
        while (iterator.hasNext()) {
            if (this.isFavoritesItemSupported(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isFavoritesItemSupported(Object itemsSource) {
        return !this.itemsForSource(itemsSource).isEmpty();
    }

    private Collection<Object> itemsForSource(Object itemsSource) {
        HashSet<Object> result = new HashSet<Object>();
        for (ISearchFavoritesViewCustomization cust : this.viewCustomizations) {
            result.addAll(cust.itemsFor(itemsSource));
        }
        return result;
    }
}

