/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.editor.text.assist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class SelectionCompletionProposal
implements ICompletionProposal {
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private int fSelectionlength;
    private Image fImage;
    private IContextInformation fContextInformation;
    private String fAdditionalProposalInfo;

    public SelectionCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, 0, null, null, null, null);
    }

    public SelectionCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, int selectionLength, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fSelectionlength = selectionLength;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, this.fSelectionlength);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public void setDisplayString(String displayString) {
        this.fDisplayString = displayString;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public void setReplacementString(String replacementString) {
        this.fReplacementString = replacementString;
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public void setReplacementOffset(int replacementOffset) {
        this.fReplacementOffset = replacementOffset;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public void setReplacementLength(int replacementLength) {
        this.fReplacementLength = replacementLength;
    }

    public int getCursorPosition() {
        return this.fCursorPosition;
    }

    public void setCursorPosition(int cursorPosition) {
        this.fCursorPosition = cursorPosition;
    }

    public int getSelectionlength() {
        return this.fSelectionlength;
    }

    public void setSelectionlength(int selectionlength) {
        this.fSelectionlength = selectionlength;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public void setContextInformation(IContextInformation contextInformation) {
        this.fContextInformation = contextInformation;
    }

    public void setAdditionalProposalInfo(String additionalProposalInfo) {
        this.fAdditionalProposalInfo = additionalProposalInfo;
    }
}

