/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.snippet017;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.tests.XWTTestCase;
import org.eclipse.e4.xwt.tests.snippet017.Person;
import org.eclipse.e4.xwt.tests.snippet017.TableViewerWithDerivedColumns;
import org.eclipse.e4.xwt.tests.snippet017.ViewModel;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Snippet017Tests
extends XWTTestCase {
    protected Person findPerson(List<Person> people, String name) {
        for (Person person : people) {
            if (!name.equals(person.getName())) continue;
            return person;
        }
        return null;
    }

    public void testTableViewerWithDerivedColumns() throws Exception {
        URL url = Snippet017Tests.class.getResource(String.valueOf(TableViewerWithDerivedColumns.class.getSimpleName()) + ".xwt");
        this.runTest(url, (Object)new ViewModel(), new Runnable(){

            public void run() {
                Object element = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"TableViewer");
                Snippet017Tests.assertTrue((boolean)(element instanceof TableViewer));
                TableViewer tableViewer = (TableViewer)element;
                Object dataContext = XWT.getDataContext((Object)element);
                Snippet017Tests.assertTrue((boolean)(dataContext instanceof ViewModel));
                ViewModel viewModel = (ViewModel)dataContext;
                ArrayList<Person> people = viewModel.getPeople();
                IObservableValue observableValue = XWT.observableValue((Object)tableViewer, null, (String)"singleSelection");
                Person person = Snippet017Tests.this.findPerson(people, "Scrooge McDuck");
                observableValue.setValue((Object)person);
            }
        }, new Runnable(){

            public void run() {
                Object viewer = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"TableViewer");
                Snippet017Tests.assertTrue((boolean)(viewer instanceof TableViewer));
                TableViewer tableViewer = (TableViewer)viewer;
                Object dataContext = XWT.getDataContext((Object)viewer);
                Snippet017Tests.assertTrue((boolean)(dataContext instanceof ViewModel));
                ViewModel viewModel = (ViewModel)dataContext;
                ArrayList<Person> people = viewModel.getPeople();
                IObservableValue observableValue = XWT.observableValue((Object)tableViewer, null, (String)"singleSelection");
                Person person = Snippet017Tests.this.findPerson(people, "Scrooge McDuck");
                Snippet017Tests.assertEquals((Object)observableValue.getValue(), (Object)person);
                Object element = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"NameText");
                Snippet017Tests.assertTrue((boolean)(element instanceof Text));
                Text nameText = (Text)element;
                Snippet017Tests.assertEquals((String)nameText.getText(), (String)"Scrooge McDuck");
                element = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"MotherCombo");
                Snippet017Tests.assertTrue((boolean)(element instanceof ComboViewer));
                ComboViewer comboViewer = (ComboViewer)element;
                IObservableValue singleSelection = XWT.observableValue((Object)comboViewer, null, (String)"singleSelection");
                Object selected = singleSelection.getValue();
                Snippet017Tests.assertTrue((boolean)(selected instanceof Person));
                Person mother = (Person)selected;
                Snippet017Tests.assertEquals((String)mother.getName(), (String)"Downy O'Drake");
                element = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"FatherCombo");
                Snippet017Tests.assertTrue((boolean)(element instanceof ComboViewer));
                comboViewer = (ComboViewer)element;
                singleSelection = XWT.observableValue((Object)comboViewer, null, (String)"singleSelection");
                selected = singleSelection.getValue();
                Snippet017Tests.assertTrue((boolean)(selected instanceof Person));
                mother = (Person)selected;
                Snippet017Tests.assertEquals((String)mother.getName(), (String)"Fergus McDuck");
            }
        });
    }

    public void testTableViewerWithDerivedColumns_Text() throws Exception {
        URL url = Snippet017Tests.class.getResource(String.valueOf(TableViewerWithDerivedColumns.class.getSimpleName()) + ".xwt");
        this.runTest(url, (Object)new ViewModel(), new Runnable(){

            public void run() {
                Object element = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"TableViewer");
                Snippet017Tests.assertTrue((boolean)(element instanceof TableViewer));
                TableViewer tableViewer = (TableViewer)element;
                Object dataContext = XWT.getDataContext((Object)element);
                Snippet017Tests.assertTrue((boolean)(dataContext instanceof ViewModel));
                ViewModel viewModel = (ViewModel)dataContext;
                ArrayList<Person> people = viewModel.getPeople();
                IObservableValue observableValue = XWT.observableValue((Object)tableViewer, null, (String)"singleSelection");
                Person person = Snippet017Tests.this.findPerson(people, "Scrooge McDuck");
                observableValue.setValue((Object)person);
                Object text = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"NameText");
                Snippet017Tests.assertTrue((boolean)(text instanceof Text));
                Text nameText = (Text)text;
                nameText.setText("Scrooge McDuck Junor");
            }
        }, new Runnable(){

            public void run() {
                Object viewer = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"TableViewer");
                Snippet017Tests.assertTrue((boolean)(viewer instanceof TableViewer));
                TableViewer tableViewer = (TableViewer)viewer;
                Object dataContext = XWT.getDataContext((Object)viewer);
                Snippet017Tests.assertTrue((boolean)(dataContext instanceof ViewModel));
                ViewModel viewModel = (ViewModel)dataContext;
                ArrayList<Person> people = viewModel.getPeople();
                IObservableValue observableValue = XWT.observableValue((Object)tableViewer, null, (String)"singleSelection");
                Person person = Snippet017Tests.this.findPerson(people, "Scrooge McDuck Junor");
                Snippet017Tests.assertTrue((person != null ? 1 : 0) != 0);
                Snippet017Tests.assertEquals((Object)observableValue.getValue(), (Object)person);
                Object element = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"NameText");
                Snippet017Tests.assertTrue((boolean)(element instanceof Text));
                Text nameText = (Text)element;
                Snippet017Tests.assertEquals((String)nameText.getText(), (String)"Scrooge McDuck Junor");
            }
        });
    }

    public void testTableViewerWithDerivedColumns_TextAPI() throws Exception {
        URL url = Snippet017Tests.class.getResource(String.valueOf(TableViewerWithDerivedColumns.class.getSimpleName()) + ".xwt");
        this.runTest(url, (Object)new ViewModel(), new Runnable(){

            public void run() {
                Object element = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"TableViewer");
                Snippet017Tests.assertTrue((boolean)(element instanceof TableViewer));
                TableViewer tableViewer = (TableViewer)element;
                Object dataContext = XWT.getDataContext((Object)element);
                Snippet017Tests.assertTrue((boolean)(dataContext instanceof ViewModel));
                ViewModel viewModel = (ViewModel)dataContext;
                ArrayList<Person> people = viewModel.getPeople();
                IObservableValue observableValue = XWT.observableValue((Object)tableViewer, null, (String)"singleSelection");
                Person person = Snippet017Tests.this.findPerson(people, "Scrooge McDuck");
                observableValue.setValue((Object)person);
                Object text = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"NameText");
                Snippet017Tests.assertTrue((boolean)(text instanceof Text));
                Text nameText = (Text)text;
                IObservableValue textValue = XWT.observableValue((Object)nameText, null, (String)"text");
                textValue.setValue((Object)"Scrooge McDuck Junor");
            }
        }, new Runnable(){

            public void run() {
                Object viewer = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"TableViewer");
                Snippet017Tests.assertTrue((boolean)(viewer instanceof TableViewer));
                TableViewer tableViewer = (TableViewer)viewer;
                Object dataContext = XWT.getDataContext((Object)viewer);
                Snippet017Tests.assertTrue((boolean)(dataContext instanceof ViewModel));
                ViewModel viewModel = (ViewModel)dataContext;
                ArrayList<Person> people = viewModel.getPeople();
                IObservableValue observableValue = XWT.observableValue((Object)tableViewer, null, (String)"singleSelection");
                Person person = Snippet017Tests.this.findPerson(people, "Scrooge McDuck Junor");
                Snippet017Tests.assertTrue((person != null ? 1 : 0) != 0);
                Snippet017Tests.assertEquals((Object)observableValue.getValue(), (Object)person);
                Object element = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"NameText");
                Snippet017Tests.assertTrue((boolean)(element instanceof Text));
                Text nameText = (Text)element;
                Snippet017Tests.assertEquals((String)nameText.getText(), (String)"Scrooge McDuck Junor");
            }
        });
    }

    public void testTableViewerWithDerivedColumns_MotherCombo() throws Exception {
        URL url = Snippet017Tests.class.getResource(String.valueOf(TableViewerWithDerivedColumns.class.getSimpleName()) + ".xwt");
        this.runTest(url, (Object)new ViewModel(), new Runnable(){

            public void run() {
                Object viewer = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"TableViewer");
                Snippet017Tests.assertTrue((boolean)(viewer instanceof TableViewer));
                TableViewer tableViewer = (TableViewer)viewer;
                Object dataContext = XWT.getDataContext((Object)viewer);
                Snippet017Tests.assertTrue((boolean)(dataContext instanceof ViewModel));
                ViewModel viewModel = (ViewModel)dataContext;
                ArrayList<Person> people = viewModel.getPeople();
                IObservableValue observableValue = XWT.observableValue((Object)tableViewer, null, (String)"singleSelection");
                Person person = Snippet017Tests.this.findPerson(people, "Scrooge McDuck");
                observableValue.setValue((Object)person);
                Object element = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"MotherCombo");
                Snippet017Tests.assertTrue((boolean)(element instanceof ComboViewer));
                ComboViewer comboViewer = (ComboViewer)element;
                IObservableValue singleSelection = XWT.observableValue((Object)comboViewer, null, (String)"singleSelection");
                Object selected = singleSelection.getValue();
                Snippet017Tests.assertTrue((boolean)(selected instanceof Person));
                Person mother = (Person)selected;
                Snippet017Tests.assertEquals((String)mother.getName(), (String)"Downy O'Drake");
                Person newMother = Snippet017Tests.this.findPerson(people, "Della Duck");
                singleSelection.setValue((Object)newMother);
            }
        }, new Runnable(){

            public void run() {
                Object viewer = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"TableViewer");
                Snippet017Tests.assertTrue((boolean)(viewer instanceof TableViewer));
                TableViewer tableViewer = (TableViewer)viewer;
                Object dataContext = XWT.getDataContext((Object)viewer);
                Snippet017Tests.assertTrue((boolean)(dataContext instanceof ViewModel));
                ViewModel viewModel = (ViewModel)dataContext;
                ArrayList<Person> people = viewModel.getPeople();
                IObservableValue observableValue = XWT.observableValue((Object)tableViewer, null, (String)"singleSelection");
                Person person = Snippet017Tests.this.findPerson(people, "Scrooge McDuck");
                Snippet017Tests.assertEquals((Object)observableValue.getValue(), (Object)person);
                Person newMother = Snippet017Tests.this.findPerson(people, "Della Duck");
                Snippet017Tests.assertEquals((Object)person.getMother(), (Object)newMother);
                Object element = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"MotherCombo");
                Snippet017Tests.assertTrue((boolean)(element instanceof ComboViewer));
                ComboViewer comboViewer = (ComboViewer)element;
                IObservableValue singleSelection = XWT.observableValue((Object)comboViewer, null, (String)"singleSelection");
                Object selected = singleSelection.getValue();
                Snippet017Tests.assertTrue((boolean)(selected instanceof Person));
                Person mother = (Person)selected;
                Snippet017Tests.assertEquals((Object)mother, (Object)newMother);
            }
        });
    }

    public void testTableViewerWithDerivedColumns_MotherCombo_API() throws Exception {
        URL url = Snippet017Tests.class.getResource(String.valueOf(TableViewerWithDerivedColumns.class.getSimpleName()) + ".xwt");
        this.runTest(url, (Object)new ViewModel(), new Runnable(){

            public void run() {
                Object viewer = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"TableViewer");
                Snippet017Tests.assertTrue((boolean)(viewer instanceof TableViewer));
                TableViewer tableViewer = (TableViewer)viewer;
                Object dataContext = XWT.getDataContext((Object)viewer);
                Snippet017Tests.assertTrue((boolean)(dataContext instanceof ViewModel));
                ViewModel viewModel = (ViewModel)dataContext;
                ArrayList<Person> people = viewModel.getPeople();
                IObservableValue observableValue = XWT.observableValue((Object)tableViewer, null, (String)"singleSelection");
                Person person = Snippet017Tests.this.findPerson(people, "Scrooge McDuck");
                observableValue.setValue((Object)person);
                Object element = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"MotherCombo");
                Snippet017Tests.assertTrue((boolean)(element instanceof ComboViewer));
                ComboViewer comboViewer = (ComboViewer)element;
                IObservableValue singleSelection = XWT.observableValue((Object)comboViewer, null, (String)"singleSelection");
                Object selected = singleSelection.getValue();
                Snippet017Tests.assertTrue((boolean)(selected instanceof Person));
                Person mother = (Person)selected;
                Snippet017Tests.assertEquals((String)mother.getName(), (String)"Downy O'Drake");
                Person newMother = Snippet017Tests.this.findPerson(people, "Della Duck");
                IObservableValue motherValue = XWT.observableValue((Object)comboViewer, (Object)person, (String)"mother");
                motherValue.setValue((Object)newMother);
            }
        }, new Runnable(){

            public void run() {
                Object viewer = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"TableViewer");
                Snippet017Tests.assertTrue((boolean)(viewer instanceof TableViewer));
                TableViewer tableViewer = (TableViewer)viewer;
                Object dataContext = XWT.getDataContext((Object)viewer);
                Snippet017Tests.assertTrue((boolean)(dataContext instanceof ViewModel));
                ViewModel viewModel = (ViewModel)dataContext;
                ArrayList<Person> people = viewModel.getPeople();
                IObservableValue observableValue = XWT.observableValue((Object)tableViewer, null, (String)"singleSelection");
                Person person = Snippet017Tests.this.findPerson(people, "Scrooge McDuck");
                Snippet017Tests.assertEquals((Object)observableValue.getValue(), (Object)person);
                Person newMother = Snippet017Tests.this.findPerson(people, "Della Duck");
                Snippet017Tests.assertEquals((Object)person.getMother(), (Object)newMother);
                Object element = XWT.findElementByName((Object)Snippet017Tests.this.root, (String)"MotherCombo");
                Snippet017Tests.assertTrue((boolean)(element instanceof ComboViewer));
                ComboViewer comboViewer = (ComboViewer)element;
                IObservableValue singleSelection = XWT.observableValue((Object)comboViewer, null, (String)"singleSelection");
                Object selected = singleSelection.getValue();
                Snippet017Tests.assertTrue((boolean)(selected instanceof Person));
                Person mother = (Person)selected;
                Snippet017Tests.assertEquals((Object)mother, (Object)newMother);
            }
        });
    }
}

