/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.databinding.validation;

import java.net.URL;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.tests.XWTTestCase;
import org.eclipse.e4.xwt.tests.databinding.validation.Validation;
import org.eclipse.e4.xwt.tests.databinding.validation.ValidationSingle;
import org.eclipse.swt.widgets.Text;

public class ValidationsTests
extends XWTTestCase {
    public void testValidation() throws Exception {
        URL url = ValidationsTests.class.getResource(String.valueOf(Validation.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                Text text1 = (Text)XWT.findElementByName((Object)ValidationsTests.this.root, (String)"text1");
                Text text2 = (Text)XWT.findElementByName((Object)ValidationsTests.this.root, (String)"text2");
                this.checkValidationFailure1(text1, text2);
                this.checkValidationFailure2(text1, text2);
                this.checkValidationOk(text1, text2);
            }

            private void checkValidationOk(Text text1, Text text2) {
                text2.setText("test3");
                text1.setText("LongEnough");
                ValidationsTests.assertEquals((String)text2.getText(), (String)"LongEnough");
            }

            private void checkValidationFailure2(Text text1, Text text2) {
                text2.setText("test2");
                text1.setText("short");
                ValidationsTests.assertEquals((String)text2.getText(), (String)"test2");
            }

            private void checkValidationFailure1(Text text1, Text text2) {
                text2.setText("test1");
                text1.setText("");
                ValidationsTests.assertEquals((String)text2.getText(), (String)"test1");
            }
        });
    }

    public void testValidation_Single() throws Exception {
        URL url = ValidationSingle.class.getResource(String.valueOf(ValidationSingle.class.getSimpleName()) + ".xwt");
        this.runTest(url, new Runnable(){

            public void run() {
                Text text1 = (Text)XWT.findElementByName((Object)ValidationsTests.this.root, (String)"text1");
                Text text2 = (Text)XWT.findElementByName((Object)ValidationsTests.this.root, (String)"text2");
                this.checkValidationFailure1(text1, text2);
                this.checkValidationFailure2(text1, text2);
                this.checkValidationOk(text1, text2);
            }

            private void checkValidationOk(Text text1, Text text2) {
                text2.setText("test3");
                text1.setText("LongEnough");
                ValidationsTests.assertEquals((String)text2.getText(), (String)"LongEnough");
            }

            private void checkValidationFailure2(Text text1, Text text2) {
                text2.setText("test2");
                text1.setText("short");
                ValidationsTests.assertEquals((String)text2.getText(), (String)"test2");
            }

            private void checkValidationFailure1(Text text1, Text text2) {
                text2.setText("test1");
                text1.setText("");
                ValidationsTests.assertEquals((String)text2.getText(), (String)"test1");
            }
        });
    }
}

