/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.controls.layout;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class StackLayout_Test {
    private static Group layoutGrp;
    private static Control current;
    private static List<Control> controls;

    static {
        controls = new ArrayList<Control>();
    }

    public static void main(String[] args) {
        URL url = StackLayout_Test.class.getResource(String.valueOf(StackLayout_Test.class.getSimpleName()) + ".xwt");
        try {
            XWT.open((URL)url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Group findGroup(Widget widget) {
        if (widget == null) {
            return null;
        }
        if (widget instanceof Composite) {
            Composite composite = (Composite)widget;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Group && "layout".equals(((Group)child).getText())) {
                    return (Group)child;
                }
                ++n2;
            }
            return this.findGroup((Widget)composite.getParent());
        }
        if (widget instanceof Control) {
            return this.findGroup((Widget)((Control)widget).getParent());
        }
        return null;
    }

    protected void updateStackAbove(Event event) {
        Button widget = (Button)event.widget;
        layoutGrp = this.findGroup((Widget)widget);
        if (layoutGrp != null) {
            if (controls.isEmpty()) {
                controls.addAll(Arrays.asList(layoutGrp.getChildren()));
            }
            StackLayout layout = (StackLayout)layoutGrp.getLayout();
            if (current == null) {
                current = controls.get(controls.size() - 1);
            } else {
                int index = controls.indexOf(current);
                if (index > 0) {
                    current = controls.get(index - 1);
                }
            }
            layout.topControl = current;
            Label label = this.findLabel(widget);
            if (label != null) {
                label.setText(((Button)current).getText());
            }
            this.layout((Composite)layoutGrp);
        }
    }

    private Label findLabel(Button widget) {
        Control[] children;
        Control[] controlArray = children = widget.getParent().getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Label) {
                return (Label)control;
            }
            ++n2;
        }
        return null;
    }

    protected void updateStackBelow(Event event) {
        Button widget = (Button)event.widget;
        layoutGrp = this.findGroup((Widget)widget);
        if (layoutGrp != null) {
            if (controls.isEmpty()) {
                controls.addAll(Arrays.asList(layoutGrp.getChildren()));
            }
            StackLayout layout = (StackLayout)layoutGrp.getLayout();
            if (current == null) {
                current = controls.get(0);
            } else {
                int index = controls.indexOf(current);
                if (index < controls.size() - 1) {
                    current = controls.get(index + 1);
                }
            }
            layout.topControl = current;
            Label label = this.findLabel(widget);
            if (label != null) {
                label.setText(((Button)current).getText());
            }
            this.layout((Composite)layoutGrp);
        }
    }

    private void layout(Composite composite) {
        if (composite != null) {
            composite.layout(true, true);
            this.layout(composite.getParent());
        }
    }

    protected void updateMarginWidth(Event event) {
        Spinner widget = (Spinner)event.widget;
        Group layGroup = this.findGroup((Widget)widget);
        if (layGroup != null) {
            StackLayout layout = (StackLayout)layGroup.getLayout();
            layout.marginWidth = widget.getSelection();
            this.layout((Composite)layGroup);
        }
    }

    protected void updateMarginHeight(Event event) {
        Spinner widget = (Spinner)event.widget;
        Group layGroup = this.findGroup((Widget)widget);
        if (layGroup != null) {
            StackLayout layout = (StackLayout)layGroup.getLayout();
            layout.marginHeight = widget.getSelection();
            this.layout((Composite)layGroup);
        }
    }
}

