/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.tests.Activator;
import org.eclipse.e4.ui.tests.workbench.PartBackend;
import org.eclipse.e4.ui.tests.workbench.TextField;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;

public class PartFocusTest
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;
    protected EPartService eps;
    protected MWindow window;
    protected MPart part;
    protected MToolControl toolControl;
    protected MPart otherPart;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
        this.window = BasicFactoryImpl.eINSTANCE.createWindow();
        this.window.setWidth(500);
        this.window.setHeight(500);
        MPartSashContainer sash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        this.window.getChildren().add(sash);
        this.window.setSelectedElement((MUIElement)sash);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        sash.getChildren().add(stack);
        sash.setSelectedElement((MUIElement)stack);
        this.part = BasicFactoryImpl.eINSTANCE.createPart();
        this.part.setElementId("Part");
        this.part.setLabel("Part");
        this.part.setToolbar(MenuFactoryImpl.eINSTANCE.createToolBar());
        this.part.setContributionURI(Activator.asURI(PartBackend.class));
        stack.getChildren().add(this.part);
        this.toolControl = MenuFactoryImpl.eINSTANCE.createToolControl();
        this.toolControl.setElementId("ToolControl");
        this.toolControl.setContributionURI(Activator.asURI(TextField.class));
        this.part.getToolbar().getChildren().add(this.toolControl);
        stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        sash.getChildren().add(stack);
        sash.setSelectedElement((MUIElement)stack);
        this.otherPart = BasicFactoryImpl.eINSTANCE.createPart();
        this.otherPart.setElementId("OtherPart");
        this.otherPart.setLabel("OtherPart");
        this.otherPart.setContributionURI(Activator.asURI(PartBackend.class));
        stack.getChildren().add(this.otherPart);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(this.window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)this.window);
        this.eps = (EPartService)this.window.getContext().get(EPartService.class);
        this.eps.activate(this.part);
        this.eps.activate(this.otherPart);
        this.processEvents();
        PartFocusTest.assertNotNull((Object)this.part.getObject());
        PartFocusTest.assertNotNull((Object)this.toolControl.getObject());
        PartFocusTest.assertNotNull((Object)this.otherPart.getObject());
        PartFocusTest.assertNotNull((Object)this.part.getWidget());
        PartFocusTest.assertNotNull((Object)this.toolControl.getWidget());
        PartFocusTest.assertNotNull((Object)this.otherPart.getWidget());
        this.eps.activate(this.otherPart);
        this.processEvents();
        PartFocusTest.assertTrue((boolean)((PartBackend)this.otherPart.getObject()).text1.isFocusControl());
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    /*
     * Exception decompiling
     */
    private void processEvents() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testFocusChangesOnExplicitPartActivation() {
        PartFocusTest.assertFalse((boolean)((PartBackend)this.part.getObject()).text1.isFocusControl());
        this.eps.activate(this.part);
        this.processEvents();
        PartFocusTest.assertTrue((boolean)((PartBackend)this.part.getObject()).text1.isFocusControl());
    }

    public void testNoFocusChangeOnExplicitWidgetSelection() {
        PartFocusTest.assertFalse((boolean)((PartBackend)this.part.getObject()).text1.isFocusControl());
        ((TextField)this.toolControl.getObject()).text.setFocus();
        this.processEvents();
        PartFocusTest.assertEquals((String)this.part.getElementId(), (String)this.eps.getActivePart().getElementId());
        PartFocusTest.assertFalse((boolean)((PartBackend)this.part.getObject()).text1.isFocusControl());
        PartFocusTest.assertTrue((boolean)((TextField)this.toolControl.getObject()).text.isFocusControl());
    }

    public void testNoActivationOnExplicitInPartWidgetSelection() {
        PartFocusTest.assertTrue((this.eps.getActivePart() == this.otherPart ? 1 : 0) != 0);
        PartFocusTest.assertTrue((boolean)((PartBackend)this.otherPart.getObject()).text1.isFocusControl());
        final boolean[] changed = new boolean[1];
        this.eps.addPartListener(new IPartListener(){

            public void partVisible(MPart part) {
                changed[0] = true;
            }

            public void partHidden(MPart part) {
                changed[0] = true;
            }

            public void partDeactivated(MPart part) {
                changed[0] = true;
            }

            public void partBroughtToTop(MPart part) {
                changed[0] = true;
            }

            public void partActivated(MPart part) {
                changed[0] = true;
            }
        });
        ((PartBackend)this.otherPart.getObject()).text2.setFocus();
        this.processEvents();
        PartFocusTest.assertTrue((boolean)((PartBackend)this.otherPart.getObject()).text2.isFocusControl());
        PartFocusTest.assertFalse((boolean)changed[0]);
    }
}

