/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerTrimContributionTest
extends ModelReconcilerTest {
    private void testTrimContribution_PositionInParent(String before, String after) {
        MApplication application = this.createApplication();
        MTrimContribution contribution = MenuFactoryImpl.eINSTANCE.createTrimContribution();
        application.getTrimContributions().add(contribution);
        contribution.setPositionInParent(before);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        contribution.setPositionInParent(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        contribution = (MTrimContribution)application.getTrimContributions().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerTrimContributionTest.assertEquals((int)1, (int)application.getTrimContributions().size());
        ModelReconcilerTrimContributionTest.assertEquals((Object)contribution, application.getTrimContributions().get(0));
        ModelReconcilerTrimContributionTest.assertEquals((String)before, (String)contribution.getPositionInParent());
        this.applyAll(deltas);
        ModelReconcilerTrimContributionTest.assertEquals((int)1, (int)application.getTrimContributions().size());
        ModelReconcilerTrimContributionTest.assertEquals((Object)contribution, application.getTrimContributions().get(0));
        ModelReconcilerTrimContributionTest.assertEquals((String)after, (String)contribution.getPositionInParent());
    }

    public void testTrimContribution_PositionInParent_NullNull() {
        this.testTrimContribution_PositionInParent(null, null);
    }

    public void testTrimContribution_PositionInParent_NullEmpty() {
        this.testTrimContribution_PositionInParent(null, "");
    }

    public void testTrimContribution_PositionInParent_NullString() {
        this.testTrimContribution_PositionInParent(null, "id");
    }

    public void testTrimContribution_PositionInParent_EmptyNull() {
        this.testTrimContribution_PositionInParent("", null);
    }

    public void testTrimContribution_PositionInParent_EmptyEmpty() {
        this.testTrimContribution_PositionInParent("", "");
    }

    public void testTrimContribution_PositionInParent_EmptyString() {
        this.testTrimContribution_PositionInParent("", "id");
    }

    public void testTrimContribution_PositionInParent_StringNull() {
        this.testTrimContribution_PositionInParent("id", null);
    }

    public void testTrimContribution_PositionInParent_StringEmpty() {
        this.testTrimContribution_PositionInParent("id", "");
    }

    public void testTrimContribution_PositionInParent_StringStringUnchanged() {
        this.testTrimContribution_PositionInParent("id", "id");
    }

    public void testTrimContribution_PositionInParent_StringStringChanged() {
        this.testTrimContribution_PositionInParent("id", "id2");
    }

    private void testTrimContribution_ParentId(String before, String after) {
        MApplication application = this.createApplication();
        MTrimContribution contribution = MenuFactoryImpl.eINSTANCE.createTrimContribution();
        application.getTrimContributions().add(contribution);
        contribution.setParentId(before);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        contribution.setParentId(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        contribution = (MTrimContribution)application.getTrimContributions().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerTrimContributionTest.assertEquals((int)1, (int)application.getTrimContributions().size());
        ModelReconcilerTrimContributionTest.assertEquals((Object)contribution, application.getTrimContributions().get(0));
        ModelReconcilerTrimContributionTest.assertEquals((String)before, (String)contribution.getParentId());
        this.applyAll(deltas);
        ModelReconcilerTrimContributionTest.assertEquals((int)1, (int)application.getTrimContributions().size());
        ModelReconcilerTrimContributionTest.assertEquals((Object)contribution, application.getTrimContributions().get(0));
        ModelReconcilerTrimContributionTest.assertEquals((String)after, (String)contribution.getParentId());
    }

    public void testTrimContribution_ParentId_NullNull() {
        this.testTrimContribution_ParentId(null, null);
    }

    public void testTrimContribution_ParentId_NullEmpty() {
        this.testTrimContribution_ParentId(null, "");
    }

    public void testTrimContribution_ParentId_NullString() {
        this.testTrimContribution_ParentId(null, "id");
    }

    public void testTrimContribution_ParentId_EmptyNull() {
        this.testTrimContribution_ParentId("", null);
    }

    public void testTrimContribution_ParentId_EmptyEmpty() {
        this.testTrimContribution_ParentId("", "");
    }

    public void testTrimContribution_ParentId_EmptyString() {
        this.testTrimContribution_ParentId("", "id");
    }

    public void testTrimContribution_ParentId_StringNull() {
        this.testTrimContribution_ParentId("id", null);
    }

    public void testTrimContribution_ParentId_StringEmpty() {
        this.testTrimContribution_ParentId("id", "");
    }

    public void testTrimContribution_ParentId_StringStringUnchanged() {
        this.testTrimContribution_ParentId("id", "id");
    }

    public void testTrimContribution_ParentId_StringStringChanged() {
        this.testTrimContribution_ParentId("id", "id2");
    }
}

