/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.e4photo;

import java.io.BufferedInputStream;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class Preview {
    private static int topImageMargin = 16;
    private static int bottomImageMargin = 16;
    private static int frameWidth = 6;
    private final Composite parent;
    private Image currentImage;
    private IObservableValue parentSize;
    private IObservableValue inputFile;
    private IObservableValue rawImageData;
    private IObservableValue scaledImageData;
    private final Realm bgRealm;
    private Color borderColor;

    @Inject
    public Preview(Composite parentComposite, Realm backgroundRealm) {
        this.parent = new Composite(parentComposite, 0);
        this.parent.setData("org.eclipse.e4.ui.css.id", (Object)"preview");
        this.bgRealm = backgroundRealm;
        this.inputFile = new WritableValue(this.bgRealm);
        this.rawImageData = new ComputedValue(this.bgRealm){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected Object calculate() {
                IFile file = (IFile)Preview.this.inputFile.getValue();
                if (file == null) {
                    return null;
                }
                try {
                    BufferedInputStream contents = new BufferedInputStream(file.getContents());
                    try {
                        ImageData imageData = new ImageData((InputStream)contents);
                        return imageData;
                    }
                    catch (SWTException sWTException) {
                        return null;
                    }
                    finally {
                        ((InputStream)contents).close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        this.parentSize = new WritableValue(this.bgRealm);
        this.scaledImageData = new ComputedValue(this.bgRealm){

            protected Object calculate() {
                ImageData rawData = (ImageData)Preview.this.rawImageData.getValue();
                Point maxSize = (Point)Preview.this.parentSize.getValue();
                if (rawData == null || maxSize == null) {
                    return null;
                }
                Point targetSize = Preview.this.getBestSize(rawData.width, rawData.height, maxSize.x, maxSize.y);
                return rawData.scaledTo(targetSize.x, targetSize.y);
            }
        };
        this.scaledImageData.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                final ImageData imageData = (ImageData)Preview.this.scaledImageData.getValue();
                Preview.this.parent.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (imageData == null) {
                            return;
                        }
                        if (Preview.this.currentImage != null) {
                            Preview.this.currentImage.dispose();
                            Preview.this.currentImage = null;
                        }
                        Preview.this.currentImage = new Image((Device)Preview.this.parent.getDisplay(), imageData);
                        Preview.this.parent.redraw();
                    }
                });
            }
        });
        this.parent.setLayout((Layout)new FillLayout());
        this.parent.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (e.gc.isDisposed()) {
                    return;
                }
                e.gc.fillRectangle(new Rectangle(e.x, e.y, e.width, e.height));
                Image i = Preview.this.currentImage;
                if (i != null && !i.isDisposed()) {
                    Rectangle imageBounds = Preview.this.currentImage.getBounds();
                    int x = (((Preview)Preview.this).parent.getBounds().width - imageBounds.width) / 2;
                    int y = bottomImageMargin;
                    if (Preview.this.borderColor == null) {
                        Preview.this.borderColor = new Color(e.gc.getDevice(), 229, 229, 229);
                    }
                    Color lastBackground = e.gc.getBackground();
                    e.gc.setBackground(Preview.this.borderColor);
                    e.gc.fillRoundRectangle(x, y, imageBounds.width + frameWidth * 2, imageBounds.height + frameWidth * 2, frameWidth, frameWidth);
                    e.gc.setBackground(lastBackground);
                    e.gc.drawImage(i, x + frameWidth, y + frameWidth);
                }
            }
        });
        this.parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                final Point newSize = Preview.this.parent.getSize();
                Preview.this.bgRealm.asyncExec(new Runnable(){

                    public void run() {
                        Preview.this.parentSize.setValue((Object)newSize);
                    }
                });
            }
        });
    }

    @Inject
    @Optional
    public void setSelection(final @Named(value="selection") IFile input) {
        this.bgRealm.asyncExec(new Runnable(){

            public void run() {
                Preview.this.inputFile.setValue((Object)input);
            }
        });
    }

    @Focus
    void setFocus() {
        this.parent.setFocus();
    }

    private Point getBestSize(int originalX, int originalY, int maxX, int maxY) {
        double widthRatio = (double)originalX / (double)maxX;
        double heightRatio = (double)originalY / (double)maxY;
        double bestRatio = widthRatio > heightRatio ? widthRatio : heightRatio;
        int newWidth = (int)((double)originalX / bestRatio) - frameWidth * 2;
        int newHeight = (int)((double)originalY / bestRatio) - (topImageMargin + bottomImageMargin + frameWidth * 2);
        return new Point(newWidth, newHeight);
    }
}

