/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.util;

import edu.umd.cs.piccolox.nodes.PLine;
import edu.umd.cs.piccolox.util.PAbstractLineLocator;
import edu.umd.cs.piccolox.util.Points;
import org.eclipse.e4.tm.graphics.util.Point;

public class PLineLocator
extends PAbstractLineLocator {
    protected PLine line;
    private int start;
    private int end;
    private static Point tempPoint = new Point();

    public PLineLocator(PLine line, int start, int end, double alongAlignment) {
        super(alongAlignment);
        this.line = line;
        this.start = start;
        this.end = end;
    }

    public PLineLocator(PLine line, int segment, double alongAlignment) {
        super(alongAlignment);
        this.line = line;
        this.start = segment < 0 ? segment - 1 : segment;
        this.end = this.start + 1;
    }

    public PLine getLine() {
        return this.line;
    }

    public void setLine(PLine line) {
        this.line = line;
    }

    private Point getSegmentPoint(int num) {
        Points points = this.line.getLineReference();
        if (num < 0) {
            num = points.getPointCount() + num;
        }
        if (num >= 0 && num < points.getPointCount()) {
            points.getPoint(num, tempPoint);
        } else {
            tempPoint.setLocation(0.0, 0.0);
        }
        return tempPoint;
    }

    public double getLineStartX() {
        return this.getSegmentPoint(this.start).getX();
    }

    public double getLineStartY() {
        return this.getSegmentPoint(this.start).getY();
    }

    public double getLineEndX() {
        return this.getSegmentPoint(this.end).getX();
    }

    public double getLineEndY() {
        return this.getSegmentPoint(this.end).getY();
    }

    public static PLineLocator createStartLocator(PLine line, int start, int end) {
        return new PLineLocator(line, start, end, 0.0);
    }

    public static PLineLocator createStartLocator(PLine line, int segment) {
        return new PLineLocator(line, segment, 0.0);
    }

    public static PLineLocator createMiddleLocator(PLine line, int start, int end) {
        return new PLineLocator(line, start, end, 0.5);
    }

    public static PLineLocator createMiddleLocator(PLine line, int segment) {
        return new PLineLocator(line, segment, 0.5);
    }

    public static PLineLocator createEndLocator(PLine line, int start, int end) {
        return new PLineLocator(line, start, end, 1.0);
    }

    public static PLineLocator createEndLocator(PLine line, int segment) {
        return new PLineLocator(line, segment, 1.0);
    }
}

