/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.e4.tm.graphics.util.Dimension;
import org.eclipse.e4.tm.graphics.util.Point;
import org.eclipse.e4.tm.graphics.util.Rectangle;

public class PBounds
extends Rectangle
implements Serializable {
    private boolean isEmpty = true;

    public PBounds() {
    }

    public PBounds(PBounds aBounds) {
        this(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
        this.isEmpty = aBounds.isEmpty();
    }

    public PBounds(Rectangle aBounds) {
        this(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
        this.isEmpty = aBounds.isEmpty();
    }

    public PBounds(Point aCenterPoint, double insetX, double insetY) {
        this(aCenterPoint.getX(), aCenterPoint.getY(), 0.0, 0.0);
        this.inset(insetX, insetY);
    }

    public PBounds(double x, double y, double width, double height) {
        super(x, y, width, height);
        this.isEmpty = false;
    }

    public Object clone() {
        return new PBounds(this);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public PBounds reset() {
        this.isEmpty = true;
        return this;
    }

    public PBounds resetToZero() {
        this.x = 0.0;
        this.y = 0.0;
        this.width = 0.0;
        this.height = 0.0;
        this.isEmpty = true;
        return this;
    }

    public void setRect(Rectangle r) {
        super.setRect(r);
        this.isEmpty = false;
    }

    public void setRect(PBounds b) {
        this.isEmpty = b.isEmpty;
        this.x = b.x;
        this.y = b.y;
        this.width = b.width;
        this.height = b.height;
    }

    public void setRect(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.isEmpty = false;
    }

    public void add(double newx, double newy) {
        if (this.isEmpty) {
            this.setRect(newx, newy, 0.0, 0.0);
            this.isEmpty = false;
        } else {
            super.add(newx, newy);
        }
    }

    public void add(Rectangle r) {
        if (this.isEmpty) {
            this.setRect(r);
        } else {
            super.add(r);
        }
    }

    public void add(PBounds r) {
        if (r.isEmpty) {
            return;
        }
        if (this.isEmpty) {
            this.x = r.x;
            this.y = r.y;
            this.width = r.width;
            this.height = r.height;
            this.isEmpty = false;
        } else {
            double x1 = this.x <= r.x ? this.x : r.x;
            double y1 = this.y <= r.y ? this.y : r.y;
            double x2 = this.x + this.width >= r.x + r.width ? this.x + this.width : r.x + r.width;
            double y2 = this.y + this.height >= r.y + r.height ? this.y + this.height : r.y + r.height;
            this.x = x1;
            this.y = y1;
            this.width = x2 - x1;
            this.height = y2 - y1;
            this.isEmpty = false;
        }
    }

    public Point getOrigin() {
        return new Point(this.x, this.y);
    }

    public PBounds setOrigin(double x, double y) {
        this.x = x;
        this.y = y;
        this.isEmpty = false;
        return this;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(double width, double height) {
        this.setRect(this.x, this.y, width, height);
    }

    public Point getCenter2D() {
        return new Point(this.getCenterX(), this.getCenterY());
    }

    public PBounds moveBy(double dx, double dy) {
        this.setOrigin(this.x + dx, this.y + dy);
        return this;
    }

    public void expandNearestIntegerDimensions() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        this.width = Math.ceil(this.width);
        this.height = Math.ceil(this.height);
    }

    public PBounds inset(double dx, double dy) {
        this.setRect(this.x + dx, this.y + dy, this.width - dx * 2.0, this.height - dy * 2.0);
        return this;
    }

    public Dimension deltaRequiredToCenter(Rectangle b) {
        Dimension result = new Dimension();
        double xDelta = this.getCenterX() - b.getCenterX();
        double yDelta = this.getCenterY() - b.getCenterY();
        result.setSize(xDelta, yDelta);
        return result;
    }

    public Dimension deltaRequiredToContain(Rectangle b) {
        Dimension result = new Dimension();
        if (!this.contains(b)) {
            double bMaxX = b.getMaxX();
            double bMinX = b.getMinX();
            double bMaxY = b.getMaxY();
            double bMinY = b.getMinY();
            double maxX = this.getMaxX();
            double minX = this.getMinX();
            double maxY = this.getMaxY();
            double minY = this.getMinY();
            if (!(bMaxX > maxX && bMinX < minX || !(bMaxX > maxX) && !(bMinX < minX))) {
                double difMaxX = bMaxX - maxX;
                double difMinX = bMinX - minX;
                result.width = Math.abs(difMaxX) < Math.abs(difMinX) ? difMaxX : difMinX;
            }
            if (!(bMaxY > maxY && bMinY < minY || !(bMaxY > maxY) && !(bMinY < minY))) {
                double difMaxY = bMaxY - maxY;
                double difMinY = bMinY - minY;
                result.height = Math.abs(difMaxY) < Math.abs(difMinY) ? difMaxY : difMinY;
            }
        }
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.width);
        out.writeDouble(this.height);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.width = in.readDouble();
        this.height = in.readDouble();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getName().replaceAll(".*\\.", ""));
        result.append('[');
        if (this.isEmpty) {
            result.append("EMPTY");
        } else {
            result.append("x=");
            result.append(this.x);
            result.append(",y=");
            result.append(this.y);
            result.append(",width=");
            result.append(this.width);
            result.append(",height=");
            result.append(this.height);
        }
        result.append(']');
        return result.toString();
    }
}

