/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.xwt.ui.ExceptionHandle;
import org.eclipse.e4.xwt.ui.XWTUIPlugin;
import org.eclipse.e4.xwt.ui.utils.ProjectUtil;
import org.eclipse.e4.xwt.ui.wizards.NewUIFileWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewUIFileWizard
extends Wizard
implements INewWizard {
    private NewUIFileWizardPage fileWizardPage;
    private IStructuredSelection selection;

    public NewUIFileWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New Widget File Wizard.");
    }

    public void addPages() {
        this.fileWizardPage = new NewUIFileWizardPage((ISelection)this.selection);
        this.addPage((IWizardPage)this.fileWizardPage);
    }

    public boolean performFinish() {
        final String containerName = this.fileWizardPage.getContainerName();
        final String fileName = this.fileWizardPage.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        IFile file = NewUIFileWizard.this.doFinish(containerName, fileName, monitor);
                        NewUIFileWizard.this.tryToOpenPerspective();
                        ProjectUtil.updateXWTCoreDependencies(file.getProject());
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    protected void tryToOpenPerspective() {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                XWTUIPlugin.getDefault().openXWTPerspective();
            }
        });
    }

    private IFile doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream(file);
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
        return file;
    }

    private InputStream openContentStream(IFile file) {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(arrayOutputStream);
        printStream.println("<Composite");
        printStream.println("\t xmlns=\"http://www.eclipse.org/xwt/presentation\"");
        printStream.println("\t xmlns:x=\"http://www.eclipse.org/xwt\">");
        printStream.println("</Composite>");
        try {
            byte[] content = arrayOutputStream.toByteArray();
            printStream.close();
            arrayOutputStream.close();
            return new ByteArrayInputStream(content);
        }
        catch (Exception e) {
            XWTUIPlugin.log(e);
            ExceptionHandle.handle(e, "save failed in the file: " + this.fileWizardPage.getFileName());
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.e4.xwt.tools.ui", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

