/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.wizards;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.xwt.javabean.metadata.Metaclass;
import org.eclipse.e4.xwt.ui.ExceptionHandle;
import org.eclipse.e4.xwt.ui.XWTUIPlugin;
import org.eclipse.e4.xwt.ui.jdt.ASTHelper;
import org.eclipse.e4.xwt.ui.jdt.ProjectHelper;
import org.eclipse.e4.xwt.ui.utils.ProjectContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewPresentationWizardPage
extends NewClassWizardPage {
    protected String superClass;
    protected IResource guiResource;
    private boolean shouldGenMetaclass = false;
    private StringButtonDialogField fieldEditor;
    private Button metaclassButton;
    private IPackageFragment packageFragment;
    private String dataContext;

    public NewPresentationWizardPage() {
        this.setTitle("New Wizard Creation");
        this.setDescription("This wizard creates a data presentation.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        new Label(composite, 0);
        this.metaclassButton = new Button(composite, 32);
        this.metaclassButton.setSelection(this.shouldGenMetaclass);
        this.metaclassButton.setText("Generating Metaclass");
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.metaclassButton.setLayoutData((Object)data);
        this.metaclassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewPresentationWizardPage.this.shouldGenMetaclass = NewPresentationWizardPage.this.metaclassButton.getSelection();
            }
        });
        this.createDataContextComp(composite);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.createSeparator(composite, nColumns);
        this.setControl((Control)composite);
        NewElementWizard wizard = (NewElementWizard)this.getWizard();
        IStructuredSelection selection = wizard.getSelection();
        IType dataContextType = null;
        for (Object element : selection) {
            if (element instanceof ICompilationUnit) {
                ICompilationUnit unit = (ICompilationUnit)element;
                dataContextType = unit.findPrimaryType();
                break;
            }
            if (!(element instanceof IType)) continue;
            dataContextType = (IType)element;
            break;
        }
        if (dataContextType != null) {
            this.setTypeName(dataContextType.getElementName(), true);
            this.fieldEditor.setText(dataContextType.getFullyQualifiedName('.'));
            this.metaclassButton.setSelection(this.shouldGenMetaclass);
        }
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_class_wizard_page_context");
    }

    private void createDataContextComp(Composite composite) {
        DataContextFieldAdapter adapter = new DataContextFieldAdapter();
        this.fieldEditor = new StringButtonDialogField((IStringButtonAdapter)adapter);
        this.fieldEditor.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fieldEditor.setButtonLabel("Browse...");
        this.fieldEditor.setLabelText("Data Context Type:");
        this.fieldEditor.doFillIntoGrid(composite, 4);
        LayoutUtil.setWidthHint((Control)this.fieldEditor.getTextControl(null), (int)this.getMaxFieldWidth());
    }

    public boolean isCreateConstructors() {
        return true;
    }

    public void validateDataContext() {
        block7: {
            String newMessage = "Invalid Java Type for initializing DataContext.";
            String errorMessage = this.getErrorMessage();
            if (this.dataContext != null) {
                ProjectContext context = ProjectContext.getContext(this.getJavaProject());
                try {
                    context.getClassLoader().loadClass(this.dataContext);
                    if (newMessage.equals(errorMessage)) {
                        this.setErrorMessage(null);
                        break block7;
                    }
                    this.setErrorMessage(errorMessage);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.setErrorMessage(newMessage);
                }
            } else if (newMessage.equals(errorMessage)) {
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(errorMessage);
            }
        }
    }

    public IType chooseDataContext() {
        IJavaProject project = this.getJavaProject();
        if (project == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{project};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, 5);
        dialog.setTitle("Choose a JavaBean");
        dialog.setMessage("Choose a JavaBean as a DataContext Type.");
        dialog.setInitialPattern("java.lang.Object");
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    protected void initTypePage(IJavaElement elem) {
        super.initTypePage(elem);
        this.setSuperClass(this.getSuperClassName(), false);
    }

    public void setPackageFragment(IPackageFragment pack, boolean canBeModified) {
        String name = String.valueOf(pack.getElementName()) + ".ui";
        IPackageFragmentRoot root = (IPackageFragmentRoot)pack.getParent();
        IPackageFragment packageFragment = root.getPackageFragment(name);
        super.setPackageFragment(packageFragment, canBeModified);
    }

    protected String getSuperClassName() {
        return Composite.class.getName();
    }

    public int getModifiers() {
        return this.F_PUBLIC;
    }

    public List getSuperInterfaces() {
        return Collections.EMPTY_LIST;
    }

    public boolean isCreateMain() {
        return false;
    }

    protected InputStream getContentStream() {
        IType type = this.getCreatedType();
        String hostClassName = type.getFullyQualifiedName();
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(arrayOutputStream);
        printStream.println("<Composite xmlns=\"http://www.eclipse.org/xwt/presentation\"");
        printStream.println("\t xmlns:x=\"http://www.eclipse.org/xwt\"");
        String packageName = type.getPackageFragment().getElementName();
        if (packageName != null) {
            printStream.println("\t xmlns:c=\"clr-namespace:" + packageName + "\"");
        }
        printStream.println("\t xmlns:j=\"clr-namespace:java.lang\"");
        printStream.println("\t x:Class=\"" + hostClassName + "\">");
        printStream.println("\t <Composite.layout>");
        printStream.println("\t\t <GridLayout  numColumns=\"4\" />");
        printStream.println("\t </Composite.layout>");
        this.appendBeanContent(printStream);
        printStream.println("</Composite>");
        try {
            byte[] content = arrayOutputStream.toByteArray();
            printStream.close();
            arrayOutputStream.close();
            return new ByteArrayInputStream(content);
        }
        catch (Exception e) {
            XWTUIPlugin.log(e);
            ExceptionHandle.handle(e, "save failed in the file: " + this.getModifiedResource().getLocation());
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private void appendBeanContent(PrintStream printStream) {
        Class<?> type = this.getDataContextType();
        if (type == null) {
            return;
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                String name = pd.getName();
                if (name != null && !"class".equals(name)) {
                    Class<?> propertyType = pd.getPropertyType();
                    if (propertyType.isPrimitive() || propertyType == String.class || propertyType == URL.class) {
                        printStream.println("\t <Label text=\"" + pd.getDisplayName() + "\"/>");
                        printStream.println("\t <Text x:Style=\"Border\" text=\"{Binding path=" + pd.getName() + "}\">");
                        printStream.println("\t\t <Text.layoutData>");
                        printStream.println("\t\t\t <GridData grabExcessHorizontalSpace=\"true\"");
                        printStream.println("\t\t\t\t horizontalAlignment=\"GridData.FILL\" widthHint=\"100\"/>");
                        printStream.println("\t\t </Text.layoutData>");
                        printStream.println("\t </Text>");
                    } else if (propertyType.isEnum()) {
                        printStream.println("\t <Label text=\"" + pd.getDisplayName() + "\"/>");
                        printStream.println("\t <Combo text=\"{Binding path=" + pd.getName() + "}\">");
                        printStream.println("\t\t <Combo.layoutData>");
                        printStream.println("\t\t\t <GridData grabExcessHorizontalSpace=\"true\"");
                        printStream.println("\t\t\t\t horizontalAlignment=\"GridData.FILL\" widthHint=\"100\"/>");
                        printStream.println("\t\t </Combo.layoutData>");
                        printStream.println("\t\t <Combo.items>");
                        ?[] objArray = propertyType.getEnumConstants();
                        int n3 = objArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object object = objArray[n4];
                            printStream.println("\t\t\t <j:String>" + object.toString() + "</j:String>");
                            ++n4;
                        }
                        printStream.println("\t\t </Combo.items>");
                        printStream.println("\t </Combo>");
                    } else {
                        printStream.println("\t <Group text=\"" + pd.getDisplayName() + "\">");
                        printStream.println("\t\t <Group.layout>");
                        printStream.println("\t\t\t <FillLayout/>");
                        printStream.println("\t\t </Group.layout>");
                        String elementType = propertyType.getSimpleName();
                        printStream.println("\t\t <c:" + elementType + " DataContext=\"{Binding path=" + pd.getName() + "}\"/>");
                        printStream.println("\t\t <Group.layoutData>");
                        printStream.println("\t\t\t <GridData grabExcessHorizontalSpace=\"true\" horizontalSpan=\"4\"");
                        printStream.println("\t\t\t\t horizontalAlignment=\"GridData.FILL\" widthHint=\"200\"/>");
                        printStream.println("\t\t </Group.layoutData>");
                        printStream.println("\t </Group>");
                    }
                }
                ++n2;
            }
        }
        catch (IntrospectionException introspectionException) {}
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        ProjectHelper.checkDependenceJars(this.getJavaProject());
        super.createType(monitor);
        if (this.shouldGenMetaclass) {
            this.createMetaclass();
        }
        IResource resource = this.getModifiedResource();
        IPath resourcePath = resource.getProjectRelativePath().removeFileExtension();
        resourcePath = resourcePath.addFileExtension("xwt");
        try {
            IFile file = resource.getProject().getFile(resourcePath);
            file.create(this.getContentStream(), 3, monitor);
            this.guiResource = file;
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionHandle.handle(e, "save failed in the file: " + this.getModifiedResource().getLocation());
        }
    }

    public void createMetaclass() {
        IType type = this.getCreatedType();
        String typeName = type.getElementName();
        String metaclassName = String.valueOf(typeName) + "Metaclass";
        IType metaclassType = ASTHelper.createType(this.getPackageFragment(), metaclassName, null, Metaclass.class);
        if (metaclassType != null && this.dataContext != null) {
            ASTHelper.createMethod(metaclassType, "getDataContentType", this.getDataContextType().getClass(), this.getDataContextType().getName() + ".class", null);
        }
        ICompilationUnit cu = metaclassType.getCompilationUnit();
        try {
            cu.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException javaModelException) {}
    }

    public String getTypeName() {
        String typeName = super.getTypeName();
        if (typeName == null || typeName.equals("")) {
            return typeName;
        }
        return String.valueOf(Character.toUpperCase(typeName.charAt(0))) + typeName.substring(1);
    }

    public boolean isCreateInherited() {
        return true;
    }

    public boolean shouldGenMetaclass() {
        return this.shouldGenMetaclass;
    }

    public Class<?> getDataContextType() {
        if (this.dataContext == null || this.dataContext.trim().length() == 0) {
            return null;
        }
        ProjectContext context = ProjectContext.getContext(this.getJavaProject());
        try {
            return context.getClassLoader().loadClass(this.dataContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public IResource getGuiResource() {
        return this.guiResource;
    }

    private class DataContextFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private DataContextFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            IType type = NewPresentationWizardPage.this.chooseDataContext();
            if (type != null) {
                ((StringButtonDialogField)field).setText(type.getFullyQualifiedName());
            }
        }

        public void dialogFieldChanged(DialogField field) {
            NewPresentationWizardPage.this.dataContext = ((StringButtonDialogField)field).getText();
            NewPresentationWizardPage.this.validateDataContext();
        }
    }
}

