/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.xwt.ui.utils.ProjectContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class XWTUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.e4.xwt.tools.ui";
    private static XWTUIPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ProjectContext.start();
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        ProjectContext.stop();
        super.stop(context);
    }

    public static XWTUIPlugin getDefault() {
        return plugin;
    }

    public static Shell getShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getShell();
    }

    public static void log(int severity, int code, String message, Throwable exception) {
        XWTUIPlugin.getDefault().getLog().log((IStatus)new Status(severity, XWTUIPlugin.getDefault().getBundle().getSymbolicName(), code, message, exception));
    }

    public static void log(int severity, int code, String message) {
        XWTUIPlugin.getDefault().getLog().log((IStatus)new Status(severity, XWTUIPlugin.getDefault().getBundle().getSymbolicName(), code, message, null));
    }

    public static void log(int severity, String message) {
        XWTUIPlugin.getDefault().getLog().log((IStatus)new Status(severity, XWTUIPlugin.getDefault().getBundle().getSymbolicName(), -1, message, null));
    }

    public static void log(Throwable exception) {
        XWTUIPlugin.getDefault().getLog().log((IStatus)new Status(4, XWTUIPlugin.getDefault().getBundle().getSymbolicName(), -1, "", exception));
    }

    public static ImageDescriptor getBundledImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)XWTUIPlugin.getDefault().getBundle().getSymbolicName(), (String)path);
    }

    public Image getBundledImage(String path) {
        Image image = this.getImageRegistry().get(path);
        if (image == null) {
            this.getImageRegistry().put(path, XWTUIPlugin.getBundledImageDescriptor(path));
            image = this.getImageRegistry().get(path);
        }
        return image;
    }

    public static void checkStartup() {
        Bundle bundle = XWTUIPlugin.getDefault().getBundle();
        if (bundle.getState() != 32) {
            try {
                bundle.start();
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
    }

    public void openXWTPerspective() {
        IPerspectiveDescriptor pers;
        IWorkbench workbench = this.getWorkbench();
        int count = workbench.getWorkbenchWindowCount();
        if (count == 0) {
            return;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            window = workbench.getWorkbenchWindows()[0];
        }
        if ((pers = workbench.getPerspectiveRegistry().findPerspectiveWithId("org.eclipse.e4.xwt.ui.perspective")) == null) {
            return;
        }
        try {
            workbench.showPerspective("org.eclipse.e4.xwt.ui.perspective", window);
        }
        catch (WorkbenchException workbenchException) {
            System.out.println("Can't Open XWT Perspective");
        }
    }
}

