/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.services.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public abstract class AbstractTranslationProvider {
    static final String DEFAULT_ROOT = AbstractTranslationProvider.getEquinoxRootLocale();
    private final Hashtable<String, BundleResourceBundle> cache = new Hashtable(5);

    private static String getEquinoxRootLocale() {
        String root = System.getProperties().getProperty("equinox.root.locale");
        if (root == null) {
            root = "en";
        }
        return root;
    }

    protected abstract InputStream getResourceAsStream(String var1);

    protected abstract String getBasename();

    public String translate(String locale, String key) {
        String defaultLocale = Locale.getDefault().toString();
        String localeString = locale;
        ResourceBundle bundle = this.getResourceBundle(locale.toString(), defaultLocale.equals(localeString));
        try {
            if (bundle == null) {
                return key;
            }
            return bundle.getString(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return key;
        }
    }

    private ResourceBundle getResourceBundle(String localeString, boolean isDefaultLocale) {
        BundleResourceBundle resourceBundle = this.lookupResourceBundle(localeString);
        if (isDefaultLocale) {
            return (ResourceBundle)((Object)resourceBundle);
        }
        if (resourceBundle == null || resourceBundle.isStemEmpty()) {
            return (ResourceBundle)((Object)this.lookupResourceBundle(Locale.getDefault().toString()));
        }
        return (ResourceBundle)((Object)resourceBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleResourceBundle lookupResourceBundle(String localeString) {
        String localizationHeader = this.getBasename();
        Hashtable<String, BundleResourceBundle> hashtable = this.cache;
        synchronized (hashtable) {
            BundleResourceBundle result = this.cache.get(localeString);
            if (result != null) {
                return result.isEmpty() ? null : result;
            }
            String[] nlVarients = this.buildNLVariants(localeString);
            BundleResourceBundle parent = null;
            int i = nlVarients.length - 1;
            while (i >= 0) {
                BundleResourceBundle varientBundle;
                block23: {
                    varientBundle = null;
                    InputStream resourceStream = this.getResourceAsStream(String.valueOf(localizationHeader) + (nlVarients[i].equals("") ? nlVarients[i] : String.valueOf('_') + nlVarients[i]) + ".properties");
                    if (resourceStream == null) {
                        varientBundle = this.cache.get(nlVarients[i]);
                    } else {
                        try {
                            try {
                                varientBundle = new LocalizationResourceBundle(resourceStream);
                            }
                            catch (IOException iOException) {
                                if (resourceStream != null) {
                                    try {
                                        resourceStream.close();
                                    }
                                    catch (IOException iOException2) {}
                                }
                                break block23;
                            }
                        }
                        catch (Throwable throwable) {
                            if (resourceStream != null) {
                                try {
                                    resourceStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (resourceStream != null) {
                            try {
                                resourceStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if (varientBundle == null) {
                    varientBundle = new EmptyResouceBundle(nlVarients[i]);
                }
                if (parent != null) {
                    varientBundle.setParent((ResourceBundle)((Object)parent));
                }
                this.cache.put(nlVarients[i], varientBundle);
                parent = varientBundle;
                --i;
            }
            result = this.cache.get(localeString);
            BundleResourceBundle bundleResourceBundle = result.isEmpty() ? null : result;
            return bundleResourceBundle;
        }
    }

    private String[] buildNLVariants(String nl) {
        ArrayList<String> result = new ArrayList<String>();
        while (nl.length() > 0) {
            result.add(nl);
            int i = nl.lastIndexOf(95);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    protected void clearCache() {
        this.cache.clear();
    }

    private static interface BundleResourceBundle {
        public void setParent(ResourceBundle var1);

        public boolean isEmpty();

        public boolean isStemEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EmptyResouceBundle
    extends ResourceBundle
    implements BundleResourceBundle {
        private final String localeString;

        public EmptyResouceBundle(String locale) {
            this.localeString = locale;
        }

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String arg0) throws MissingResourceException {
            return null;
        }

        @Override
        public void setParent(ResourceBundle parent) {
            super.setParent(parent);
        }

        @Override
        public boolean isEmpty() {
            if (this.parent == null) {
                return true;
            }
            return ((BundleResourceBundle)((Object)this.parent)).isEmpty();
        }

        @Override
        public boolean isStemEmpty() {
            if (DEFAULT_ROOT.equals(this.localeString)) {
                return false;
            }
            if (this.parent == null) {
                return true;
            }
            return ((BundleResourceBundle)((Object)this.parent)).isStemEmpty();
        }
    }

    private class LocalizationResourceBundle
    extends PropertyResourceBundle
    implements BundleResourceBundle {
        public LocalizationResourceBundle(InputStream in) throws IOException {
            super(in);
        }

        public void setParent(ResourceBundle parent) {
            super.setParent(parent);
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isStemEmpty() {
            return this.parent == null;
        }
    }
}

