/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.contacts.processors;

import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public abstract class AbstractThemeProcessor {
    @Execute
    public void process() {
        ServiceReference reference;
        if (!this.check()) {
            return;
        }
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        BundleContext context = bundle.getBundleContext();
        IThemeManager mgr = (IThemeManager)context.getService(reference = context.getServiceReference(IThemeManager.class.getName()));
        IThemeEngine engine = mgr.getEngineForDisplay(Display.getCurrent());
        List themes = engine.getThemes();
        if (themes.size() > 0) {
            MApplication application = this.getApplication();
            MCommand switchThemeCommand = null;
            for (MCommand cmd : application.getCommands()) {
                if (!"contacts.switchTheme".equals(cmd.getElementId())) continue;
                switchThemeCommand = cmd;
                break;
            }
            if (switchThemeCommand != null) {
                this.preprocess();
                for (ITheme theme : themes) {
                    MParameter parameter = MCommandsFactory.INSTANCE.createParameter();
                    parameter.setName("contacts.commands.switchtheme.themeid");
                    parameter.setValue(theme.getId());
                    String iconURI = this.getCSSUri(theme.getId());
                    if (iconURI != null) {
                        iconURI = iconURI.replace(".css", ".png");
                    }
                    this.processTheme(theme.getLabel(), switchThemeCommand, parameter, iconURI);
                }
                this.postprocess();
            }
        }
    }

    protected abstract boolean check();

    protected abstract void preprocess();

    protected abstract void processTheme(String var1, MCommand var2, MParameter var3, String var4);

    protected abstract void postprocess();

    protected abstract MApplication getApplication();

    private String getCSSUri(String themeId) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.ui.css.swt.theme");
        IExtension[] iExtensionArray = extPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension e = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if (ce.getName().equals("theme") && ce.getAttribute("id").equals(themeId)) {
                    return "platform:/plugin/" + ce.getContributor().getName() + "/" + ce.getAttribute("basestylesheeturi");
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

