/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.internal.tests.contexts.AddContextFunction;
import org.eclipse.e4.core.internal.tests.contexts.inject.ObjectSuperClass;

public class ReparentingTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(ReparentingTest.class);
    }

    public ReparentingTest() {
    }

    public ReparentingTest(String name) {
        super(name);
    }

    public void testContextFunctionInParentRemove() {
        IEclipseContext parent = EclipseContextFactory.create((String)"parent");
        IEclipseContext child = parent.createChild("child");
        parent.set("sum", (Object)new AddContextFunction());
        parent.set("x", (Object)new Integer(3));
        parent.set("y", (Object)new Integer(3));
        child.set("x", (Object)new Integer(1));
        child.set("y", (Object)new Integer(1));
        ReparentingTest.assertEquals((int)6, (int)((Integer)parent.get("sum")));
        ReparentingTest.assertEquals((int)2, (int)((Integer)child.get("sum")));
        child.setParent(EclipseContextFactory.create());
        ReparentingTest.assertEquals((int)6, (int)((Integer)parent.get("sum")));
        ReparentingTest.assertNull((String)("Expected null but was: " + child.get("sum")), (Object)child.get("sum"));
    }

    public void testContextFunctionInParentAdd() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = parent.createChild();
        child.set("x", (Object)new Integer(1));
        child.set("y", (Object)new Integer(1));
        ReparentingTest.assertEquals(null, (Object)parent.get("sum"));
        ReparentingTest.assertEquals(null, (Object)child.get("sum"));
        IEclipseContext newParent = EclipseContextFactory.create();
        child.setParent(newParent);
        newParent.set("sum", (Object)new AddContextFunction());
        ReparentingTest.assertEquals((int)0, (int)((Integer)newParent.get("sum")));
        ReparentingTest.assertEquals((int)2, (int)((Integer)child.get("sum")));
        newParent.set("x", (Object)new Integer(3));
        newParent.set("y", (Object)new Integer(3));
        ReparentingTest.assertEquals((int)6, (int)((Integer)newParent.get("sum")));
        ReparentingTest.assertEquals((int)2, (int)((Integer)child.get("sum")));
    }

    public void testContextFunctionNullBecomeParent() {
        IEclipseContext child = EclipseContextFactory.create();
        child.set("sum", (Object)new AddContextFunction());
        ReparentingTest.assertEquals((int)0, (int)((Integer)child.get("sum")));
        IEclipseContext parent = EclipseContextFactory.create();
        parent.set("x", (Object)new Integer(3));
        parent.set("y", (Object)new Integer(3));
        child.setParent(parent);
        ReparentingTest.assertEquals((int)6, (int)((Integer)child.get("sum")));
    }

    public void testContextFunctionParentBecomeNull() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = parent.createChild();
        parent.set("x", (Object)new Integer(3));
        parent.set("y", (Object)new Integer(3));
        child.set("sum", (Object)new AddContextFunction());
        ReparentingTest.assertEquals((int)6, (int)((Integer)child.get("sum")));
        child.setParent(null);
        ReparentingTest.assertEquals((int)0, (int)((Integer)child.get("sum")));
    }

    public void testContextFunctionSwitchParent() {
        IEclipseContext parent = EclipseContextFactory.create();
        IEclipseContext child = parent.createChild();
        parent.set("x", (Object)new Integer(3));
        parent.set("y", (Object)new Integer(3));
        child.set("sum", (Object)new AddContextFunction());
        ReparentingTest.assertEquals((int)6, (int)((Integer)child.get("sum")));
        IEclipseContext newParent = EclipseContextFactory.create();
        newParent.set("x", (Object)new Integer(1));
        newParent.set("y", (Object)new Integer(1));
        child.setParent(newParent);
        ReparentingTest.assertEquals((int)2, (int)((Integer)child.get("sum")));
    }

    public void testRunAndTrackNullBecomesParent() {
        final String[] value = new String[1];
        final IEclipseContext child = EclipseContextFactory.create();
        child.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                value[0] = (String)child.get("x");
                return true;
            }
        });
        ReparentingTest.assertEquals(null, (String)value[0]);
        IEclipseContext parent = EclipseContextFactory.create();
        parent.set("x", (Object)"newParent");
        child.setParent(parent);
        ReparentingTest.assertEquals((String)"newParent", (String)value[0]);
    }

    public void testRunAndTrackParentBecomeNull() {
        final String[] value = new String[1];
        IEclipseContext parent = EclipseContextFactory.create();
        final IEclipseContext child = parent.createChild();
        parent.set("x", (Object)"oldParent");
        child.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                value[0] = (String)child.get("x");
                return true;
            }
        });
        ReparentingTest.assertEquals((String)"oldParent", (String)value[0]);
        child.setParent(null);
        ReparentingTest.assertNull((Object)value[0]);
    }

    public void testRunAndTrackSwitchParent() {
        final String[] value = new String[1];
        IEclipseContext parent = EclipseContextFactory.create();
        final IEclipseContext child = parent.createChild();
        parent.set("x", (Object)"oldParent");
        child.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                value[0] = (String)child.get("x");
                return true;
            }
        });
        ReparentingTest.assertEquals((String)"oldParent", (String)value[0]);
        IEclipseContext newParent = EclipseContextFactory.create();
        newParent.set("x", (Object)"newParent");
        child.setParent(newParent);
        ReparentingTest.assertEquals((String)"newParent", (String)value[0]);
    }

    public void testInjectSwitchParent() {
        IEclipseContext oldParent = EclipseContextFactory.create();
        oldParent.set("String", (Object)"oldField");
        oldParent.set(String.class.getName(), (Object)"old");
        oldParent.set(Float.class.getName(), (Object)new Float(12.3));
        IEclipseContext newParent = EclipseContextFactory.create();
        newParent.set("String", (Object)"newField");
        newParent.set(String.class.getName(), (Object)"new");
        newParent.set(Float.class.getName(), (Object)new Float(34.5));
        IEclipseContext child = oldParent.createChild();
        ObjectSuperClass object = new ObjectSuperClass();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)child);
        ReparentingTest.assertEquals((int)1, (int)object.setStringCalled);
        ReparentingTest.assertEquals((String)"old", (String)object.getStringViaMethod());
        child.setParent(newParent);
        ReparentingTest.assertEquals((String)"new", (String)object.getStringViaMethod());
        ReparentingTest.assertEquals((int)2, (int)object.setStringCalled);
    }

    public void testInjectSwitchParentSameGrandparent() {
        IEclipseContext grandpa = EclipseContextFactory.create();
        grandpa.set("String", (Object)"field");
        grandpa.set(String.class.getName(), (Object)"s");
        grandpa.set(Float.class.getName(), (Object)new Float(12.3));
        IEclipseContext oldParent = grandpa.createChild();
        IEclipseContext newParent = grandpa.createChild();
        IEclipseContext child = oldParent.createChild();
        ObjectSuperClass object = new ObjectSuperClass();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)child);
        ReparentingTest.assertEquals((int)1, (int)object.setStringCalled);
        child.setParent(newParent);
        ReparentingTest.assertEquals((int)1, (int)object.setStringCalled);
    }
}

