/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.utils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.Session;
import org.eclipse.dirigible.repository.ext.utils.EnvUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class RequestUtils {
    private static final Logger logger = Logger.getLogger(RequestUtils.class);

    public static String getUser(HttpServletRequest request) {
        String user = "guest";
        try {
            if (request != null) {
                String fromCookie;
                if (request.getUserPrincipal() != null) {
                    user = request.getUserPrincipal().getName();
                } else if (!RequestUtils.isRolesEnabled().booleanValue() && (fromCookie = RequestUtils.getCookieValue(request, "dirigible_anonymous_user")) != null) {
                    user = fromCookie;
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return user;
    }

    public static String getUser(Session session) {
        String user = "guest";
        try {
            if (session != null) {
                String fromProps;
                if (session.getUserPrincipal() != null) {
                    user = session.getUserPrincipal().getName();
                } else if (!RequestUtils.isRolesEnabled().booleanValue() && (fromProps = (String)session.getUserProperties().get("user")) != null) {
                    user = fromProps;
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return user;
    }

    public static String getCookieValue(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookieName.equals(cookie.getName())) {
                    return cookie.getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    public static String get(String name) {
        String parameter = EnvUtils.getEnv(name);
        return parameter;
    }

    public static Boolean isRolesEnabled() {
        Boolean rolesEnabled = Boolean.parseBoolean(RequestUtils.get("enableRoles"));
        return rolesEnabled;
    }
}

