/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.extensions;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.ICommonConstants;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.ext.db.AbstractDataUpdater;
import org.eclipse.dirigible.repository.ext.extensions.EExtensionException;
import org.eclipse.dirigible.repository.ext.extensions.ExtensionDefinition;
import org.eclipse.dirigible.repository.ext.extensions.ExtensionManager;
import org.eclipse.dirigible.repository.ext.extensions.ExtensionPointDefinition;
import org.eclipse.dirigible.repository.logging.Logger;

public class ExtensionUpdater
extends AbstractDataUpdater {
    private static final String NODE_DESCRIPTION = "description";
    private static final String NODE_EXTENSION_POINT = "extension-point";
    private static final String NODE_EXTENSION = "extension";
    public static final String EXTENSION_EXTENSION = ".extension";
    public static final String EXTENSION_EXTENSION_POINT = ".extensionpoint";
    public static final String REGISTRY_EXTENSION_DEFINITIONS_DEFAULT = "/db/dirigible/registry/public/ExtensionDefinitions";
    private static final Logger logger = Logger.getLogger(ExtensionUpdater.class);
    private IRepository repository;
    private DataSource dataSource;
    private String location;
    private ExtensionManager extensionManager;

    public ExtensionUpdater(IRepository repository, DataSource dataSource, String location, HttpServletRequest request) {
        this.repository = repository;
        this.dataSource = dataSource;
        this.location = location;
        this.extensionManager = new ExtensionManager(repository, dataSource, request);
    }

    @Override
    public void executeUpdate(List<String> knownFiles, HttpServletRequest request, List<String> errors) throws Exception {
        if (knownFiles.size() == 0) {
            return;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                for (String dsDefinition : knownFiles) {
                    try {
                        if (dsDefinition.endsWith(EXTENSION_EXTENSION)) {
                            this.executeExtensionUpdate(connection, dsDefinition, request);
                            continue;
                        }
                        if (!dsDefinition.endsWith(EXTENSION_EXTENSION_POINT)) continue;
                        this.executeExtensionPointUpdate(connection, dsDefinition, request);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        if (errors == null) continue;
                        errors.add(e.getMessage());
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void executeExtensionUpdate(Connection connection, String scDefinition, HttpServletRequest request) throws IOException, EExtensionException {
        JsonObject edDefinition = this.parseExtension(scDefinition);
        String extensionName = edDefinition.get(NODE_EXTENSION).getAsString();
        String extensionPointName = edDefinition.get(NODE_EXTENSION_POINT).getAsString();
        String extensionDescription = edDefinition.get(NODE_DESCRIPTION).getAsString();
        ExtensionDefinition extensionDefinition = this.extensionManager.getExtension(extensionName, extensionPointName);
        if (extensionDefinition == null) {
            this.extensionManager.createExtension(extensionName, extensionPointName, extensionDescription);
        } else {
            this.extensionManager.updateExtension(extensionName, extensionPointName, extensionDescription);
        }
    }

    private void executeExtensionPointUpdate(Connection connection, String scDefinition, HttpServletRequest request) throws IOException, EExtensionException {
        JsonObject edDefinition = this.parseExtensionPoint(scDefinition);
        String extensionPointName = edDefinition.get(NODE_EXTENSION_POINT).getAsString();
        String extensionDescription = edDefinition.get(NODE_DESCRIPTION).getAsString();
        ExtensionPointDefinition extensionPointDefinition = this.extensionManager.getExtensionPoint(extensionPointName);
        if (extensionPointDefinition == null) {
            this.extensionManager.createExtensionPoint(extensionPointName, extensionDescription);
        } else {
            this.extensionManager.updateExtensionPoint(extensionPointName, extensionDescription);
        }
    }

    private JsonObject parseExtension(String dsDefinition) throws IOException {
        IResource resource = this.repository.getResource(dsDefinition);
        String content = new String(resource.getContent(), ICommonConstants.UTF8);
        JsonParser parser = new JsonParser();
        JsonObject dsDefinitionObject = (JsonObject)parser.parse(content);
        return dsDefinitionObject;
    }

    private JsonObject parseExtensionPoint(String dsDefinition) throws IOException {
        IResource resource = this.repository.getResource(dsDefinition);
        String content = new String(resource.getContent(), ICommonConstants.UTF8);
        JsonParser parser = new JsonParser();
        JsonObject dsDefinitionObject = (JsonObject)parser.parse(content);
        return dsDefinitionObject;
    }

    @Override
    public void enumerateKnownFiles(ICollection collection, List<String> dsDefinitions) throws IOException {
        if (collection.exists()) {
            List resources = collection.getResources();
            for (IResource resource : resources) {
                if (resource == null || resource.getName() == null || !resource.getName().endsWith(EXTENSION_EXTENSION) && !resource.getName().endsWith(EXTENSION_EXTENSION_POINT)) continue;
                String fullPath = resource.getPath();
                dsDefinitions.add(fullPath);
            }
            List collections = collection.getCollections();
            for (ICollection subCollection : collections) {
                this.enumerateKnownFiles(subCollection, dsDefinitions);
            }
        }
    }

    @Override
    public void applyUpdates() throws IOException, Exception {
        ArrayList<String> knownFiles = new ArrayList<String>();
        ICollection srcContainer = this.repository.getCollection(this.location);
        if (srcContainer.exists()) {
            this.enumerateKnownFiles(srcContainer, knownFiles);
            this.executeUpdate(knownFiles, null);
        }
    }

    @Override
    public IRepository getRepository() {
        return this.repository;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void executeUpdate(List<String> knownFiles, List<String> errors) throws Exception {
        this.executeUpdate(knownFiles, null, errors);
    }
}

