/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource;

public class DBSupportedTypesMap {
    public static String[] getSupportedTypes() {
        return new String[]{DataTypes.VARCHAR.toString(), DataTypes.CHAR.toString(), DataTypes.INTEGER.toString(), DataTypes.BIGINT.toString(), DataTypes.SMALLINT.toString(), DataTypes.REAL.toString(), DataTypes.DOUBLE.toString(), DataTypes.DATE.toString(), DataTypes.TIME.toString(), DataTypes.TIMESTAMP.toString(), DataTypes.BLOB.toString()};
    }

    public static String getTypeName(int type) {
        String typeName = null;
        switch (type) {
            case -5: {
                typeName = DataTypes.BIGINT.toString();
                break;
            }
            case -2: {
                typeName = DataTypes.BINARY.toString();
                break;
            }
            case -7: {
                typeName = DataTypes.BIT.toString();
                break;
            }
            case 2004: {
                typeName = DataTypes.BLOB.toString();
                break;
            }
            case 16: {
                typeName = DataTypes.BOOLEAN.toString();
                break;
            }
            case 1: {
                typeName = DataTypes.CHAR.toString();
                break;
            }
            case 2005: {
                typeName = DataTypes.CLOB.toString();
                break;
            }
            case 91: {
                typeName = DataTypes.DATE.toString();
                break;
            }
            case 3: {
                typeName = DataTypes.DECIMAL.toString();
                break;
            }
            case 8: {
                typeName = DataTypes.DOUBLE.toString();
                break;
            }
            case 6: {
                typeName = DataTypes.FLOAT.toString();
                break;
            }
            case 4: {
                typeName = DataTypes.INTEGER.toString();
                break;
            }
            case 2: {
                typeName = DataTypes.NUMERIC.toString();
                break;
            }
            case -9: {
                typeName = DataTypes.NVARCHAR.toString();
                break;
            }
            case 5: {
                typeName = DataTypes.SMALLINT.toString();
                break;
            }
            case 92: {
                typeName = DataTypes.TIME.toString();
                break;
            }
            case 93: {
                typeName = DataTypes.TIMESTAMP.toString();
                break;
            }
            case -6: {
                typeName = DataTypes.TINYINT.toString();
                break;
            }
            case 7: {
                typeName = DataTypes.REAL.toString();
                break;
            }
            case 12: {
                typeName = DataTypes.VARCHAR.toString();
                break;
            }
            default: {
                typeName = String.valueOf(DataTypes.UNSUPPORTED_TYPE.toString()) + type;
            }
        }
        return typeName;
    }

    public static int getTypeNumber(String name) {
        int typeNumber = -1;
        switch (DataTypes.valueOf(name)) {
            case BIGINT: {
                typeNumber = -5;
                break;
            }
            case BINARY: {
                typeNumber = -2;
                break;
            }
            case BIT: {
                typeNumber = -7;
                break;
            }
            case BLOB: {
                typeNumber = 2004;
                break;
            }
            case BOOLEAN: {
                typeNumber = 16;
                break;
            }
            case CHAR: {
                typeNumber = 1;
                break;
            }
            case CLOB: {
                typeNumber = 2005;
                break;
            }
            case DATE: {
                typeNumber = 91;
                break;
            }
            case DECIMAL: {
                typeNumber = 3;
                break;
            }
            case DOUBLE: {
                typeNumber = 8;
                break;
            }
            case FLOAT: {
                typeNumber = 6;
                break;
            }
            case INTEGER: {
                typeNumber = 4;
                break;
            }
            case NUMERIC: {
                typeNumber = 2;
                break;
            }
            case NVARCHAR: {
                typeNumber = -9;
                break;
            }
            case SMALLINT: {
                typeNumber = 5;
                break;
            }
            case TIME: {
                typeNumber = 92;
                break;
            }
            case TIMESTAMP: {
                typeNumber = 93;
                break;
            }
            case TINYINT: {
                typeNumber = -6;
                break;
            }
            case REAL: {
                typeNumber = 7;
                break;
            }
            case VARCHAR: {
                typeNumber = 12;
            }
        }
        return typeNumber;
    }

    public static enum DataTypes {
        VARCHAR,
        TINYINT,
        TIMESTAMP,
        TIME,
        SMALLINT,
        NVARCHAR,
        NUMERIC,
        INTEGER,
        REAL,
        FLOAT,
        DOUBLE,
        DECIMAL,
        DATE,
        CLOB,
        CHAR,
        BOOLEAN,
        BLOB,
        BIT,
        BINARY,
        BIGINT,
        UNSUPPORTED_TYPE;

    }
}

