/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.local;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import org.eclipse.dirigible.repository.api.IResourceVersion;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.local.FileSystemRepository;
import org.eclipse.dirigible.repository.local.LocalFileVersion;
import org.eclipse.dirigible.repository.local.LocalObject;

public class LocalResourceVersion
implements IResourceVersion {
    private final FileSystemRepository repository;
    private final RepositoryPath path;
    private int version;
    private LocalFileVersion fileVersion;

    public LocalResourceVersion(FileSystemRepository repository, RepositoryPath path, int version) throws FileNotFoundException, IOException {
        this.repository = repository;
        this.path = path;
        this.version = version;
        this.fileVersion = this.getRepository().getRepositoryDAO().getFileVersionByPath(this.getPath(), version);
    }

    public FileSystemRepository getRepository() {
        return this.repository;
    }

    public String getPath() {
        return this.path.toString();
    }

    protected LocalObject getDBObject() throws IOException {
        return this.fileVersion;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getContent() throws IOException {
        return this.fileVersion.getData();
    }

    public boolean isBinary() {
        return this.fileVersion.isBinary();
    }

    public String getContentType() {
        return this.fileVersion.getContentType();
    }

    public String getCreatedBy() {
        return this.fileVersion.getCreatedBy();
    }

    public Date getCreatedAt() {
        return this.fileVersion.getCreatedAt();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LocalResourceVersion)) {
            return false;
        }
        LocalResourceVersion other = (LocalResourceVersion)obj;
        return this.getPath().equals(other.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public int compareTo(IResourceVersion o) {
        try {
            int x = this.getVersion();
            int y = o.getVersion();
            return x < y ? -1 : (x == y ? 0 : 1);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

