/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.extensions.ui.view;

import java.util.ArrayList;
import org.eclipse.dirigible.ide.extensions.ui.view.SimpleTreeNode;
import org.eclipse.dirigible.repository.ext.extensions.EExtensionException;
import org.eclipse.dirigible.repository.ext.extensions.ExtensionManager;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ExtensionsViewContentProvider
implements ITreeContentProvider {
    private static final long serialVersionUID = 1309704265765047023L;
    private static final Logger logger = Logger.getLogger(ExtensionsViewContentProvider.class);
    private ExtensionManager extensionManager;

    public ExtensionsViewContentProvider(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        try {
            return this.toSimpleTreeNode(this.extensionManager.getExtensionPoints(), null);
        }
        catch (EExtensionException e) {
            logger.error("Failed to get extension points", (Throwable)e);
            return null;
        }
    }

    private Object[] toSimpleTreeNode(String[] nodes, SimpleTreeNode parent) {
        ArrayList<SimpleTreeNode> result = new ArrayList<SimpleTreeNode>();
        if (nodes != null) {
            String[] stringArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                String node = stringArray[n2];
                result.add(new SimpleTreeNode(node, parent));
                ++n2;
            }
        }
        return result.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        try {
            return this.toSimpleTreeNode(this.extensionManager.getExtensions(parentElement.toString()), (SimpleTreeNode)parentElement);
        }
        catch (EExtensionException e) {
            logger.error("Failed to get extensions", (Throwable)e);
            return null;
        }
    }

    public Object getParent(Object element) {
        return ((SimpleTreeNode)element).getParent();
    }

    public boolean hasChildren(Object element) {
        return ((SimpleTreeNode)element).isRootElement();
    }
}

