/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.ICommonConstants;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.datasource.DBSupportedTypesMap;
import org.eclipse.dirigible.repository.datasource.db.dialect.IDialectSpecifier;
import org.eclipse.dirigible.repository.ext.db.AbstractDataUpdater;
import org.eclipse.dirigible.repository.ext.db.DBUtils;
import org.eclipse.dirigible.repository.ext.db.Messages;
import org.eclipse.dirigible.repository.ext.db.model.DataStructureModel;
import org.eclipse.dirigible.repository.ext.db.model.DataStructureModelFactory;
import org.eclipse.dirigible.repository.ext.db.model.EDataStructureModelFormatException;
import org.eclipse.dirigible.repository.ext.db.model.TableColumnModel;
import org.eclipse.dirigible.repository.ext.db.model.TableModel;
import org.eclipse.dirigible.repository.ext.db.model.TopologicalSorter;
import org.eclipse.dirigible.repository.ext.db.model.ViewModel;
import org.eclipse.dirigible.repository.logging.Logger;

public class DatabaseUpdater
extends AbstractDataUpdater {
    private static final String DASH = " - ";
    private static final String AUTOMATIC_DROP_COLUMN_NOT_SUPPORTED = Messages.getString("DatabaseUpdater.AUTOMATIC_DROP_COLUMN_NOT_SUPPORTED");
    private static final String AS = " AS ";
    private static final String CREATE_VIEW = "CREATE VIEW ";
    private static final String DROP_VIEW = "DROP VIEW ";
    private static final String CANNOT_BE_CHANGED_TO = Messages.getString("DatabaseUpdater.CANNOT_BE_CHANGED_TO");
    private static final String TYPE2 = Messages.getString("DatabaseUpdater.TYPE2");
    private static final String ADDING_PRIMARY_KEY_COLUMN = Messages.getString("DatabaseUpdater.ADDING_PRIMARY_KEY_COLUMN");
    private static final String ADDING_NOT_NULL_COLUMN = Messages.getString("DatabaseUpdater.ADDING_NOT_NULL_COLUMN");
    private static final String AND_COLUMN = Messages.getString("DatabaseUpdater.AND_COLUMN");
    private static final String INCOMPATIBLE_CHANGE_OF_TABLE = Messages.getString("DatabaseUpdater.INCOMPATIBLE_CHANGE_OF_TABLE");
    private static final String ALTER_TABLE = "ALTER TABLE ";
    private static final String CREATE_TABLE = "CREATE TABLE ";
    private static final String DEFAULT = "DEFAULT ";
    private static final String PRIMARY_KEY = "PRIMARY KEY ";
    private static final String NOT_NULL = "NOT NULL ";
    private static final Logger logger = Logger.getLogger(DatabaseUpdater.class);
    public static final String EXTENSION_TABLE = ".table";
    public static final String EXTENSION_VIEW = ".view";
    public static final String REGISTRY_DATA_STRUCTURES_DEFAULT = "/db/dirigible/registry/public/DataStructures";
    private IRepository repository;
    private DataSource dataSource;
    private String location;
    private DBUtils dbUtils;

    public DatabaseUpdater(IRepository repository, DataSource dataSource, String location) {
        this.repository = repository;
        this.dataSource = dataSource;
        this.location = location;
        this.dbUtils = new DBUtils(dataSource);
    }

    @Override
    public void executeUpdate(List<String> knownFiles, List<String> errors) throws Exception {
        if (knownFiles.size() == 0) {
            return;
        }
        logger.debug("DatabaseUpdater->executeUpdate start...");
        logger.debug("unsorted ------");
        for (String fileName : knownFiles) {
            logger.debug("fileName: " + fileName);
        }
        knownFiles.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                boolean b2;
                boolean b1 = o1.endsWith(DatabaseUpdater.EXTENSION_TABLE);
                return b1 & (b2 = o2.endsWith(DatabaseUpdater.EXTENSION_TABLE)) ? 0 : (b1 && !b2 ? -1 : 1);
            }
        });
        logger.debug("preliminary sorting ------");
        for (String fileName : knownFiles) {
            logger.debug("fileName: " + fileName);
        }
        try {
            Connection connection = null;
            try {
                DataStructureModel model;
                connection = this.dataSource.getConnection();
                String productName = connection.getMetaData().getDatabaseProductName();
                IDialectSpecifier dialectSpecifier = DBUtils.getDialectSpecifier(productName);
                LinkedHashMap<String, DataStructureModel> models = new LinkedHashMap<String, DataStructureModel>();
                for (String dsDefinition : knownFiles) {
                    try {
                        if (dsDefinition.endsWith(EXTENSION_TABLE)) {
                            TableModel tableModel = this.parseTable(dsDefinition);
                            models.put(tableModel.getName(), tableModel);
                            continue;
                        }
                        if (!dsDefinition.endsWith(EXTENSION_VIEW)) continue;
                        ViewModel viewModel = this.parseView(dsDefinition);
                        models.put(viewModel.getName(), viewModel);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        if (errors == null) continue;
                        errors.add(e.getMessage());
                    }
                }
                ArrayList<String> output = new ArrayList<String>();
                ArrayList<String> external = new ArrayList<String>();
                try {
                    TopologicalSorter.sort(models, output, external);
                    logger.debug("topological sorting ------");
                    for (String fileName : output) {
                        logger.debug("fileName: " + fileName);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    if (errors != null) {
                        errors.add(e.getMessage());
                    }
                    output.clear();
                }
                if (output.isEmpty()) {
                    logger.debug("probably cyclic dependencies!");
                    output.addAll(models.keySet());
                }
                int i = output.size() - 1;
                while (i >= 0) {
                    block26: {
                        String dsName = (String)output.get(i);
                        model = (DataStructureModel)models.get(dsName);
                        try {
                            if (model instanceof ViewModel) {
                                this.executeViewDrop(connection, (ViewModel)model);
                            }
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                            if (errors == null) break block26;
                            errors.add(e.getMessage());
                        }
                    }
                    --i;
                }
                for (String dsName : output) {
                    model = (DataStructureModel)models.get(dsName);
                    try {
                        if (model instanceof TableModel) {
                            this.executeTableUpdateMain(connection, dialectSpecifier, (TableModel)model);
                            continue;
                        }
                        if (!(model instanceof ViewModel)) continue;
                        this.executeViewCreate(connection, (ViewModel)model);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        if (errors == null) continue;
                        errors.add(e.getMessage());
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.debug("DatabaseUpdater->executeUpdate end.");
    }

    private TableModel parseTable(String dsDefinition) throws IOException {
        TableModel tableModel;
        String content = this.getContent(dsDefinition);
        try {
            tableModel = DataStructureModelFactory.createTableModel(content);
        }
        catch (EDataStructureModelFormatException e) {
            throw new IOException(e);
        }
        return tableModel;
    }

    private ViewModel parseView(String dsDefinition) throws IOException {
        ViewModel viewModel;
        String content = this.getContent(dsDefinition);
        try {
            viewModel = DataStructureModelFactory.createViewModel(content);
        }
        catch (EDataStructureModelFormatException e) {
            throw new IOException(e);
        }
        return viewModel;
    }

    @Override
    public void executeUpdate(List<String> knownFiles, HttpServletRequest request, List<String> errors) throws Exception {
        this.executeUpdate(knownFiles, errors);
    }

    private void executeTableUpdateMain(Connection connection, IDialectSpecifier dialectSpecifier, TableModel tableModel) throws SQLException {
        String tableName = tableModel.getName();
        boolean exists = DBUtils.isTableOrViewExists(connection, tableName);
        if (exists) {
            this.executeTableUpdate(connection, dialectSpecifier, tableModel);
        } else {
            this.executeTableCreate(connection, dialectSpecifier, tableModel);
        }
    }

    private void executeTableCreate(Connection connection, IDialectSpecifier dialectSpecifier, TableModel tableModel) throws SQLException {
        logger.info("Processing table 'create': " + tableModel.getName());
        StringBuilder sql = new StringBuilder();
        String tableName = tableModel.getName();
        sql.append(CREATE_TABLE + tableName + " (");
        List<TableColumnModel> columns = tableModel.getColumns();
        int i = 0;
        for (TableColumnModel columnModel : columns) {
            if (i > 0 && i < columns.size()) {
                sql.append(", ");
            }
            String name = columnModel.getName();
            String type = this.dbUtils.specifyDataType(connection, columnModel.getType());
            String length = columnModel.getLength();
            boolean notNull = columnModel.isNotNull();
            boolean primaryKey = columnModel.isPrimaryKey();
            String defaultValue = columnModel.getDefaultValue();
            sql.append(String.valueOf(name) + " " + type);
            if (DBSupportedTypesMap.DataTypes.VARCHAR.equals((Object)DBSupportedTypesMap.DataTypes.valueOf((String)type)) || DBSupportedTypesMap.DataTypes.CHAR.equals((Object)DBSupportedTypesMap.DataTypes.valueOf((String)type))) {
                sql.append("(" + length + ") ");
            } else {
                sql.append(" ");
            }
            if (notNull) {
                sql.append(NOT_NULL);
            }
            if (primaryKey) {
                sql.append(PRIMARY_KEY);
            }
            if (defaultValue != null && !"".equals(defaultValue)) {
                sql.append(DEFAULT + defaultValue + " ");
            }
            ++i;
        }
        sql.append(")");
        String sqlExpression = sql.toString();
        try {
            logger.info(sqlExpression);
            this.executeUpdateSQL(connection, sqlExpression);
        }
        catch (SQLException e) {
            logger.error(sqlExpression);
            logger.error(e.getMessage(), (Throwable)e);
            throw new SQLException(e.getMessage(), e);
        }
    }

    private void executeUpdateSQL(Connection connection, String sql) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.executeUpdate();
    }

    private void executeTableUpdate(Connection connection, IDialectSpecifier dialectSpecifier, TableModel tableModel) throws SQLException {
        logger.info("Processing table 'update': " + tableModel.getName());
        StringBuilder sql = new StringBuilder();
        String tableName = tableModel.getName();
        HashMap<String, String> columnDefinitions = new HashMap<String, String>();
        ResultSet rsColumns = DBUtils.getColumns(connection, tableName);
        while (rsColumns.next()) {
            String typeName = this.dbUtils.specifyDataType(connection, DBSupportedTypesMap.getTypeName((int)rsColumns.getInt(5)));
            columnDefinitions.put(rsColumns.getString(4), typeName);
        }
        sql.append(ALTER_TABLE + tableName + " ");
        List<TableColumnModel> columns = tableModel.getColumns();
        int i = 0;
        StringBuffer addSql = new StringBuffer();
        String alterAddOpen = dialectSpecifier.getAlterAddOpen();
        if (alterAddOpen != null) {
            addSql.append(alterAddOpen);
        }
        for (TableColumnModel columnModel : columns) {
            String name = columnModel.getName();
            String type = this.dbUtils.specifyDataType(connection, columnModel.getType());
            String length = columnModel.getLength();
            boolean notNull = columnModel.isNotNull();
            boolean primaryKey = columnModel.isPrimaryKey();
            String defaultValue = columnModel.getDefaultValue();
            if (!columnDefinitions.containsKey(name)) {
                String alterAddOpenEach;
                if (i > 0) {
                    addSql.append(", ");
                }
                if ((alterAddOpenEach = dialectSpecifier.getAlterAddOpenEach()) != null) {
                    addSql.append(alterAddOpenEach);
                }
                addSql.append(String.valueOf(name) + " " + type);
                if (DBSupportedTypesMap.DataTypes.VARCHAR.equals((Object)DBSupportedTypesMap.DataTypes.valueOf((String)type)) || DBSupportedTypesMap.DataTypes.CHAR.equals((Object)DBSupportedTypesMap.DataTypes.valueOf((String)type))) {
                    addSql.append("(" + length + ") ");
                } else {
                    addSql.append(" ");
                }
                if (notNull) {
                    throw new SQLException(String.valueOf(INCOMPATIBLE_CHANGE_OF_TABLE) + tableName + AND_COLUMN + name + ADDING_NOT_NULL_COLUMN);
                }
                if (primaryKey) {
                    throw new SQLException(String.valueOf(INCOMPATIBLE_CHANGE_OF_TABLE) + tableName + AND_COLUMN + name + ADDING_PRIMARY_KEY_COLUMN);
                }
                String alterAddCloseEach = dialectSpecifier.getAlterAddCloseEach();
                if (alterAddCloseEach != null) {
                    addSql.append(alterAddCloseEach);
                }
                if (defaultValue != null && !"".equals(defaultValue)) {
                    addSql.append(DEFAULT + defaultValue + " ");
                }
                ++i;
                continue;
            }
            if (((String)columnDefinitions.get(name)).equals(type)) continue;
            throw new SQLException(String.valueOf(INCOMPATIBLE_CHANGE_OF_TABLE) + tableName + AND_COLUMN + name + TYPE2 + (String)columnDefinitions.get(name) + CANNOT_BE_CHANGED_TO + type);
        }
        if (i > 0) {
            String alterAddClose = dialectSpecifier.getAlterAddClose();
            if (alterAddClose != null) {
                addSql.append(alterAddClose);
            }
            sql.append(addSql.toString());
        }
        if (columnDefinitions.size() > columns.size()) {
            throw new SQLException(String.valueOf(INCOMPATIBLE_CHANGE_OF_TABLE) + tableName + DASH + AUTOMATIC_DROP_COLUMN_NOT_SUPPORTED);
        }
        if (i > 0) {
            String sqlExpression = sql.toString();
            try {
                logger.info(sqlExpression);
                this.executeUpdateSQL(connection, sqlExpression);
            }
            catch (SQLException e) {
                logger.error(sqlExpression);
                logger.error(e.getMessage(), (Throwable)e);
                throw new SQLException(e.getMessage(), e);
            }
        }
    }

    private String getContent(String dsDefinition) throws IOException {
        IResource resource = this.repository.getResource(dsDefinition);
        String content = new String(resource.getContent(), ICommonConstants.UTF8);
        return content;
    }

    private void executeViewDrop(Connection connection, ViewModel viewModel) throws SQLException {
        logger.info("Processing view 'drop': " + viewModel.getName());
        StringBuilder sql = new StringBuilder();
        String viewName = viewModel.getName();
        String sqlExpression = null;
        boolean exists = DBUtils.isTableOrViewExists(connection, viewName);
        if (exists) {
            sql.append(DROP_VIEW + viewName);
            sqlExpression = sql.toString();
            try {
                logger.info(sqlExpression);
                this.executeUpdateSQL(connection, sqlExpression);
            }
            catch (SQLException e) {
                logger.error(sqlExpression);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void executeViewCreate(Connection connection, ViewModel viewModel) throws SQLException {
        logger.info("Processing view 'create': " + viewModel.getName());
        StringBuilder sql = new StringBuilder();
        String viewName = viewModel.getName();
        String query = viewModel.getQuery();
        sql.append(CREATE_VIEW + viewName + AS + query);
        String sqlExpression = sql.toString();
        try {
            logger.info(sqlExpression);
            this.executeUpdateSQL(connection, sqlExpression);
        }
        catch (SQLException e) {
            logger.error(sqlExpression);
            logger.error(e.getMessage(), (Throwable)e);
            throw new SQLException(e.getMessage(), e);
        }
    }

    @Override
    public void enumerateKnownFiles(ICollection collection, List<String> dsDefinitions) throws IOException {
        if (collection.exists()) {
            List resources = collection.getResources();
            for (IResource resource : resources) {
                if (resource == null || resource.getName() == null || !resource.getName().endsWith(EXTENSION_TABLE) && !resource.getName().endsWith(EXTENSION_VIEW)) continue;
                String fullPath = resource.getPath();
                dsDefinitions.add(fullPath);
            }
            List collections = collection.getCollections();
            for (ICollection subCollection : collections) {
                this.enumerateKnownFiles(subCollection, dsDefinitions);
            }
        }
    }

    @Override
    public IRepository getRepository() {
        return this.repository;
    }

    @Override
    public String getLocation() {
        return this.location;
    }
}

