/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.command;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.dirigible.repository.ext.command.Commandline;

public class ProcessUtils {
    public static int DEFAULT_WAIT_TIME = 1000;
    public static int DEFAULT_LOOP_COUNT = 30;

    public static ProcessBuilder createProcess(String[] args) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        return processBuilder;
    }

    public static void addEnvironmentVariables(ProcessBuilder processBuilder, Map<String, String> forAdding) {
        if (processBuilder != null && forAdding != null) {
            Map<String, String> env = processBuilder.environment();
            env.putAll(forAdding);
        }
    }

    public static void removeEnvironmentVariables(ProcessBuilder processBuilder, List<String> forRemoving) {
        if (processBuilder != null && forRemoving != null) {
            Map<String, String> env = processBuilder.environment();
            for (String remove : forRemoving) {
                env.remove(remove);
            }
        }
    }

    public static Process startProcess(String[] args, ProcessBuilder processBuilder) throws IOException {
        Process process = processBuilder.start();
        return process;
    }

    public static String[] translateCommandline(String toProcess) {
        return Commandline.translateCommandline(toProcess);
    }
}

