/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.html.wizard;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlForEntityTemplateModel;
import org.eclipse.dirigible.ide.template.ui.html.wizard.TableColumn;
import org.eclipse.dirigible.repository.logging.Logger;

public class HtmlForEntityTemplateGenerator
extends TemplateGenerator {
    private static final Logger logger = Logger.getLogger(HtmlForEntityTemplateGenerator.class);
    private static final String REST_SERVICE_ROOT_JS = "../../js";
    private static final String LOG_TAG = "HTML_FOR_ENTITY_GENERATOR";
    private HtmlForEntityTemplateModel model;

    public HtmlForEntityTemplateGenerator(HtmlForEntityTemplateModel model) {
        this.model = model;
    }

    protected Map<String, Object> prepareParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("pageTitle", this.model.getPageTitle());
        parameters.put("tableName", this.model.getTableName());
        parameters.put("tableColumns", this.model.getTableColumns());
        parameters.put("fileName", this.model.getFileName());
        parameters.put("serviceFileName", this.generateServiceFileName());
        parameters.put("createDataModel", this.createDataModel());
        parameters.put("entityName", this.getEntityName());
        parameters.put("primaryKey", this.getPrimaryKey());
        return parameters;
    }

    private Object getPrimaryKey() {
        TableColumn[] columns = this.model.getTableColumns();
        TableColumn primaryKey = null;
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            if (column.isKey()) {
                primaryKey = column;
            }
            ++n2;
        }
        if (primaryKey == null) {
            logger.error(String.format("There is no primary key in table %s, which can produce errornous artifacts", this.model.getTableName()));
            return null;
        }
        return primaryKey;
    }

    protected String getEntityName() {
        return "data";
    }

    protected String createDataModel() {
        return "tableModel = new sap.ui.model.json.JSONModel();\n\t\ttableModel.loadData(\"" + this.generateServiceFileName() + "\");";
    }

    protected Object generateServiceFileName() {
        String result = "";
        if (this.model.getSourceFile() != null) {
            IFile source = this.model.getSourceFile();
            String entityPath = source.getFullPath().toString();
            int index = entityPath.indexOf("ScriptingServices");
            result = index >= 0 ? entityPath.substring(index + "ScriptingServices".length()) : entityPath;
            result = result.replace(source.getFileExtension(), "");
            result = String.valueOf(result) + "js";
        } else {
            result = this.model.getServiceEndpoint();
        }
        return REST_SERVICE_ROOT_JS + result;
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String getLogTag() {
        return LOG_TAG;
    }

    protected byte[] afterGeneration(byte[] bytes) {
        byte[] result = this.model.normalizeEscapes(bytes);
        return result;
    }
}

