/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.ext.security.SecurityManager;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;
import org.eclipse.dirigible.runtime.security.Messages;

public class SecuritySynchronizer
implements Runnable {
    private static final String REFRESHING_OF_SECURED_LOCATIONS_FAILED = Messages.SecuritySynchronizer_REFRESHING_OF_SECURED_LOCATIONS_FAILED;
    private static final Logger logger = Logger.getLogger(SecuritySynchronizer.class);
    private static List<String> securedLocations = Collections.synchronizedList(new ArrayList());

    @Override
    public void run() {
        logger.debug("entering: " + this.getClass().getCanonicalName() + " -> " + "run");
        try {
            this.refreshSecuredLocations();
            logger.debug("Refresh of secured locations successful for: " + securedLocations.size());
        }
        catch (Exception e) {
            logger.error(REFRESHING_OF_SECURED_LOCATIONS_FAILED, (Throwable)e);
        }
        logger.debug("exiting: " + this.getClass().getCanonicalName() + " -> " + "run");
    }

    public static List<String> getSecuredLocations() {
        return securedLocations;
    }

    private void refreshSecuredLocations() throws ServletException {
        SecurityManager securityManager = null;
        try {
            DataSource dataSource = DataSourceFacade.getInstance().getDataSource(null);
            IRepository repository = RepositoryFacade.getInstance().getRepository(null);
            securityManager = SecurityManager.getInstance((IRepository)repository, (DataSource)dataSource);
            securedLocations = securityManager.getSecuredLocations();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

