/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.content;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.PermissionsUtils;
import org.eclipse.dirigible.runtime.content.ContentExporterServlet;

public class CloneExporterServlet
extends ContentExporterServlet {
    private static final long serialVersionUID = -2906745438795974322L;
    private static final Logger logger = Logger.getLogger(CloneExporterServlet.class);
    static final String CLONE_PATH_FOR_EXPORT = "/db/dirigible/".substring(0, "/db/dirigible/".length() - 1);
    public static final String CLONE = "clone";

    @Override
    protected String getDefaultPathForExport() {
        return CLONE_PATH_FOR_EXPORT;
    }

    @Override
    protected String getExportFilePrefix() {
        StringBuilder buff = new StringBuilder();
        buff.append(CLONE).append("_");
        try {
            buff.append(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            logger.error(e.getMessage(), (Throwable)e);
            buff.append("unknown_host");
        }
        return buff.toString();
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!PermissionsUtils.isUserInRole((HttpServletRequest)request, (String)"Operator")) {
            String err = String.format("%s called, but the user does not have permissions to do this operation", "Export Cloned Content");
            logger.error(err);
            throw new ServletException(err);
        }
        super.doGet(request, response);
    }
}

