/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.supplemental.fileupload;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadReceiver;
import org.eclipse.rap.rwt.supplemental.fileupload.IFileUploadDetails;
import org.eclipse.rap.rwt.supplemental.fileupload.Messages;

public class DiskFileUploadReceiver
extends FileUploadReceiver {
    private static final String UNABLE_TO_CREATE_TEMP_DIRECTORY = Messages.DiskFileUploadReceiver_UNABLE_TO_CREATE_TEMP_DIRECTORY;
    private static final String DEFAULT_CONTENT_TYPE_FILE_NAME = "content-type.tmp";
    private static final String DEFAULT_TARGET_FILE_NAME = "upload.tmp";
    private static final String TEMP_DIRECTORY_PREFIX = "fileupload_";
    private File targetFile;
    private File contentTypeFile;

    @Override
    public void receive(InputStream dataStream, IFileUploadDetails details) throws IOException {
        File targetFile = this.createTargetFile(details);
        FileOutputStream outputStream = new FileOutputStream(targetFile);
        try {
            DiskFileUploadReceiver.copy(dataStream, outputStream);
        }
        finally {
            outputStream.close();
        }
        this.targetFile = targetFile;
        this.contentTypeFile = this.createContentTypeFile(targetFile, details);
        if (this.contentTypeFile != null) {
            PrintWriter pw = new PrintWriter(this.contentTypeFile);
            pw.print(details.getContentType());
            pw.close();
        }
    }

    public static String getContentType(File uploadedFile) {
        File cTypeFile;
        String contentType = null;
        BufferedReader br = null;
        if (uploadedFile.exists() && (cTypeFile = new File(uploadedFile.getParentFile(), DEFAULT_CONTENT_TYPE_FILE_NAME)).exists()) {
            try {
                try {
                    br = new BufferedReader(new InputStreamReader(new FileInputStream(cTypeFile)));
                    contentType = br.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException ce) {
                        ce.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ce) {
                    ce.printStackTrace();
                }
            }
        }
        return contentType;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    protected File createTargetFile(IFileUploadDetails details) throws IOException {
        String fileName = DEFAULT_TARGET_FILE_NAME;
        if (details != null && details.getFileName() != null) {
            fileName = details.getFileName();
        }
        File result = new File(DiskFileUploadReceiver.createTempDirectory(), fileName);
        result.createNewFile();
        return result;
    }

    protected File createContentTypeFile(File uploadedFile, IFileUploadDetails details) throws IOException {
        String fileName = DEFAULT_CONTENT_TYPE_FILE_NAME;
        File result = null;
        if (details != null && details.getContentType() != null) {
            result = new File(uploadedFile.getParentFile(), fileName);
            result.createNewFile();
        }
        return result;
    }

    private static File createTempDirectory() throws IOException {
        File result = File.createTempFile(TEMP_DIRECTORY_PREFIX, "");
        result.delete();
        if (!result.mkdir()) {
            throw new IOException(String.valueOf(UNABLE_TO_CREATE_TEMP_DIRECTORY) + result.getAbsolutePath());
        }
        result.deleteOnExit();
        return result;
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[8192];
        boolean finished = false;
        while (!finished) {
            int bytesRead = inputStream.read(buffer);
            if (bytesRead != -1) {
                outputStream.write(buffer, 0, bytesRead);
                continue;
            }
            finished = true;
        }
    }
}

