/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.log4j;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.emf.diffmerge.bridge.log4j.BridgeLogger;
import org.eclipse.emf.diffmerge.bridge.log4j.IBridgeLogListener;

public class BridgeLoggingAppender
extends AppenderSkeleton {
    private static final String LOG_PATTERN = "%m%n";
    private static final String APPENDER_NAME = "coevolution";
    private final List<IBridgeLogListener> _listeners = new ArrayList<IBridgeLogListener>();

    public BridgeLoggingAppender() {
        this.layout = new PatternLayout(LOG_PATTERN);
        this.setName(APPENDER_NAME);
        this.addBridgeLogListener(BridgeLogger.getInstance());
    }

    public void addBridgeLogListener(IBridgeLogListener listener_p) {
        if (listener_p != null) {
            this._listeners.add(listener_p);
        }
    }

    protected void append(LoggingEvent event_p) {
        this.notifyListeners(event_p);
    }

    public void close() {
        this.removeBridgeLogListener(BridgeLogger.getInstance());
        this.layout = null;
    }

    public synchronized void doAppend(LoggingEvent event_p) {
        super.doAppend(event_p);
    }

    protected void notifyListeners(LoggingEvent event_p) {
        for (IBridgeLogListener listener : this._listeners) {
            listener.handleLoggingEvent(event_p);
        }
    }

    public void removeBridgeLogListener(IBridgeLogListener listener_p) {
        if (listener_p != null) {
            this._listeners.remove(listener_p);
        }
    }

    public boolean requiresLayout() {
        return true;
    }
}

