/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.log4j;

import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;

public class BridgeElementLink
implements IHyperlink {
    protected static final Logger logger = Logger.getLogger(BridgeElementLink.class);
    private final URI _uri;

    public BridgeElementLink(URI uri_p) {
        this._uri = this.normalize(uri_p);
    }

    public void linkActivated() {
        if (this._uri.fragment() != null) {
            String fileName = this._uri.trimFragment().lastSegment();
            try {
                IEditorPart editor = this.openInEditor(fileName);
                if (editor != null) {
                    EditingDomain editingDomain = ((IEditingDomainProvider)editor).getEditingDomain();
                    ResourceSet internalResourceSet = editingDomain.getResourceSet();
                    EObject internalObject = internalResourceSet.getEObject(this._uri, false);
                    final List<EObject> selection = Collections.singletonList(internalObject);
                    if (selection != null && !selection.isEmpty()) {
                        final Viewer viewer = ((IViewerProvider)editor).getViewer();
                        Runnable runnable = new Runnable(){

                            public void run() {
                                if (viewer != null) {
                                    viewer.setSelection((ISelection)new StructuredSelection(selection.toArray()), true);
                                }
                            }
                        };
                        editor.getSite().getShell().getDisplay().asyncExec(runnable);
                    }
                    IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage page = workbenchWindow.getActivePage();
                    page.activate((IWorkbenchPart)editor);
                }
            }
            catch (PartInitException ex) {
                logger.error((Object)ex.getStackTrace(), (Throwable)ex);
            }
        }
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    private URI normalize(URI uri_p) {
        if (uri_p.scheme().equals("dummy")) {
            return URI.createPlatformResourceURI((String)uri_p.path(), (boolean)true).appendFragment(uri_p.fragment());
        }
        return uri_p;
    }

    public IEditorPart openInEditor(String fileName_p) throws PartInitException {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorDescriptor editorDescriptor = EditUIUtil.getDefaultEditor((String)fileName_p);
        URIEditorInput editorInput = new URIEditorInput(this._uri.trimFragment());
        IEditorPart editor = page.findEditor((IEditorInput)editorInput);
        if (editor == null) {
            editor = page.openEditor((IEditorInput)editorInput, editorDescriptor.getId());
        }
        return editor;
    }
}

