/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.export;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ContainerContentProvider
implements ITreeContentProvider {
    private boolean showClosedProjects = true;

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        IContainer container;
        if (element instanceof IWorkspace) {
            Object[] allProjects = ((IWorkspace)element).getRoot().getProjects();
            if (this.showClosedProjects) {
                return allProjects;
            }
            ArrayList<Object> accessibleProjects = new ArrayList<Object>();
            for (int i = 0; i < allProjects.length; ++i) {
                if (!allProjects[i].isOpen()) continue;
                accessibleProjects.add(allProjects[i]);
            }
            return accessibleProjects.toArray();
        }
        if (element instanceof IContainer && (container = (IContainer)element).isAccessible()) {
            try {
                ArrayList<IResource> children = new ArrayList<IResource>();
                IResource[] members = container.members();
                for (int i = 0; i < members.length; ++i) {
                    if (members[i].getType() == 1) continue;
                    children.add(members[i]);
                }
                return children.toArray();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return new Object[0];
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void showClosedProjects(boolean show) {
        this.showClosedProjects = show;
    }
}

