/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.ui;

import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.internal.ui.DelimitedStringList;
import org.eclipse.datatools.connectivity.internal.ui.DriverListCombo;
import org.eclipse.datatools.enablement.sybase.ui.JDBCProfileMessages;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class JDBCProfileTabs
extends DialogPage {
    protected static final String EMPTY_STRING = "";
    protected Composite rootComposite;
    protected TabFolder tabfolder;
    protected TabItem connTab;
    protected Composite connTabComposite;
    protected TabItem filtersTab;
    protected Composite filtersTabComposite;
    protected TabItem otherTab;
    protected Composite otherTabComposite;
    protected Text mDBUIDText;
    protected Text mDBPWDText;
    protected Text mURLText;
    protected Text mCatalogText;
    protected Text mSchemaText;
    protected Text mProcNameText;
    protected DriverListCombo combo = new DriverListCombo();
    protected DriverInstance mDriverInstance;
    protected DelimitedStringList mDBConnProps;
    protected ChangeListener comboListener;
    private ListenerList changeListeners = new ListenerList();
    protected IConnectionProfile mProfile;
    protected String mProviderID = null;
    protected boolean mShowFilterTab = true;
    protected boolean mShowOptionalTab = true;
    private String _preSelectedDriveName = null;
    private boolean _resetPwdFromDriver = true;

    public void setResetPwdFromDriver(boolean flag) {
        this._resetPwdFromDriver = flag;
    }

    public boolean getResetPwdFromDriver() {
        return this._resetPwdFromDriver;
    }

    public void createControl(Composite parent) {
        this.rootComposite = parent;
        this.tabfolder = new TabFolder(parent, 130);
        GridData gdata = new GridData(1808);
        gdata.grabExcessVerticalSpace = true;
        gdata.grabExcessHorizontalSpace = true;
        gdata.horizontalSpan = 2;
        this.tabfolder.setLayoutData((Object)gdata);
        this.connTab = new TabItem(this.tabfolder, 0);
        this.connTab.setText(JDBCProfileMessages.getString("JDBCProfileTabs.tabs.label.connection"));
        this.createConnectionTab(this.tabfolder);
        this.connTab.setControl((Control)this.connTabComposite);
        if (this.mShowFilterTab) {
            this.filtersTab = new TabItem(this.tabfolder, 0);
            this.filtersTab.setText(JDBCProfileMessages.getString("JDBCProfileTabs.tabs.label.filters"));
            this.createFilterTab(this.tabfolder);
            this.filtersTab.setControl((Control)this.filtersTabComposite);
        }
        if (this.mShowOptionalTab) {
            this.otherTab = new TabItem(this.tabfolder, 0);
            this.otherTab.setText(JDBCProfileMessages.getString("JDBCProfileTabs.tabs.label.other"));
            this.createOtherTab(this.tabfolder);
            this.otherTab.setControl((Control)this.otherTabComposite);
        }
        this.tabfolder.setSelection(0);
        this.initControls();
    }

    public void setConnectionProfile(IConnectionProfile profile) {
        this.mProfile = profile;
        this.initControls();
    }

    public IConnectionProfile getConnectionProfile() {
        return this.mProfile;
    }

    public boolean performOk() {
        return false;
    }

    public void setProviderID(String providerID) {
        this.mProviderID = providerID;
    }

    public String getProviderID() {
        return this.mProviderID;
    }

    protected void createOtherTab(TabFolder parent) {
        this.otherTabComposite = new Composite((Composite)parent, 0);
        GridLayout layout = new GridLayout(2, false);
        this.otherTabComposite.setLayout((Layout)layout);
        this.mDBConnProps = new DelimitedStringList(this.otherTabComposite, 0);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.mDBConnProps.setLayoutData((Object)gdata);
        this.mDBConnProps.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                JDBCProfileTabs.this.setErrorMessage(null);
                if (JDBCProfileTabs.this.mDBConnProps.getWarning() != null) {
                    JDBCProfileTabs.this.setErrorMessage(JDBCProfileTabs.this.mDBConnProps.getWarning());
                }
            }
        });
    }

    protected void createFilterTab(TabFolder parent) {
        this.filtersTabComposite = new Composite((Composite)parent, 0);
        GridLayout layout = new GridLayout(2, false);
        this.filtersTabComposite.setLayout((Layout)layout);
        this.mCatalogText = (Text)this.createLabelTextPair(this.filtersTabComposite, JDBCProfileMessages.getString("JDBCPropertyWizardPage.catalog.label"), (Control)this.mCatalogText, 2048, 768);
        this.mSchemaText = (Text)this.createLabelTextPair(this.filtersTabComposite, JDBCProfileMessages.getString("JDBCPropertyWizardPage.schema.label"), (Control)this.mSchemaText, 2048, 768);
        this.mProcNameText = (Text)this.createLabelTextPair(this.filtersTabComposite, JDBCProfileMessages.getString("JDBCPropertyWizardPage.procedureName.label"), (Control)this.mProcNameText, 2048, 768);
    }

    protected void createConnectionTab(TabFolder parent) {
        this.connTabComposite = new Composite((Composite)parent, 0);
        GridLayout layout = new GridLayout(2, false);
        this.connTabComposite.setLayout((Layout)layout);
        this.combo.setLabelText(JDBCProfileMessages.getString("JDBCPropertyWizardPage.driverCombo.label"));
        this.combo.setCategory("com.sybase.stf.servers.jdbc.sybase");
        this.combo.setNullDriverIsValid(false);
        this.combo.createContents(this.connTabComposite);
        if (this.combo.getErrorMessage() != null) {
            this.setErrorMessage(this.combo.getErrorMessage());
        }
        this.mURLText = (Text)this.createLabelTextPair(this.connTabComposite, JDBCProfileMessages.getString("JDBCPropertyWizardPage.url.label"), (Control)this.mURLText, 2048, 0);
        this.mURLText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JDBCProfileTabs.this.fireChangedEvent((Object)JDBCProfileTabs.this);
            }
        });
        this.mDBUIDText = (Text)this.createLabelTextPair(this.connTabComposite, JDBCProfileMessages.getString("JDBCPropertyWizardPage.userName.label"), (Control)this.mDBUIDText, 2048, 768);
        this.mDBUIDText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JDBCProfileTabs.this.fireChangedEvent((Object)JDBCProfileTabs.this);
            }
        });
        this.mDBPWDText = (Text)this.createLabelTextPair(this.connTabComposite, JDBCProfileMessages.getString("JDBCPropertyWizardPage.password.label"), (Control)this.mDBPWDText, 2048, 768);
        this.mDBPWDText.setEchoChar('*');
        this.mDBPWDText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JDBCProfileTabs.this.fireChangedEvent((Object)JDBCProfileTabs.this);
            }
        });
        this.comboListener = new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                JDBCProfileTabs.this.driverStateChanged();
            }
        };
        this.combo.addChangeListener(this.comboListener);
    }

    protected void driverStateChanged() {
        String oldPassword;
        String password;
        String oldUsername;
        this.mDriverInstance = this.combo.getSelectedDriverInstance();
        this.setErrorMessage(null);
        if (this.combo.getErrorMessage() != null) {
            this.setErrorMessage(this.combo.getErrorMessage());
        } else if (this.mURLText != null && !this.combo.getSelectedDriverName().equals(this._preSelectedDriveName)) {
            this.mURLText.setText(this.getDriverURL());
        }
        this._preSelectedDriveName = this.combo.getSelectedDriverName();
        String username = this.getNamedPropertyFromDriverInstance("User ID");
        if (username == null || username.trim().length() == 0) {
            username = EMPTY_STRING;
        }
        if ((oldUsername = this.mDBUIDText.getText()) == null || oldUsername.trim().length() == 0) {
            oldUsername = EMPTY_STRING;
        }
        if (oldUsername.length() == 0) {
            this.mDBUIDText.setText(username);
        }
        if ((password = this.getNamedPropertyFromDriverInstance("Password")) == null || password.trim().length() == 0) {
            password = EMPTY_STRING;
        }
        if ((oldPassword = this.mDBPWDText.getText()) == null || oldPassword.trim().length() == 0) {
            oldPassword = EMPTY_STRING;
        }
        if (oldPassword.length() == 0 && this._resetPwdFromDriver) {
            this.mDBPWDText.setText(password);
        }
        if (this.mShowFilterTab) {
            String procName;
            String schema;
            String catalog = this.getNamedPropertyFromDriverInstance("catalog");
            if (catalog == null) {
                catalog = "%";
            }
            if (!catalog.startsWith("[")) {
                this.mCatalogText.setText(catalog);
            }
            if ((schema = this.getNamedPropertyFromDriverInstance("schema")) == null || schema.trim().length() == 0) {
                schema = "%";
            }
            if (!schema.startsWith("[")) {
                this.mSchemaText.setText(schema);
            }
            if ((procName = this.getNamedPropertyFromDriverInstance("procname")) == null || procName.trim().length() == 0) {
                procName = "%";
            }
            if (!procName.startsWith("[")) {
                this.mProcNameText.setText(procName);
            }
        }
        if (this.mShowOptionalTab) {
            String connProps = this.getNamedPropertyFromDriverInstance("connectionProps");
            if (connProps == null || connProps.trim().length() == 0) {
                connProps = EMPTY_STRING;
            }
            if (!connProps.startsWith("[")) {
                this.mDBConnProps.setSelection(connProps);
            }
        }
        this.fireChangedEvent((Object)this);
    }

    public String getNamedPropertyFromDriverInstance(String propertyName) {
        String returnStr = EMPTY_STRING;
        if (this.mDriverInstance != null && this.mDriverInstance.getNamedProperty(propertyName) != null) {
            returnStr = this.mDriverInstance.getNamedProperty(propertyName);
        }
        return returnStr;
    }

    protected Control createLabelTextPair(Composite parent, String labelText, Control ctl, int style, int gData) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(4, 0, false, false));
        label.setText(labelText);
        ctl = new Text(parent, style);
        ctl.setLayoutData((Object)new GridData(4, 0, true, false));
        return ctl;
    }

    public String getDriverClass() {
        if (this.mDriverInstance != null) {
            return this.mDriverInstance.getNamedProperty("Driver Class");
        }
        return EMPTY_STRING;
    }

    public String getDriverURL() {
        if (this.mDriverInstance != null) {
            return this.mDriverInstance.getNamedProperty("Connection URL");
        }
        return EMPTY_STRING;
    }

    public String getDBUID() {
        return this.mDBUIDText.getText();
    }

    public String getDBPWD() {
        return this.mDBPWDText.getText();
    }

    public String getDBConnProps() {
        if (this.mDBConnProps != null) {
            return this.mDBConnProps.getSelection();
        }
        return EMPTY_STRING;
    }

    public String getURL() {
        return this.mURLText.getText();
    }

    public String getDriverName() {
        return this.mDriverInstance.getName();
    }

    public String getDriverID() {
        return this.mDriverInstance.getId();
    }

    public String getDriverDefnId() {
        return this.mDriverInstance.getNamedProperty("org.eclipse.datatools.connectivity.drivers.defnType");
    }

    public String getCatalog() {
        if (this.mCatalogText != null) {
            return this.mCatalogText.getText();
        }
        return "%";
    }

    public String getSchema() {
        if (this.mSchemaText != null) {
            return this.mSchemaText.getText();
        }
        return "%";
    }

    public String getProcName() {
        if (this.mProcNameText != null) {
            return this.mProcNameText.getText();
        }
        return "%";
    }

    public String getDriverJarList() {
        return this.mDriverInstance.getJarList();
    }

    protected void initControls() {
        IConnectionProfile profile = this.getConnectionProfile();
        if (profile != null) {
            String procName;
            String schema;
            String catalog;
            String urlText;
            String databaseUid;
            String databasePwd;
            String connectionProps;
            String driverID = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
            if (driverID != null) {
                this.combo.setSelectionToID(driverID);
                this.combo.getCombo().redraw();
            }
            if ((connectionProps = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.connectionProperties")) != null && this.mDBConnProps != null) {
                this.mDBConnProps.setSelection(connectionProps);
            }
            if ((databasePwd = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.password")) != null) {
                this.mDBPWDText.setText(databasePwd);
            }
            if ((databaseUid = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.username")) != null) {
                this.mDBUIDText.setText(databaseUid);
            }
            if ((urlText = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.URL")) != null && this.mURLText != null) {
                this.mURLText.setText(urlText);
            }
            if ((catalog = profile.getBaseProperties().getProperty("org.eclipse.datatools.enablement.sybase.catalog")) != null && this.mCatalogText != null) {
                this.mCatalogText.setText(catalog);
            }
            if ((schema = profile.getBaseProperties().getProperty("org.eclipse.datatools.enablement.sybase.schema")) != null && this.mSchemaText != null) {
                this.mSchemaText.setText(schema);
            }
            if ((procName = profile.getBaseProperties().getProperty("org.eclipse.datatools.enablement.sybase.spName")) != null && this.mProcNameText != null) {
                this.mProcNameText.setText(procName);
            }
        }
        this.connTabComposite.layout();
        this.setErrorMessage(null);
    }

    protected Properties collectProperties() {
        Properties props = new Properties();
        String driverClass = EMPTY_STRING;
        String driverID = EMPTY_STRING;
        String driverDefnID = EMPTY_STRING;
        String catalog = "%";
        String schema = "%";
        String procName = "%";
        String host = EMPTY_STRING;
        String port = EMPTY_STRING;
        String url = EMPTY_STRING;
        String version = EMPTY_STRING;
        String vendor = EMPTY_STRING;
        if (this.combo.getSelectedDriverInstance() != null) {
            DriverInstance instance = this.combo.getSelectedDriverInstance();
            driverClass = instance.getNamedProperty("Driver Class");
            driverID = instance.getId();
            driverDefnID = this.getDriverDefnId();
            version = instance.getNamedProperty("Version");
            vendor = instance.getNamedProperty("Vendor");
        }
        if (this.mCatalogText != null && this.mCatalogText.getText() != null) {
            catalog = this.mCatalogText.getText();
        }
        if (this.mSchemaText != null && this.mSchemaText.getText() != null) {
            schema = this.mSchemaText.getText();
        }
        if (this.mProcNameText != null && this.mProcNameText.getText() != null) {
            procName = this.mProcNameText.getText();
        }
        url = this.mURLText != null && this.mURLText.getText() != null ? this.mURLText.getText() : this.getURL();
        props.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", driverID);
        if (driverDefnID.endsWith("mssql")) {
            props.setProperty("org.eclipse.datatools.enablement.sybase.multiDBIsSupported", "true");
        } else if (driverDefnID.indexOf("sybase_ase") > -1) {
            props.setProperty("org.eclipse.datatools.enablement.sybase.multiDBIsSupported", "true");
        } else {
            props.setProperty("org.eclipse.datatools.enablement.sybase.multiDBIsSupported", "false");
        }
        props.setProperty("org.eclipse.datatools.connectivity.db.driverClass", driverClass);
        props.setProperty("org.eclipse.datatools.enablement.sybase.catalog", catalog);
        props.setProperty("org.eclipse.datatools.enablement.sybase.schema", schema);
        props.setProperty("org.eclipse.datatools.enablement.sybase.spName", procName);
        props.setProperty("org.eclipse.datatools.connectivity.db.connectionProperties", this.mShowOptionalTab ? this.mDBConnProps.getSelection() : EMPTY_STRING);
        props.setProperty("org.eclipse.datatools.connectivity.db.password", this.mDBPWDText.getText());
        props.setProperty("org.eclipse.datatools.connectivity.db.username", this.mDBUIDText.getText());
        props.setProperty("org.eclipse.datatools.connectivity.db.URL", url);
        props.setProperty("org.eclipse.datatools.enablement.sybase.host", host);
        props.setProperty("org.eclipse.datatools.enablement.sybase.port", port);
        props.setProperty("org.eclipse.datatools.connectivity.db.vendor", vendor);
        props.setProperty("org.eclipse.datatools.connectivity.db.version", version);
        return props;
    }

    public Properties getProperties() {
        return this.collectProperties();
    }

    public boolean isValid() {
        boolean isDriverOK;
        boolean isURLOK = this.mURLText != null && this.mURLText.getText().trim().length() > 0;
        boolean isUIDOK = this.mDBUIDText != null && this.mDBUIDText.getText().trim().length() > 0;
        boolean bl = isDriverOK = this.combo.getErrorMessage() == null;
        if (isURLOK && isUIDOK && isDriverOK) {
            return true;
        }
        if (!isDriverOK) {
            this.setErrorMessage(this.combo.getErrorMessage());
        } else if (!isURLOK) {
            this.setErrorMessage(JDBCProfileMessages.getString("JDBCProfileTabs.errors.requiredURL"));
        }
        return false;
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this.changeListeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((ChangeListener)listeners[i]).stateChanged(e);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    public void dispose() {
        if (this.comboListener != null) {
            this.combo.removeChangeListener(this.comboListener);
        }
        super.dispose();
    }

    public DriverListCombo getDriverCombo() {
        return this.combo;
    }

    public boolean getShowFilterTab() {
        return this.mShowFilterTab;
    }

    public void setShowFilterTab(boolean flag) {
        this.mShowFilterTab = flag;
    }

    public boolean getShowOptionalTab() {
        return this.mShowOptionalTab;
    }

    public void setShowOptionalTab(boolean flag) {
        this.mShowOptionalTab = flag;
    }
}

