/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.input;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.input.ISQLBuilderEditorInputUsageOptions;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderStorageEditorInput;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderWindowStateFactory;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderWindowStateInput;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IOmitSchemaInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IWindowStateInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.OmitSchemaInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorage;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class SQLBuilderInputFactory
implements IElementFactory {
    public static final String ID_SQL_BUILDER_STORAGE_EDITOR_INPUT_FACTORY = "org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderInputFactory";
    public static final String ID_SQL_BUILDER_STORAGE_EDITOR_INPUT_TYPE = "SQLBuilderStorageEditorInput";
    public static final String ID_XML_MEMENTO_ROOT_ELEMENT = "SQLQueryBuilder";
    public static final String KEY_EDITOR_INPUT_TYPE = "editorInputType";
    public static final String KEY_STORAGE_NAME = "name";
    public static final String KEY_STORAGE_VERSION = "version";
    public static final String KEY_STORAGE_SQLCONTENT = "SQLStatement";
    public static final String KEY_CONN_INFO_CODE = "connInfo";
    public static final String KEY_OMIT_SCHEMA_INFO_CODE = "omitSchemaInfo";
    public static final String KEY_EDITOR_INPUT_OPTIONS_CODE = "editorInputUsageOptions";

    public IAdaptable createElement(IMemento memento) {
        if (memento == null) {
            return null;
        }
        SQLBuilderStorageEditorInput input = null;
        String editorInputType = memento.getString(KEY_EDITOR_INPUT_TYPE);
        if (editorInputType.equals(ID_SQL_BUILDER_STORAGE_EDITOR_INPUT_TYPE)) {
            SQLBuilderWindowStateFactory winStateFactory;
            SQLBuilderWindowStateInput windowStateInput;
            String omitSchemaInfoCode;
            String connInfoCode;
            String contentName = memento.getString(KEY_STORAGE_NAME);
            IMemento sqlStmtChild = memento.getChild(KEY_STORAGE_SQLCONTENT);
            String contentSQLStatement = "";
            if (sqlStmtChild != null && (contentSQLStatement = sqlStmtChild.getTextData()) == null) {
                contentSQLStatement = "";
            }
            SQLEditorStorage storage = new SQLEditorStorage(contentName, contentSQLStatement);
            SQLBuilderStorageEditorInput sqlStorageInput = new SQLBuilderStorageEditorInput((IStorage)storage);
            IMemento connInfoChild = memento.getChild(KEY_CONN_INFO_CODE);
            if (connInfoChild != null && (connInfoCode = connInfoChild.getTextData()) != null) {
                ISQLEditorConnectionInfo connInfo = null;
                connInfo = SQLEditorConnectionInfo.decode((String)connInfoCode);
                sqlStorageInput.setConnectionInfo(connInfo);
            }
            OmitSchemaInfo omitSchemaInfo = null;
            IMemento omitSchemaInfoChild = memento.getChild(KEY_OMIT_SCHEMA_INFO_CODE);
            if (omitSchemaInfoChild != null && (omitSchemaInfoCode = omitSchemaInfoChild.getTextData()) != null) {
                omitSchemaInfo = OmitSchemaInfo.decode(omitSchemaInfoCode);
                sqlStorageInput.setOmitSchemaInfo(omitSchemaInfo);
            }
            if ((windowStateInput = (SQLBuilderWindowStateInput)(winStateFactory = new SQLBuilderWindowStateFactory()).createElement(memento)) != null) {
                sqlStorageInput.setWindowStateInfo(windowStateInput.getWindowStateInfo());
            }
            input = sqlStorageInput;
        }
        return input;
    }

    public static void saveState(IMemento memento, SQLBuilderStorageEditorInput input) {
        IWindowStateInfo winStateInfo;
        ISQLBuilderEditorInputUsageOptions inputUsageOptions;
        IOmitSchemaInfo omitSchemaInfo;
        if (memento == null || input == null) {
            return;
        }
        memento.putString(KEY_EDITOR_INPUT_TYPE, ID_SQL_BUILDER_STORAGE_EDITOR_INPUT_TYPE);
        String storageName = null;
        IStorage storage = input.getStorage();
        if (storage != null) {
            storageName = storage.getName();
        }
        memento.putString(KEY_STORAGE_NAME, storageName);
        memento.putString(KEY_STORAGE_VERSION, "1.0");
        String storageContent = input.getSQL();
        IMemento sqlStmtChild = memento.createChild(KEY_STORAGE_SQLCONTENT);
        sqlStmtChild.putTextData(storageContent);
        ISQLEditorConnectionInfo connInfo = input.getConnectionInfo();
        if (connInfo != null) {
            String connInfoCode = connInfo.encode();
            IMemento connInfoChild = memento.createChild(KEY_CONN_INFO_CODE);
            connInfoChild.putTextData(connInfoCode);
        }
        if ((omitSchemaInfo = input.getOmitSchemaInfo()) != null) {
            String omitSchemaInfoCode = omitSchemaInfo.encode();
            IMemento omitSchemaInfoChild = memento.createChild(KEY_OMIT_SCHEMA_INFO_CODE);
            omitSchemaInfoChild.putTextData(omitSchemaInfoCode);
        }
        if ((inputUsageOptions = input.getInputUsageOptions()) != null) {
            String inputUsageOptionsCode = inputUsageOptions.encode();
            IMemento inputUsageOptionsChild = memento.createChild(KEY_EDITOR_INPUT_OPTIONS_CODE);
            inputUsageOptionsChild.putTextData(inputUsageOptionsCode);
        }
        if ((winStateInfo = input.getWindowStateInfo()) != null && (input.getInputUsageOptions() == null || input.getInputUsageOptions().useWindowState())) {
            SQLBuilderWindowStateInput windowStateInput = new SQLBuilderWindowStateInput(winStateInfo);
            SQLBuilderWindowStateFactory.saveState(memento, windowStateInput);
        }
    }
}

