/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class DiscoveryImages {
    private static final String T_OVR_32 = "ovr32";
    private static final String T_OBJ_16 = "obj16";
    private static final String T_WIZBAN = "wizban";
    private static final String T_TOOL = "etool16";
    private static final URL baseURL = Platform.getBundle((String)"org.eclipse.equinox.p2.ui.discovery").getEntry("/icons/");
    public static final ImageDescriptor OVERLAY_WARNING_32 = DiscoveryImages.create("ovr32", "message_warning.png");
    public static final ImageDescriptor BANNER_DISOVERY = DiscoveryImages.create("wizban", "banner-discovery.png");
    public static final ImageDescriptor IU_AVAILABLE = DiscoveryImages.create("obj16", "iu_disabled_obj.png");
    public static final ImageDescriptor IU_INSTALLED = DiscoveryImages.create("obj16", "iu_obj.png");
    public static final ImageDescriptor IU_UPDATABLE = DiscoveryImages.create("obj16", "iu_update_obj.png");
    public static final ImageDescriptor MESSAGE_INFO = DiscoveryImages.create("obj16", "message_info.png");
    public static final ImageDescriptor FIND_CLEAR = DiscoveryImages.create("etool16", "find-clear.gif");
    public static final ImageDescriptor FIND_CLEAR_DISABLED = DiscoveryImages.create("etool16", "find-clear-disabled.gif");
    private static ImageRegistry imageRegistry;

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)DiscoveryImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuilder buffer = new StringBuilder(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        ImageRegistry imageRegistry = DiscoveryImages.getImageRegistry();
        Image image = imageRegistry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage(true);
            imageRegistry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }
}

