/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.validation;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionList;
import org.eclipse.comma.actions.actions.ActionWithVars;
import org.eclipse.comma.actions.actions.ActionsPackage;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.actions.EventWithVars;
import org.eclipse.comma.actions.actions.IfAction;
import org.eclipse.comma.actions.actions.ParallelComposition;
import org.eclipse.comma.actions.actions.Reply;
import org.eclipse.comma.actions.actions.VariableDeclBlock;
import org.eclipse.comma.behavior.behavior.AbstractBehavior;
import org.eclipse.comma.behavior.behavior.BehaviorPackage;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.NonTriggeredTransition;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.scoping.BehaviorScopeProvider;
import org.eclipse.comma.behavior.validation.DataConstraintsValidator;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class BehaviorValidator
extends DataConstraintsValidator {
    public static final String STATEMACHINE_DUPLICATE_INTERFACE = "statemachine_duplicate_interface";
    public static final String STATEMACHINE_UNUSED_INTERFACE = "statemachine_unused_interface";
    public static final String STATEMACHINE_DUPLICATE_STATE = "statemachine_duplicate_state";
    public static final String STATEMACHINE_DUPLICATE_VAR = "statemachine_duplicate_var";
    public static final String STATEMACHINE_UNITIALIZED_VAR = "statemachine_uninitialized_var";
    public static final String STATEMACHINE_UNUSED_VAR = "statemachine_unused_var";

    @Check
    public void checkNotInitializedVariables(VariableDeclBlock block) {
        if (block instanceof AbstractBehavior) {
            super.checkNotInitializedVariables(block);
        }
    }

    @Check
    public void checkDuplicatedMachineNames(AbstractBehavior spec) {
        this.checkForNameDuplications((Iterable)spec.getMachines(), "state machine", null, new String[0]);
    }

    @Check
    public void checkDuplicateStateNames(AbstractBehavior spec) {
        Functions.Function1<StateMachine, EList<State>> _function = new Functions.Function1<StateMachine, EList<State>>(){

            public EList<State> apply(StateMachine it) {
                return it.getStates();
            }
        };
        this.checkForNameDuplications(Iterables.concat((Iterable)ListExtensions.map(spec.getMachines(), (Functions.Function1)_function)), "state", null, new String[0]);
    }

    @Check
    public void checkDuplicatePCFragmentNames(AbstractBehavior spec) {
        this.checkForNameDuplications((Iterable)spec.getFragments(), "event fragment", null, new String[0]);
    }

    @Check
    public void checkUnusedGlobalVariables(AbstractBehavior spec) {
        ArrayList variables = new ArrayList();
        variables.addAll(spec.getVars());
        Functions.Function1<ExpressionVariable, Variable> _function = new Functions.Function1<ExpressionVariable, Variable>(){

            public Variable apply(ExpressionVariable it) {
                return it.getVariable();
            }
        };
        variables.removeAll(ListExtensions.map((List)EcoreUtil2.getAllContentsOfType((EObject)spec, ExpressionVariable.class), (Functions.Function1)_function));
        for (Variable v : variables) {
            this.warning("Unused variable.", (EStructuralFeature)ActionsPackage.Literals.VARIABLE_DECL_BLOCK__VARS, spec.getVars().indexOf((Object)v));
        }
    }

    @Check
    public void checkVariableShadowing(ActionWithVars act) {
        int index;
        EObject pred = act.eContainer();
        if (pred instanceof ActionList && (index = ((ActionList)pred).getActions().indexOf((Object)act)) > 0) {
            pred = (EObject)((ActionList)pred).getActions().get(index - 1);
        }
        IScope visibleVars = ((BehaviorScopeProvider)this.scopeProvider).scope_variable(pred);
        EList _parameters = act.getParameters();
        for (Variable v : _parameters) {
            boolean _not;
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)visibleVars.getElements(QualifiedName.create((String)v.getName())));
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            this.error("Variable with this name is already defined", (EObject)v, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    @Check
    public void checkSilentTransitions(NonTriggeredTransition t) {
        EList<Clause> _clauses = t.getClauses();
        for (Clause c : _clauses) {
            boolean _not;
            boolean _hasEvent = this.hasEvent(c.getActions());
            boolean bl = _not = !_hasEvent;
            if (!_not) continue;
            this.error("The clause has an execution path without any event", t, (EStructuralFeature)BehaviorPackage.Literals.TRANSITION__CLAUSES, t.getClauses().indexOf((Object)c));
        }
    }

    public boolean hasEvent(ActionList actions) {
        if (actions == null) {
            return false;
        }
        EList _actions = actions.getActions();
        for (Action a : _actions) {
            boolean _matched = false;
            if (a instanceof EventWithVars || a instanceof Reply || a instanceof EventCall || a instanceof ParallelComposition) {
                _matched = true;
                return true;
            }
            if (_matched || !(a instanceof IfAction)) continue;
            _matched = true;
            if (!this.hasEvent(((IfAction)a).getThenList()) || !this.hasEvent(((IfAction)a).getElseList())) continue;
            return true;
        }
        return false;
    }
}

