/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.CSAbstractEditor;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.CompCSFormOutlinePage;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.CompCSInputContext;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.CompCSInputContextManager;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.CompCSPage;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class CompCSEditor
extends CSAbstractEditor {
    protected String getEditorID() {
        return "org.eclipse.pde.ua.ui.compositeCheatSheetEditor";
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public String getContextIDForSaveAs() {
        return "compcs-context";
    }

    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new CompCSPage((FormEditor)this));
        }
        catch (PartInitException e) {
            PDEUserAssistanceUIPlugin.logException(e);
        }
    }

    protected ISortableContentOutlinePage createContentOutline() {
        return new CompCSFormOutlinePage((PDEFormEditor)this);
    }

    protected InputContextManager createInputContextManager() {
        return new CompCSInputContextManager((PDEFormEditor)this);
    }

    protected void createResourceContexts(InputContextManager contexts, IFileEditorInput input) {
        contexts.putContext((IEditorInput)input, (InputContext)new CompCSInputContext((PDEFormEditor)this, (IEditorInput)input, true));
        contexts.monitorFile(input.getFile());
    }

    protected void createStorageContexts(InputContextManager contexts, IStorageEditorInput input) {
        contexts.putContext((IEditorInput)input, (InputContext)new CompCSInputContext((PDEFormEditor)this, (IEditorInput)input, true));
    }

    protected void createSystemFileContexts(InputContextManager contexts, FileStoreEditorInput input) {
        try {
            IFileStore store = EFS.getStore((URI)input.getURI());
            FileStoreEditorInput in = new FileStoreEditorInput(store);
            contexts.putContext((IEditorInput)in, (InputContext)new CompCSInputContext((PDEFormEditor)this, (IEditorInput)in, true));
        }
        catch (CoreException e) {
            PDEUserAssistanceUIPlugin.logException(e);
        }
    }

    public void editorContextAdded(InputContext context) {
    }

    protected InputContext getInputContext(Object object) {
        return this.fInputContextManager.findContext("compcs-context");
    }

    public void contextRemoved(InputContext context) {
        this.close(false);
    }

    public void monitoredFileAdded(IFile monitoredFile) {
    }

    public boolean monitoredFileRemoved(IFile monitoredFile) {
        return true;
    }

    public ISelection getSelection() {
        IFormPage formPage = this.getActivePageInstance();
        if (formPage != null && formPage instanceof CompCSPage) {
            return ((CompCSPage)formPage).getSelection();
        }
        return super.getSelection();
    }
}

