/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.types.utilities;

import java.util.Arrays;
import java.util.List;
import org.eclipse.comma.types.types.MapTypeConstructor;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class TypesComparator {
    public boolean sameAs(EObject o1, EObject o2) {
        boolean _xblockexpression = false;
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 != null) {
            Class<?> _class_1;
            boolean _tripleEquals;
            Class<?> _class = o1.getClass();
            boolean bl = _tripleEquals = _class == (_class_1 = o2.getClass());
            if (_tripleEquals) {
                return this.compare(o1, o2);
            }
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public boolean compareLists(List<? extends EObject> l1, List<? extends EObject> l2) {
        int _size_1;
        boolean _notEquals;
        boolean _xblockexpression = false;
        int _size = l1.size();
        boolean bl = _notEquals = _size != (_size_1 = l2.size());
        if (_notEquals) {
            return false;
        }
        int _size_2 = l1.size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size_2, true);
        for (Integer i : _doubleDotLessThan) {
            boolean _not;
            boolean _sameAs = this.sameAs(l1.get(i), l2.get(i));
            boolean bl2 = _not = !_sameAs;
            if (!_not) continue;
            return false;
        }
        _xblockexpression = true;
        return _xblockexpression;
    }

    public boolean compareListsAsSets(final List<? extends EObject> l1, final List<? extends EObject> l2) {
        return IterableExtensions.forall(l1, (Functions.Function1)new Functions.Function1<EObject, Boolean>(){

            public Boolean apply(final EObject itemL1) {
                Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

                    public Boolean apply(EObject itemL2) {
                        return TypesComparator.this.sameAs(itemL1, itemL2);
                    }
                };
                return IterableExtensions.exists((Iterable)l2, (Functions.Function1)_function);
            }
        }) && IterableExtensions.forall(l2, (Functions.Function1)new Functions.Function1<EObject, Boolean>(){

            public Boolean apply(final EObject itemL2) {
                Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

                    public Boolean apply(EObject itemL1) {
                        return TypesComparator.this.sameAs(itemL2, itemL1);
                    }
                };
                return IterableExtensions.exists((Iterable)l1, (Functions.Function1)_function);
            }
        });
    }

    protected boolean _compare(TypeDecl td1, TypeDecl td2) {
        return td1 == td2;
    }

    protected boolean _compare(TypeReference tr1, TypeReference tr2) {
        TypeDecl _type_1;
        TypeDecl _type = tr1.getType();
        return _type == (_type_1 = tr2.getType());
    }

    protected boolean _compare(VectorTypeConstructor t1, VectorTypeConstructor t2) {
        return t1.getType() == t2.getType() && t1.getDimensions().size() == t2.getDimensions().size();
    }

    protected boolean _compare(MapTypeConstructor t1, MapTypeConstructor t2) {
        return t1.getType() == t2.getType() && this.compare(t1.getValueType(), t2.getValueType());
    }

    public boolean compare(EObject t1, EObject t2) {
        if (t1 instanceof MapTypeConstructor && t2 instanceof MapTypeConstructor) {
            return this._compare((MapTypeConstructor)t1, (MapTypeConstructor)t2);
        }
        if (t1 instanceof TypeDecl && t2 instanceof TypeDecl) {
            return this._compare((TypeDecl)t1, (TypeDecl)t2);
        }
        if (t1 instanceof TypeReference && t2 instanceof TypeReference) {
            return this._compare((TypeReference)t1, (TypeReference)t2);
        }
        if (t1 instanceof VectorTypeConstructor && t2 instanceof VectorTypeConstructor) {
            return this._compare((VectorTypeConstructor)t1, (VectorTypeConstructor)t2);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t1, t2).toString());
    }
}

